/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import soot.NullType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.Stmt;
import soot.jimple.infoflow.Infoflow;
import soot.jimple.infoflow.collect.AtomicBitSet;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SourceContext;
import soot.jimple.infoflow.data.SourceContextAndPath;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.fastSolver.FastSolverLinkedNode;
import soot.jimple.internal.JimpleLocal;

public class Abstraction
implements Cloneable,
FastSolverLinkedNode<Abstraction, Unit> {
    private static boolean flowSensitiveAliasing = true;
    private final AccessPath accessPath;
    private Abstraction predecessor = null;
    private Set<Abstraction> neighbors = null;
    private Stmt currentStmt = null;
    private Stmt correspondingCallSite = null;
    private SourceContext sourceContext = null;
    private Set<SourceContextAndPath> pathCache = null;
    private Unit activationUnit = null;
    private boolean exceptionThrown = false;
    private int hashCode = 0;
    private List<IInfoflowCFG.UnitContainer> postdominators = null;
    private boolean isImplicit = false;
    private boolean dependsOnCutAP = false;
    private AtomicBitSet pathFlags = null;

    public Abstraction(AccessPath sourceVal, Stmt sourceStmt, Object userData, boolean exceptionThrown, boolean isImplicit) {
        this(sourceVal, new SourceContext(sourceVal, sourceStmt, userData), exceptionThrown, isImplicit);
    }

    protected Abstraction(AccessPath apToTaint, SourceContext sourceContext, boolean exceptionThrown, boolean isImplicit) {
        this.sourceContext = sourceContext;
        this.accessPath = apToTaint;
        this.activationUnit = null;
        this.exceptionThrown = exceptionThrown;
        this.neighbors = null;
        this.isImplicit = isImplicit;
        this.currentStmt = sourceContext == null ? null : sourceContext.getStmt();
    }

    protected Abstraction(AccessPath p, Abstraction original) {
        if (original == null) {
            this.sourceContext = null;
            this.exceptionThrown = false;
            this.activationUnit = null;
            this.isImplicit = false;
        } else {
            this.sourceContext = original.sourceContext;
            this.exceptionThrown = original.exceptionThrown;
            this.activationUnit = original.activationUnit;
            assert (this.activationUnit == null || flowSensitiveAliasing);
            this.postdominators = original.postdominators == null ? null : new ArrayList<IInfoflowCFG.UnitContainer>(original.postdominators);
            this.dependsOnCutAP = original.dependsOnCutAP;
            this.isImplicit = original.isImplicit;
        }
        this.accessPath = p;
        this.neighbors = null;
        this.currentStmt = null;
    }

    public final Abstraction deriveInactiveAbstraction(Unit activationUnit) {
        if (!flowSensitiveAliasing) {
            assert (this.isAbstractionActive());
            return this;
        }
        if (!this.isAbstractionActive()) {
            return this;
        }
        Abstraction a = this.deriveNewAbstractionMutable(this.accessPath, null);
        a.postdominators = null;
        a.activationUnit = activationUnit;
        a.dependsOnCutAP |= a.getAccessPath().isCutOffApproximation();
        return a;
    }

    public Abstraction deriveNewAbstraction(AccessPath p, Stmt currentStmt) {
        return this.deriveNewAbstraction(p, currentStmt, this.isImplicit);
    }

    public Abstraction deriveNewAbstraction(AccessPath p, Stmt currentStmt, boolean isImplicit) {
        if (this.accessPath.equals(p) && this.currentStmt == currentStmt && this.isImplicit == isImplicit) {
            return this;
        }
        Abstraction abs = this.deriveNewAbstractionMutable(p, currentStmt);
        abs.isImplicit = isImplicit;
        return abs;
    }

    private Abstraction deriveNewAbstractionMutable(AccessPath p, Stmt currentStmt) {
        if (this.accessPath.equals(p) && this.currentStmt == currentStmt) {
            Abstraction abs = this.clone();
            abs.currentStmt = currentStmt;
            return abs;
        }
        Abstraction abs = new Abstraction(p, this);
        abs.predecessor = this;
        abs.currentStmt = currentStmt;
        if (!abs.getAccessPath().isEmpty()) {
            abs.postdominators = null;
        }
        if (!abs.isAbstractionActive()) {
            abs.dependsOnCutAP = abs.dependsOnCutAP || p.isCutOffApproximation();
        }
        abs.sourceContext = null;
        return abs;
    }

    public final Abstraction deriveNewAbstraction(Value taint, boolean cutFirstField, Stmt currentStmt, Type baseType) {
        assert (!this.getAccessPath().isEmpty());
        AccessPath newAP = this.accessPath.copyWithNewValue(taint, baseType, cutFirstField);
        if (this.getAccessPath().equals(newAP) && this.currentStmt == currentStmt) {
            return this;
        }
        return this.deriveNewAbstractionMutable(newAP, currentStmt);
    }

    public final Abstraction deriveNewAbstractionOnThrow(Stmt throwStmt) {
        assert (!this.exceptionThrown);
        Abstraction abs = this.clone();
        abs.currentStmt = throwStmt;
        abs.sourceContext = null;
        abs.exceptionThrown = true;
        return abs;
    }

    public final Abstraction deriveNewAbstractionOnCatch(Value taint) {
        assert (this.exceptionThrown);
        Abstraction abs = this.deriveNewAbstractionMutable(new AccessPath(taint, true), null);
        abs.exceptionThrown = false;
        return abs;
    }

    public Set<SourceContextAndPath> getPaths() {
        return this.pathCache == null ? null : Collections.unmodifiableSet(this.pathCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SourceContextAndPath> getOrMakePathCache() {
        if (this.pathCache == null) {
            Abstraction abstraction = this;
            synchronized (abstraction) {
                if (this.pathCache == null) {
                    this.pathCache = new ConcurrentHashSet<SourceContextAndPath>();
                }
            }
        }
        return Collections.unmodifiableSet(this.pathCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPathElement(SourceContextAndPath scap) {
        if (this.pathCache == null) {
            Abstraction abstraction = this;
            synchronized (abstraction) {
                if (this.pathCache == null) {
                    this.pathCache = new ConcurrentHashSet<SourceContextAndPath>();
                }
            }
        }
        return this.pathCache.add(scap);
    }

    public void clearPathCache() {
        this.pathCache = null;
    }

    public boolean isAbstractionActive() {
        return this.activationUnit == null;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public String toString() {
        return (this.isAbstractionActive() ? "" : "_") + this.accessPath.toString() + " | " + (this.activationUnit == null ? "" : this.activationUnit.toString()) + ">>";
    }

    public AccessPath getAccessPath() {
        return this.accessPath;
    }

    public Unit getActivationUnit() {
        return this.activationUnit;
    }

    public Abstraction getActiveCopy() {
        assert (!this.isAbstractionActive());
        Abstraction a = this.clone();
        a.sourceContext = null;
        a.activationUnit = null;
        return a;
    }

    public boolean getExceptionThrown() {
        return this.exceptionThrown;
    }

    public final Abstraction deriveConditionalAbstractionEnter(IInfoflowCFG.UnitContainer postdom, Stmt conditionalUnit) {
        assert (this.isAbstractionActive());
        if (this.postdominators != null && this.postdominators.contains(postdom)) {
            return this;
        }
        Abstraction abs = this.deriveNewAbstractionMutable(AccessPath.getEmptyAccessPath(), conditionalUnit);
        if (abs.postdominators == null) {
            abs.postdominators = Collections.singletonList(postdom);
        } else {
            abs.postdominators.add(0, postdom);
        }
        return abs;
    }

    public final Abstraction deriveConditionalAbstractionCall(Unit conditionalCallSite) {
        assert (this.isAbstractionActive());
        assert (conditionalCallSite != null);
        Abstraction abs = this.deriveNewAbstractionMutable(AccessPath.getEmptyAccessPath(), (Stmt)conditionalCallSite);
        abs.postdominators = null;
        return abs;
    }

    public final Abstraction dropTopPostdominator() {
        if (this.postdominators == null || this.postdominators.isEmpty()) {
            return this;
        }
        Abstraction abs = this.clone();
        abs.sourceContext = null;
        abs.postdominators.remove(0);
        return abs;
    }

    public IInfoflowCFG.UnitContainer getTopPostdominator() {
        if (this.postdominators == null || this.postdominators.isEmpty()) {
            return null;
        }
        return this.postdominators.get(0);
    }

    public boolean isTopPostdominator(Unit u) {
        IInfoflowCFG.UnitContainer uc = this.getTopPostdominator();
        if (uc == null) {
            return false;
        }
        return uc.getUnit() == u;
    }

    public boolean isTopPostdominator(SootMethod sm) {
        IInfoflowCFG.UnitContainer uc = this.getTopPostdominator();
        if (uc == null) {
            return false;
        }
        return uc.getMethod() == sm;
    }

    public Abstraction clone() {
        Abstraction abs = new Abstraction(this.accessPath, this);
        abs.predecessor = this;
        abs.neighbors = null;
        abs.currentStmt = null;
        assert (abs.equals(this));
        return abs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Abstraction other = (Abstraction)obj;
        if (this.hashCode != 0 && other.hashCode != 0 && this.hashCode != other.hashCode) {
            return false;
        }
        if (this.accessPath == null ? other.accessPath != null : !this.accessPath.equals(other.accessPath)) {
            return false;
        }
        return this.localEquals(other);
    }

    private boolean localEquals(Abstraction other) {
        if (this.sourceContext == null ? other.sourceContext != null : !this.sourceContext.equals(other.sourceContext)) {
            return false;
        }
        if (this.activationUnit == null ? other.activationUnit != null : !this.activationUnit.equals(other.activationUnit)) {
            return false;
        }
        if (this.exceptionThrown != other.exceptionThrown) {
            return false;
        }
        if (this.postdominators == null ? other.postdominators != null : !this.postdominators.equals(other.postdominators)) {
            return false;
        }
        if (this.dependsOnCutAP != other.dependsOnCutAP) {
            return false;
        }
        return this.isImplicit == other.isImplicit;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sourceContext == null ? 0 : this.sourceContext.hashCode());
        result = 31 * result + (this.accessPath == null ? 0 : this.accessPath.hashCode());
        result = 31 * result + (this.activationUnit == null ? 0 : this.activationUnit.hashCode());
        result = 31 * result + (this.exceptionThrown ? 1231 : 1237);
        result = 31 * result + (this.postdominators == null ? 0 : this.postdominators.hashCode());
        result = 31 * result + (this.dependsOnCutAP ? 1231 : 1237);
        this.hashCode = result = 31 * result + (this.isImplicit ? 1231 : 1237);
        return this.hashCode;
    }

    public boolean entails(Abstraction other) {
        if (this.accessPath == null ? other.accessPath != null : !this.accessPath.entails(other.accessPath)) {
            return false;
        }
        return this.localEquals(other);
    }

    public SourceContext getSourceContext() {
        return this.sourceContext;
    }

    public boolean dependsOnCutAP() {
        return this.dependsOnCutAP;
    }

    @Override
    public Abstraction getPredecessor() {
        return this.predecessor;
    }

    public Set<Abstraction> getNeighbors() {
        return this.neighbors;
    }

    public Stmt getCurrentStmt() {
        return this.currentStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNeighbor(Abstraction originalAbstraction) {
        if (originalAbstraction == this) {
            return;
        }
        if (this.predecessor == originalAbstraction.predecessor && this.currentStmt == originalAbstraction.currentStmt && this.predecessor == originalAbstraction.predecessor) {
            return;
        }
        Abstraction abstraction = this;
        synchronized (abstraction) {
            if (this.neighbors == null) {
                this.neighbors = Sets.newIdentityHashSet();
            } else if (Infoflow.getMergeNeighbors()) {
                for (Abstraction nb : this.neighbors) {
                    if (nb == originalAbstraction) {
                        return;
                    }
                    if (originalAbstraction.predecessor != nb.predecessor || originalAbstraction.currentStmt != nb.currentStmt || originalAbstraction.predecessor != nb.predecessor) continue;
                    return;
                }
            }
            this.neighbors.add(originalAbstraction);
        }
    }

    public void setCorrespondingCallSite(Stmt callSite) {
        this.correspondingCallSite = callSite;
    }

    public Stmt getCorrespondingCallSite() {
        return this.correspondingCallSite;
    }

    public static Abstraction getZeroAbstraction(boolean flowSensitiveAliasing) {
        Abstraction zeroValue = new Abstraction(new AccessPath(new JimpleLocal("zero", NullType.v()), false), null, false, false);
        Abstraction.flowSensitiveAliasing = flowSensitiveAliasing;
        return zeroValue;
    }

    @Override
    public void setPredecessor(Abstraction predecessor) {
        this.predecessor = predecessor;
    }

    @Override
    public void setCallingContext(Abstraction callingContext) {
    }

    public void setSourceContext(SourceContext sourceContext) {
        this.sourceContext = sourceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerPathFlag(int id, int maxSize) {
        if (this.pathFlags != null && id < this.pathFlags.size() && this.pathFlags.get(id)) {
            return false;
        }
        if (this.pathFlags == null) {
            Abstraction abstraction = this;
            synchronized (abstraction) {
                if (this.pathFlags == null) {
                    AtomicBitSet pf;
                    this.pathFlags = pf = new AtomicBitSet(maxSize);
                }
            }
        }
        return this.pathFlags.set(id);
    }

    public Abstraction injectSourceContext(SourceContext sourceContext) {
        if (this.sourceContext != null && this.sourceContext.equals(sourceContext)) {
            return this;
        }
        Abstraction abs = this.clone();
        abs.predecessor = null;
        abs.neighbors = null;
        abs.sourceContext = sourceContext;
        abs.currentStmt = this.currentStmt;
        return abs;
    }
}

