/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import soot.ArrayType;
import soot.Local;
import soot.RefType;
import soot.SootField;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.ConcreteRef;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.infoflow.Infoflow;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;

public class AccessPath
implements Cloneable {
    private final Local value;
    private final SootField[] fields;
    private final Type baseType;
    private final Type[] fieldTypes;
    private final boolean taintSubFields;
    private final boolean cutOffApproximation;
    private int hashCode;
    private static MyConcurrentHashMap<Type, Set<BasePair>> baseRegister = new MyConcurrentHashMap();
    private static final AccessPath emptyAccessPath = new AccessPath();

    private AccessPath() {
        this.hashCode = 0;
        this.value = null;
        this.fields = null;
        this.baseType = null;
        this.fieldTypes = null;
        this.taintSubFields = true;
        this.cutOffApproximation = false;
    }

    public AccessPath(Value val, boolean taintSubFields) {
        this(val, null, null, null, taintSubFields);
    }

    public AccessPath(Value val, SootField[] appendingFields, boolean taintSubFields) {
        this(val, appendingFields, null, null, taintSubFields);
    }

    public AccessPath(Value val, SootField[] appendingFields, Type valType, Type[] appendingFieldTypes, boolean taintSubFields) {
        this(val, appendingFields, valType, appendingFieldTypes, taintSubFields, false, true);
    }

    public AccessPath(Value val, SootField[] appendingFields, Type valType, Type[] appendingFieldTypes, boolean taintSubFields, boolean cutFirstField, boolean reduceBases) {
        Type[] fieldTypes;
        SootField[] fields;
        ConcreteRef ref;
        this.hashCode = 0;
        assert (val == null && appendingFields != null && appendingFields.length > 0 || AccessPath.canContainValue(val));
        if (appendingFields != null && appendingFieldTypes == null) {
            appendingFieldTypes = new Type[appendingFields.length];
            for (int i = 0; i < appendingFields.length; ++i) {
                appendingFieldTypes[i] = appendingFields[i].getType();
            }
        }
        if (val instanceof FieldRef) {
            ref = (FieldRef)val;
            if (val instanceof InstanceFieldRef) {
                InstanceFieldRef iref = (InstanceFieldRef)val;
                this.value = (Local)iref.getBase();
                this.baseType = this.value.getType();
            } else {
                this.value = null;
                this.baseType = null;
            }
            fields = new SootField[(appendingFields == null ? 0 : appendingFields.length) + 1];
            fields[0] = ref.getField();
            if (appendingFields != null) {
                System.arraycopy(appendingFields, 0, fields, 1, appendingFields.length);
            }
            fieldTypes = new Type[(appendingFieldTypes == null ? 0 : appendingFieldTypes.length) + 1];
            Type type = fieldTypes[0] = valType != null ? valType : fields[0].getType();
            if (appendingFieldTypes != null) {
                System.arraycopy(appendingFieldTypes, 0, fieldTypes, 1, appendingFieldTypes.length);
            }
        } else if (val instanceof ArrayRef) {
            ref = (ArrayRef)val;
            this.value = (Local)ref.getBase();
            this.baseType = valType == null ? this.value.getType() : valType;
            fields = appendingFields;
            fieldTypes = appendingFieldTypes;
        } else {
            this.value = (Local)val;
            this.baseType = valType == null ? (this.value == null ? null : this.value.getType()) : valType;
            fields = appendingFields;
            fieldTypes = appendingFieldTypes;
        }
        if (Infoflow.getAccessPathLength() == 0) {
            fields = null;
            fieldTypes = null;
        }
        if (cutFirstField && fields != null && fields.length > 0) {
            SootField[] newFields = new SootField[fields.length - 1];
            Type[] newTypes = new Type[newFields.length];
            System.arraycopy(fields, 1, newFields, 0, newFields.length);
            System.arraycopy(fieldTypes, 1, newTypes, 0, newTypes.length);
            fields = newFields.length > 0 ? newFields : null;
            Object object = fieldTypes = newTypes.length > 0 ? newTypes : null;
        }
        assert (this.value == null || this.value.getType() instanceof RefType || this.value.getType() instanceof ArrayType || fields == null || fields.length == 0);
        boolean recursiveCutOff = false;
        if (Infoflow.getUseRecursiveAccessPaths() && reduceBases && fields != null) {
            int ei;
            int n = ei = val instanceof StaticFieldRef ? 1 : 0;
            while (ei < fields.length) {
                Type eiType = ei == 0 ? this.baseType : fieldTypes[ei - 1];
                int ej = ei;
                while (ej < fields.length) {
                    if (fieldTypes[ej] == eiType) {
                        SootField[] newFields = new SootField[fields.length - (ej - ei) - 1];
                        Type[] newTypes = new Type[newFields.length];
                        System.arraycopy(fields, 0, newFields, 0, ei);
                        System.arraycopy(fieldTypes, 0, newTypes, 0, ei);
                        if (fields.length > ej) {
                            System.arraycopy(fields, ej + 1, newFields, ei, fields.length - ej - 1);
                            System.arraycopy(fieldTypes, ej + 1, newTypes, ei, fieldTypes.length - ej - 1);
                        }
                        SootField[] base = new SootField[ej - ei + 1];
                        Type[] baseTypes = new Type[ej - ei + 1];
                        System.arraycopy(fields, ei, base, 0, base.length);
                        System.arraycopy(fieldTypes, ei, baseTypes, 0, base.length);
                        AccessPath.registerBase(eiType, base, baseTypes);
                        fields = newFields;
                        fieldTypes = newTypes;
                        recursiveCutOff = true;
                        continue;
                    }
                    ++ej;
                }
                ++ei;
            }
        }
        if (fields != null) {
            int fieldNum = Math.min(Infoflow.getAccessPathLength(), fields.length);
            if (fields.length > fieldNum) {
                this.taintSubFields = true;
                this.cutOffApproximation = true;
            } else {
                this.taintSubFields = taintSubFields;
                this.cutOffApproximation = recursiveCutOff;
            }
            if (fieldNum == 0) {
                this.fields = null;
                this.fieldTypes = null;
            } else {
                this.fields = new SootField[fieldNum];
                this.fieldTypes = new Type[fieldNum];
                System.arraycopy(fields, 0, this.fields, 0, fieldNum);
                System.arraycopy(fieldTypes, 0, this.fieldTypes, 0, fieldNum);
            }
        } else {
            this.taintSubFields = taintSubFields;
            this.cutOffApproximation = false;
            this.fields = null;
            this.fieldTypes = null;
        }
        assert (this.value == null || this.baseType instanceof ArrayType || this.baseType instanceof RefType && ((RefType)this.baseType).getSootClass().getName().equals("java.lang.Object") || this.baseType instanceof RefType && ((RefType)this.baseType).getSootClass().getName().equals("java.io.Serializable") || this.baseType instanceof RefType && ((RefType)this.baseType).getSootClass().getName().equals("java.lang.Cloneable") || !(this.value.getType() instanceof ArrayType));
        assert (this.value == null || !(this.baseType instanceof ArrayType) || this.value.getType() instanceof ArrayType || this.value.getType() instanceof RefType && ((RefType)this.value.getType()).getSootClass().getName().equals("java.lang.Object") || this.value.getType() instanceof RefType && ((RefType)this.value.getType()).getSootClass().getName().equals("java.io.Serializable") || this.value.getType() instanceof RefType && ((RefType)this.value.getType()).getSootClass().getName().equals("java.lang.Cloneable")) : "Type mismatch. Type was " + this.baseType + ", value was: " + (this.value == null ? null : this.value.getType());
        assert (!this.isEmpty() || this.baseType == null);
    }

    public AccessPath(SootField staticfield, boolean taintSubFields) {
        this(null, new SootField[]{staticfield}, null, new Type[]{staticfield.getType()}, taintSubFields);
    }

    public AccessPath(Value base, SootField field, boolean taintSubFields) {
        Type[] typeArray;
        SootField[] sootFieldArray;
        if (field == null) {
            sootFieldArray = null;
        } else {
            SootField[] sootFieldArray2 = new SootField[1];
            sootFieldArray = sootFieldArray2;
            sootFieldArray2[0] = field;
        }
        if (field == null) {
            typeArray = null;
        } else {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = field.getType();
        }
        this(base, sootFieldArray, null, typeArray, taintSubFields);
        assert (base instanceof Local);
    }

    private static void registerBase(Type eiType, SootField[] base, Type[] baseTypes) {
        assert (base.length == baseTypes.length);
        for (int i = 0; i < base.length; ++i) {
            if (baseTypes[i] != eiType) continue;
            SootField[] newBase = new SootField[i + 1];
            Type[] newTypes = new Type[i + 1];
            System.arraycopy(base, 0, newBase, 0, i + 1);
            System.arraycopy(baseTypes, 0, newTypes, 0, i + 1);
            base = newBase;
            baseTypes = newTypes;
            break;
        }
        Set bases = baseRegister.putIfAbsentElseGet(eiType, new ConcurrentHashSet());
        bases.add(new BasePair(base, baseTypes));
    }

    public static void clearBaseRegister() {
        baseRegister.clear();
    }

    public static Collection<BasePair> getBaseForType(Type tp) {
        return (Collection)baseRegister.get(tp);
    }

    public static boolean canContainValue(Value val) {
        return val instanceof Local || val instanceof InstanceFieldRef || val instanceof StaticFieldRef || val instanceof ArrayRef;
    }

    public Local getPlainValue() {
        return this.value;
    }

    public SootField getLastField() {
        if (this.fields == null || this.fields.length == 0) {
            return null;
        }
        return this.fields[this.fields.length - 1];
    }

    public Type getLastFieldType() {
        if (this.fieldTypes == null || this.fieldTypes.length == 0) {
            return this.baseType;
        }
        return this.fieldTypes[this.fieldTypes.length - 1];
    }

    public SootField getFirstField() {
        if (this.fields == null || this.fields.length == 0) {
            return null;
        }
        return this.fields[0];
    }

    public boolean firstFieldMatches(SootField field) {
        if (this.fields == null || this.fields.length == 0) {
            return false;
        }
        return field == this.fields[0];
    }

    public Type getFirstFieldType() {
        if (this.fieldTypes == null || this.fieldTypes.length == 0) {
            return null;
        }
        return this.fieldTypes[0];
    }

    public SootField[] getFields() {
        return this.fields;
    }

    public Type[] getFieldTypes() {
        return this.fieldTypes;
    }

    public int getFieldCount() {
        return this.fields == null ? 0 : this.fields.length;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fields == null ? 0 : Arrays.hashCode(this.fields));
        result = 31 * result + (this.fieldTypes == null ? 0 : Arrays.hashCode(this.fieldTypes));
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.baseType == null ? 0 : this.baseType.hashCode());
        this.hashCode = result = 31 * result + (this.taintSubFields ? 1 : 0);
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this || super.equals(obj)) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPath other = (AccessPath)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.baseType == null ? other.baseType != null : !this.baseType.equals(other.baseType)) {
            return false;
        }
        if (this.taintSubFields != other.taintSubFields) {
            return false;
        }
        if (!Arrays.equals(this.fields, other.fields)) {
            return false;
        }
        if (!Arrays.equals(this.fieldTypes, other.fieldTypes)) {
            return false;
        }
        assert (this.hashCode() == obj.hashCode());
        return true;
    }

    public boolean isStaticFieldRef() {
        return this.value == null && this.fields != null && this.fields.length > 0;
    }

    public boolean isInstanceFieldRef() {
        return this.value != null && this.fields != null && this.fields.length > 0;
    }

    public boolean isFieldRef() {
        return this.fields != null && this.fields.length > 0;
    }

    public boolean isLocal() {
        return this.value != null && this.value instanceof Local && (this.fields == null || this.fields.length == 0);
    }

    public String toString() {
        String str = "";
        if (this.value != null) {
            str = str + this.value.toString() + "(" + this.value.getType() + ")";
        }
        if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i] == null) continue;
                if (!str.isEmpty()) {
                    str = str + " ";
                }
                str = str + this.fields[i];
            }
        }
        if (this.taintSubFields) {
            str = str + " *";
        }
        return str;
    }

    public AccessPath copyWithNewValue(Value val) {
        return this.copyWithNewValue(val, this.baseType, false);
    }

    public AccessPath copyWithNewValue(Value val, Type newType, boolean cutFirstField) {
        if (this.value != null && this.value.equals(val) && this.baseType.equals(newType)) {
            return this;
        }
        return new AccessPath(val, this.fields, newType, this.fieldTypes, this.taintSubFields, cutFirstField, true);
    }

    public AccessPath clone() {
        if (this == emptyAccessPath) {
            return this;
        }
        AccessPath a = new AccessPath(this.value, this.fields, this.baseType, this.fieldTypes, this.taintSubFields);
        assert (a.equals(this));
        return a;
    }

    public static AccessPath getEmptyAccessPath() {
        return emptyAccessPath;
    }

    public boolean isEmpty() {
        return this.value == null && (this.fields == null || this.fields.length == 0);
    }

    public boolean entails(AccessPath a2) {
        if (this.isEmpty() || a2.isEmpty()) {
            return false;
        }
        if (this.value != null && a2.value == null || this.value == null && a2.value != null) {
            return false;
        }
        if (this.value != null && !this.value.equals(a2.value)) {
            return false;
        }
        if (this.fields != null && a2.fields != null) {
            if (this.fields.length > a2.fields.length) {
                return false;
            }
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i].equals(a2.fields[i])) continue;
                return false;
            }
        }
        return true;
    }

    public AccessPath merge(AccessPath ap) {
        return this.appendFields(ap.fields, ap.fieldTypes, ap.taintSubFields);
    }

    public AccessPath appendFields(SootField[] apFields, Type[] apFieldTypes, boolean taintSubFields) {
        int offset = this.fields == null ? 0 : this.fields.length;
        SootField[] fields = new SootField[offset + (apFields == null ? 0 : apFields.length)];
        Type[] fieldTypes = new Type[offset + (apFields == null ? 0 : apFields.length)];
        if (this.fields != null) {
            System.arraycopy(this.fields, 0, fields, 0, this.fields.length);
            System.arraycopy(this.fieldTypes, 0, fieldTypes, 0, this.fieldTypes.length);
        }
        if (apFields != null && apFields.length > 0) {
            System.arraycopy(apFields, 0, fields, offset, apFields.length);
            System.arraycopy(apFieldTypes, 0, fieldTypes, offset, apFieldTypes.length);
        }
        return new AccessPath(this.value, fields, this.baseType, fieldTypes, taintSubFields);
    }

    public AccessPath dropFirstField() {
        Type[] newTypes;
        SootField[] newFields;
        if (this.fields == null || this.fields.length == 0) {
            return this;
        }
        if (this.fields.length > 1) {
            newFields = new SootField[this.fields.length - 1];
            System.arraycopy(this.fields, 1, newFields, 0, this.fields.length - 1);
            newTypes = new Type[this.fields.length - 1];
            System.arraycopy(this.fieldTypes, 1, newTypes, 0, this.fields.length - 1);
        } else {
            newFields = null;
            newTypes = null;
        }
        return new AccessPath(this.value, newFields, this.fieldTypes[0], newTypes, this.taintSubFields);
    }

    public AccessPath dropLastField() {
        Type[] newTypes;
        SootField[] newFields;
        if (this.fields == null || this.fields.length == 0) {
            return this;
        }
        if (this.fields.length > 1) {
            newFields = new SootField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, newFields, 0, this.fields.length - 1);
            newTypes = new Type[this.fields.length - 1];
            System.arraycopy(this.fieldTypes, 0, newTypes, 0, this.fields.length - 1);
        } else {
            newFields = null;
            newTypes = null;
        }
        return new AccessPath(this.value, newFields, this.baseType, newTypes, this.taintSubFields);
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public boolean getTaintSubFields() {
        return this.taintSubFields;
    }

    public boolean isCutOffApproximation() {
        return this.cutOffApproximation;
    }

    public static class BasePair {
        private final SootField[] fields;
        private final Type[] types;
        private int hashCode = 0;

        public BasePair(SootField[] fields, Type[] types) {
            this.fields = fields;
            this.types = types;
            if (fields == null || fields.length == 0) {
                throw new RuntimeException("A base must contain at least one field");
            }
        }

        public SootField[] getFields() {
            return this.fields;
        }

        public Type[] getTypes() {
            return this.types;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int prime = 31;
                int result = 1;
                result = 31 * result + Arrays.hashCode(this.fields);
                this.hashCode = result = 31 * result + Arrays.hashCode(this.types);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BasePair other = (BasePair)obj;
            if (!Arrays.equals(this.fields, other.fields)) {
                return false;
            }
            return Arrays.equals(this.types, other.types);
        }

        public String toString() {
            return Arrays.toString(this.fields);
        }
    }
}

