/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import heros.solver.CountingThreadPoolExecutor;
import heros.solver.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.SourceContextAndPath;
import soot.jimple.infoflow.data.pathBuilders.AbstractAbstractionPathBuilder;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;

public class RecursivePathBuilder
extends AbstractAbstractionPathBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InfoflowResults results = new InfoflowResults();
    private final CountingThreadPoolExecutor executor;
    private static int lastTaskId = 0;

    public RecursivePathBuilder(IInfoflowCFG icfg, int maxThreadNum, boolean reconstructPaths) {
        super(icfg, reconstructPaths);
        int numThreads = Runtime.getRuntime().availableProcessors();
        this.executor = this.createExecutor(maxThreadNum == -1 ? numThreads : Math.min(maxThreadNum, numThreads));
    }

    private CountingThreadPoolExecutor createExecutor(int numThreads) {
        return new CountingThreadPoolExecutor(numThreads, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    private Set<SourceContextAndPath> getPaths(int taskId, Abstraction curAbs, Stack<Pair<Stmt, Set<Abstraction>>> callStack) {
        Set<Abstraction> callAbs;
        Pair<Stmt, Set<Abstraction>> stackTop;
        HashSet<SourceContextAndPath> cacheData = new HashSet<SourceContextAndPath>();
        Pair<Stmt, Set<Abstraction>> pair = stackTop = callStack.isEmpty() ? null : callStack.peek();
        if (stackTop != null && !(callAbs = stackTop.getO2()).add(curAbs)) {
            return Collections.emptySet();
        }
        if (curAbs.getSourceContext() != null) {
            SourceContextAndPath sourceAndPath = new SourceContextAndPath(curAbs.getSourceContext().getAccessPath(), curAbs.getSourceContext().getStmt(), curAbs.getSourceContext().getUserData()).extendPath(curAbs);
            cacheData.add(sourceAndPath);
            assert (curAbs.getPredecessor() == null);
        } else {
            Stack<Pair<Stmt, Set<Abstraction>>> newCallStack = new Stack<Pair<Stmt, Set<Abstraction>>>();
            newCallStack.addAll(callStack);
            if (curAbs.getCorrespondingCallSite() != null) {
                newCallStack.push(new Pair(curAbs.getCorrespondingCallSite(), Collections.newSetFromMap(new IdentityHashMap())));
            }
            boolean isMethodEnter = curAbs.getCurrentStmt() != null && curAbs.getCurrentStmt().containsInvokeExpr();
            boolean scanPreds = true;
            if (isMethodEnter && !newCallStack.isEmpty()) {
                Pair newStackTop;
                Pair pair2 = newStackTop = newCallStack.isEmpty() ? null : (Pair)newCallStack.peek();
                if (newStackTop != null && newStackTop.getO1() != null) {
                    if (curAbs.getCurrentStmt() != newStackTop.getO1()) {
                        scanPreds = false;
                    }
                    newCallStack.pop();
                }
            }
            if (scanPreds) {
                for (SourceContextAndPath curScap : this.getPaths(taskId, curAbs.getPredecessor(), newCallStack)) {
                    SourceContextAndPath extendedPath = curScap.extendPath(curAbs, this.reconstructPaths);
                    if (extendedPath == null) continue;
                    cacheData.add(extendedPath);
                }
            }
        }
        if (curAbs.getNeighbors() != null) {
            for (Abstraction nb : curAbs.getNeighbors()) {
                for (SourceContextAndPath path : this.getPaths(taskId, nb, callStack)) {
                    cacheData.add(path);
                }
            }
        }
        return Collections.unmodifiableSet(cacheData);
    }

    private void computeTaintPathsInternal(Set<AbstractionAtSink> res) {
        this.logger.debug("Running path reconstruction");
        this.logger.info("Obtainted {} connections between sources and sinks", (Object)res.size());
        int curResIdx = 0;
        for (final AbstractionAtSink abs : res) {
            this.logger.info("Building path " + ++curResIdx);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Stack initialStack = new Stack();
                    initialStack.push(new Pair(null, Collections.newSetFromMap(new IdentityHashMap())));
                    for (SourceContextAndPath context : RecursivePathBuilder.this.getPaths(lastTaskId++, abs.getAbstraction(), initialStack)) {
                        ArrayList<Stmt> newPath = new ArrayList<Stmt>(context.getPath());
                        newPath.add(abs.getSinkStmt());
                        RecursivePathBuilder.this.results.addResult(abs.getAbstraction().getAccessPath(), abs.getSinkStmt(), context.getAccessPath(), context.getStmt(), context.getUserData(), newPath);
                    }
                }
            });
        }
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException ex) {
            this.logger.error("Could not wait for path executor completion: {0}", (Object)ex.getMessage());
            ex.printStackTrace();
        }
        this.executor.shutdown();
        this.logger.debug("Path reconstruction done.");
    }

    @Override
    public void computeTaintPaths(Set<AbstractionAtSink> res) {
        this.computeTaintPathsInternal(res);
    }

    @Override
    public InfoflowResults getResults() {
        return this.results;
    }

    @Override
    public void shutdown() {
    }
}

