/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.entryPointCreators;

import java.util.Arrays;
import java.util.List;

public class AndroidEntryPointConstants {
    public static final String ACTIVITYCLASS = "android.app.Activity";
    public static final String SERVICECLASS = "android.app.Service";
    public static final String GCMBASEINTENTSERVICECLASS = "com.google.android.gcm.GCMBaseIntentService";
    public static final String BROADCASTRECEIVERCLASS = "android.content.BroadcastReceiver";
    public static final String CONTENTPROVIDERCLASS = "android.content.ContentProvider";
    public static final String APPLICATIONCLASS = "android.app.Application";
    public static final String ACTIVITY_ONCREATE = "void onCreate(android.os.Bundle)";
    public static final String ACTIVITY_ONSTART = "void onStart()";
    public static final String ACTIVITY_ONRESTOREINSTANCESTATE = "void onRestoreInstanceState(android.os.Bundle)";
    public static final String ACTIVITY_ONPOSTCREATE = "void onPostCreate(android.os.Bundle)";
    public static final String ACTIVITY_ONRESUME = "void onResume()";
    public static final String ACTIVITY_ONPOSTRESUME = "void onPostResume()";
    public static final String ACTIVITY_ONCREATEDESCRIPTION = "java.lang.CharSequence onCreateDescription()";
    public static final String ACTIVITY_ONSAVEINSTANCESTATE = "void onSaveInstanceState(android.os.Bundle)";
    public static final String ACTIVITY_ONPAUSE = "void onPause()";
    public static final String ACTIVITY_ONSTOP = "void onStop()";
    public static final String ACTIVITY_ONRESTART = "void onRestart()";
    public static final String ACTIVITY_ONDESTROY = "void onDestroy()";
    public static final String SERVICE_ONCREATE = "void onCreate()";
    public static final String SERVICE_ONSTART1 = "void onStart(android.content.Intent,int)";
    public static final String SERVICE_ONSTART2 = "int onStartCommand(android.content.Intent,int,int)";
    public static final String SERVICE_ONBIND = "android.os.IBinder onBind(android.content.Intent)";
    public static final String SERVICE_ONREBIND = "void onRebind(android.content.Intent)";
    public static final String SERVICE_ONUNBIND = "boolean onUnbind(android.content.Intent)";
    public static final String SERVICE_ONDESTROY = "void onDestroy()";
    public static final String GCMINTENTSERVICE_ONDELETEDMESSAGES = "void onDeletedMessages(android.content.Context,int)";
    public static final String GCMINTENTSERVICE_ONERROR = "void onError(android.content.Context,java.lang.String)";
    public static final String GCMINTENTSERVICE_ONMESSAGE = "void onMessage(android.content.Context,android.content.Intent)";
    public static final String GCMINTENTSERVICE_ONRECOVERABLEERROR = "void onRecoverableError(android.content.Context,java.lang.String)";
    public static final String GCMINTENTSERVICE_ONREGISTERED = "void onRegistered(android.content.Context,java.lang.String)";
    public static final String GCMINTENTSERVICE_ONUNREGISTERED = "void onUnregistered(android.content.Context,java.lang.String)";
    public static final String BROADCAST_ONRECEIVE = "void onReceive(android.content.Context,android.content.Intent)";
    public static final String CONTENTPROVIDER_ONCREATE = "boolean onCreate()";
    public static final String APPLICATION_ONCREATE = "void onCreate()";
    public static final String APPLICATION_ONTERMINATE = "void onTerminate()";
    public static final String APPLIFECYCLECALLBACK_ONACTIVITYSTARTED = "void onActivityStarted(android.app.Activity)";
    public static final String APPLIFECYCLECALLBACK_ONACTIVITYSTOPPED = "void onActivityStopped(android.app.Activity)";
    public static final String APPLIFECYCLECALLBACK_ONACTIVITYSAVEINSTANCESTATE = "void onActivitySaveInstanceState(android.app.Activity,android.os.Bundle)";
    public static final String APPLIFECYCLECALLBACK_ONACTIVITYRESUMED = "void onActivityResumed(android.app.Activity)";
    public static final String APPLIFECYCLECALLBACK_ONACTIVITYPAUSED = "void onActivityPaused(android.app.Activity)";
    public static final String APPLIFECYCLECALLBACK_ONACTIVITYDESTROYED = "void onActivityDestroyed(android.app.Activity)";
    public static final String APPLIFECYCLECALLBACK_ONACTIVITYCREATED = "void onActivityCreated(android.app.Activity,android.os.Bundle)";
    private static final String[] activityMethods = new String[]{"void onCreate(android.os.Bundle)", "void onDestroy()", "void onPause()", "void onRestart()", "void onResume()", "void onStart()", "void onStop()", "void onSaveInstanceState(android.os.Bundle)", "void onRestoreInstanceState(android.os.Bundle)", "java.lang.CharSequence onCreateDescription()", "void onPostCreate(android.os.Bundle)", "void onPostResume()"};
    private static final String[] serviceMethods = new String[]{"void onCreate()", "void onDestroy()", "void onStart(android.content.Intent,int)", "int onStartCommand(android.content.Intent,int,int)", "android.os.IBinder onBind(android.content.Intent)", "void onRebind(android.content.Intent)", "boolean onUnbind(android.content.Intent)"};
    private static final String[] gcmIntentServiceMethods = new String[]{"void onDeletedMessages(android.content.Context,int)", "void onError(android.content.Context,java.lang.String)", "void onMessage(android.content.Context,android.content.Intent)", "void onRecoverableError(android.content.Context,java.lang.String)", "void onRegistered(android.content.Context,java.lang.String)", "void onUnregistered(android.content.Context,java.lang.String)"};
    private static final String[] broadcastMethods = new String[]{"void onReceive(android.content.Context,android.content.Intent)"};
    private static final String[] contentproviderMethods = new String[]{"boolean onCreate()"};
    private static final String[] applicationMethods = new String[]{"void onCreate()", "void onTerminate()", "void onActivityStarted(android.app.Activity)", "void onActivityStopped(android.app.Activity)", "void onActivitySaveInstanceState(android.app.Activity,android.os.Bundle)", "void onActivityResumed(android.app.Activity)", "void onActivityPaused(android.app.Activity)", "void onActivityDestroyed(android.app.Activity)", "void onActivityCreated(android.app.Activity,android.os.Bundle)"};

    public static List<String> getActivityLifecycleMethods() {
        return Arrays.asList(activityMethods);
    }

    public static List<String> getServiceLifecycleMethods() {
        return Arrays.asList(serviceMethods);
    }

    public static List<String> getGCMIntentServiceMethods() {
        return Arrays.asList(gcmIntentServiceMethods);
    }

    public static List<String> getBroadcastLifecycleMethods() {
        return Arrays.asList(broadcastMethods);
    }

    public static List<String> getContentproviderLifecycleMethods() {
        return Arrays.asList(contentproviderMethods);
    }

    public static List<String> getApplicationLifecycleMethods() {
        return Arrays.asList(applicationMethods);
    }

    public static boolean isLifecycleClass(String className) {
        return className.equals(ACTIVITYCLASS) || className.equals(SERVICECLASS) || className.equals(BROADCASTRECEIVERCLASS) || className.equals(CONTENTPROVIDERCLASS) || className.equals(APPLICATIONCLASS);
    }
}

