/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.FlowFunction;
import heros.FlowFunctions;
import heros.flowfunc.Identity;
import heros.flowfunc.KillAll;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.ArrayType;
import soot.BooleanType;
import soot.IntType;
import soot.Local;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.collect.MutableTwoElementSet;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.infoflow.source.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;

public class BackwardsInfoflowProblem
extends AbstractInfoflowProblem {
    private IInfoflowSolver fSolver;

    @Override
    public void setTaintWrapper(ITaintPropagationWrapper wrapper) {
        this.taintWrapper = wrapper;
    }

    public BackwardsInfoflowProblem(BiDiInterproceduralCFG<Unit, SootMethod> icfg, ISourceSinkManager sourceSinkManager) {
        super(icfg, sourceSinkManager);
    }

    public void setForwardSolver(IInfoflowSolver forwardSolver) {
        this.fSolver = forwardSolver;
    }

    @Override
    public FlowFunctions<Unit, Abstraction, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, Abstraction, SootMethod>(){

            /*
             * WARNING - void declaration
             */
            private Set<Abstraction> computeAliases(DefinitionStmt defStmt, Value leftValue, Abstraction d1, Abstraction source) {
                assert (!source.getAccessPath().isEmpty());
                if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                    return Collections.emptySet();
                }
                MutableTwoElementSet<Abstraction> res = new MutableTwoElementSet<Abstraction>();
                boolean leftSideMatches = BackwardsInfoflowProblem.this.baseMatches(leftValue, source);
                if (!leftSideMatches) {
                    res.add(source);
                } else {
                    for (Unit unit : BackwardsInfoflowProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                        BackwardsInfoflowProblem.this.fSolver.processEdge(new PathEdge<Unit, Abstraction>(d1, unit, source));
                    }
                }
                if (defStmt instanceof AssignStmt) {
                    boolean bl;
                    Value rightValue = BaseSelector.selectBase(defStmt.getRightOp(), false);
                    if (leftSideMatches && !(rightValue instanceof Local) && !(rightValue instanceof FieldRef)) {
                        return Collections.emptySet();
                    }
                    if (rightValue instanceof Constant) {
                        return res;
                    }
                    if (rightValue instanceof BinopExpr) {
                        return res;
                    }
                    boolean bl2 = bl = BackwardsInfoflowProblem.this.baseMatchesStrict(rightValue, source) && rightValue.getType() instanceof RefType && !source.dependsOnCutAP();
                    if (!bl) {
                        FieldRef ref;
                        Abstraction newLeftAbs = null;
                        if (rightValue instanceof InstanceFieldRef) {
                            ref = (InstanceFieldRef)rightValue;
                            if (source.getAccessPath().isInstanceFieldRef() && ref.getBase() == source.getAccessPath().getPlainValue() && source.getAccessPath().firstFieldMatches(ref.getField())) {
                                newLeftAbs = source.deriveNewAbstraction(leftValue, true, defStmt, source.getAccessPath().getFirstFieldType());
                            }
                        } else if (BackwardsInfoflowProblem.this.enableStaticFields && rightValue instanceof StaticFieldRef) {
                            ref = (StaticFieldRef)rightValue;
                            if (source.getAccessPath().isStaticFieldRef() && source.getAccessPath().firstFieldMatches(((StaticFieldRef)ref).getField())) {
                                newLeftAbs = source.deriveNewAbstraction(leftValue, true, defStmt, source.getAccessPath().getBaseType());
                            }
                        } else if (rightValue == source.getAccessPath().getPlainValue()) {
                            Type newType = source.getAccessPath().getBaseType();
                            if (leftValue instanceof ArrayRef) {
                                newType = BackwardsInfoflowProblem.this.buildArrayOrAddDimension(newType);
                            } else if (defStmt.getRightOp() instanceof ArrayRef) {
                                newType = ((ArrayType)newType).getElementType();
                            }
                            if (defStmt.getRightOp() instanceof CastExpr) {
                                CastExpr castExpr = (CastExpr)defStmt.getRightOp();
                                if (!BackwardsInfoflowProblem.this.checkCast(source.getAccessPath(), castExpr.getCastType())) {
                                    return Collections.emptySet();
                                }
                                if (!Scene.v().getFastHierarchy().canStoreType(newType, castExpr.getCastType())) {
                                    newType = castExpr.getCastType();
                                }
                            } else if (defStmt.getRightOp() instanceof LengthExpr) {
                                assert (source.getAccessPath().getBaseType() instanceof ArrayType);
                                newLeftAbs = source.deriveNewAbstraction(new AccessPath(leftValue, null, IntType.v(), null, true), defStmt);
                            } else if (defStmt.getRightOp() instanceof InstanceOfExpr) {
                                newLeftAbs = source.deriveNewAbstraction(new AccessPath(leftValue, null, BooleanType.v(), null, true), defStmt);
                            }
                            if (newLeftAbs == null) {
                                newLeftAbs = source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(leftValue, newType, false), defStmt);
                            }
                        }
                        if (newLeftAbs != null) {
                            res.add(newLeftAbs);
                            for (Unit unit : BackwardsInfoflowProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                                BackwardsInfoflowProblem.this.fSolver.processEdge(new PathEdge<Unit, Abstraction>(d1, unit, newLeftAbs));
                            }
                        }
                    }
                    if (rightValue instanceof Local || rightValue instanceof FieldRef) {
                        boolean addRightValue = false;
                        boolean cutFirstField = false;
                        Object var11_17 = null;
                        if (leftValue instanceof InstanceFieldRef) {
                            InstanceFieldRef leftRef = (InstanceFieldRef)leftValue;
                            if (leftRef.getBase() == source.getAccessPath().getPlainValue() && source.getAccessPath().isInstanceFieldRef() && source.getAccessPath().firstFieldMatches(leftRef.getField())) {
                                Type type = source.getAccessPath().getFirstFieldType();
                                addRightValue = true;
                                cutFirstField = true;
                            }
                        } else if (leftValue instanceof Local && source.getAccessPath().isInstanceFieldRef()) {
                            Local base = source.getAccessPath().getPlainValue();
                            if (leftValue == base) {
                                Type type = source.getAccessPath().getBaseType();
                                addRightValue = true;
                            }
                        } else if (leftValue instanceof ArrayRef) {
                            Local leftBase = (Local)((ArrayRef)leftValue).getBase();
                            if (leftBase == source.getAccessPath().getPlainValue()) {
                                addRightValue = true;
                                Type type = source.getAccessPath().getBaseType();
                                assert (source.getAccessPath().getBaseType() instanceof ArrayType);
                            }
                        } else if (leftValue == source.getAccessPath().getPlainValue()) {
                            addRightValue = true;
                            Type type = source.getAccessPath().getBaseType();
                            if (defStmt.getRightOp() instanceof CastExpr) {
                                CastExpr ce = (CastExpr)defStmt.getRightOp();
                                if (!BackwardsInfoflowProblem.this.checkCast(source.getAccessPath(), ce.getOp().getType())) {
                                    return Collections.emptySet();
                                }
                            }
                        }
                        if (addRightValue) {
                            void var11_31;
                            void var11_25;
                            if (var11_25 != null) {
                                if (defStmt.getRightOp() instanceof ArrayRef) {
                                    Type type = BackwardsInfoflowProblem.this.buildArrayOrAddDimension((Type)var11_25);
                                } else if (leftValue instanceof ArrayRef) {
                                    assert (source.getAccessPath().getBaseType() instanceof ArrayType);
                                    Type type = ((ArrayType)var11_25).getElementType();
                                    if (!BackwardsInfoflowProblem.this.canCastType(rightValue.getType(), type)) {
                                        addRightValue = false;
                                    } else if (BackwardsInfoflowProblem.this.isObjectLikeType(type)) {
                                        Type type2 = rightValue.getType();
                                    }
                                }
                            }
                            if (defStmt.getRightOp() instanceof LengthExpr) {
                                Object var11_30 = null;
                            }
                            if (addRightValue && !BackwardsInfoflowProblem.this.canCastType(rightValue.getType(), (Type)var11_31)) {
                                addRightValue = false;
                            }
                            if (addRightValue && !BackwardsInfoflowProblem.this.enableStaticFields && rightValue instanceof StaticFieldRef) {
                                addRightValue = false;
                            }
                            if (addRightValue) {
                                Abstraction newAbs = source.deriveNewAbstraction(rightValue, cutFirstField, defStmt, (Type)var11_31);
                                res.add(newAbs);
                                for (Unit unit : BackwardsInfoflowProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                                    BackwardsInfoflowProblem.this.fSolver.processEdge(new PathEdge<Unit, Abstraction>(d1, unit, newAbs));
                                }
                            }
                        }
                    }
                } else if (defStmt instanceof IdentityStmt) {
                    res.add(source);
                }
                return res;
            }

            @Override
            public FlowFunction<Abstraction> getNormalFlowFunction(Unit src, Unit dest) {
                if (src instanceof DefinitionStmt) {
                    final DefinitionStmt defStmt = (DefinitionStmt)src;
                    final Value leftValue = BaseSelector.selectBase(defStmt.getLeftOp(), true);
                    final DefinitionStmt destDefStmt = dest instanceof DefinitionStmt ? (DefinitionStmt)dest : null;
                    final Value destLeftValue = destDefStmt == null ? null : BaseSelector.selectBase(destDefStmt.getLeftOp(), true);
                    return new SolverNormalFlowFunction(){

                        @Override
                        public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                            if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                                return Collections.emptySet();
                            }
                            assert (source.isAbstractionActive() || BackwardsInfoflowProblem.this.flowSensitiveAliasing);
                            Set res = this.computeAliases(defStmt, leftValue, d1, source);
                            if (destDefStmt != null && BackwardsInfoflowProblem.this.interproceduralCFG().isExitStmt(destDefStmt)) {
                                for (Abstraction abs : res) {
                                    this.computeAliases(destDefStmt, destLeftValue, d1, abs);
                                }
                            }
                            return res;
                        }
                    };
                }
                return Identity.v();
            }

            @Override
            public FlowFunction<Abstraction> getCallFlowFunction(final Unit src, final SootMethod dest) {
                if (!dest.isConcrete()) {
                    return KillAll.v();
                }
                final Stmt stmt = (Stmt)src;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final Value[] paramLocals = new Value[dest.getParameterCount()];
                for (int i = 0; i < dest.getParameterCount(); ++i) {
                    paramLocals[i] = dest.getActiveBody().getParameterLocal(i);
                }
                final boolean isSource = BackwardsInfoflowProblem.this.sourceSinkManager != null ? BackwardsInfoflowProblem.this.sourceSinkManager.getSourceInfo((Stmt)src, BackwardsInfoflowProblem.this.interproceduralCFG()) != null : false;
                final boolean isSink = BackwardsInfoflowProblem.this.sourceSinkManager != null ? BackwardsInfoflowProblem.this.sourceSinkManager.isSink(stmt, BackwardsInfoflowProblem.this.interproceduralCFG(), null) : false;
                final Local thisLocal = dest.isStatic() ? null : dest.getActiveBody().getThisLocal();
                final boolean isExecutorExecute = BackwardsInfoflowProblem.this.isExecutorExecute(ie, dest);
                return new SolverCallFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        InstanceInvokeExpr iIExpr;
                        DefinitionStmt defnStmt;
                        Value leftOp;
                        if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                            return Collections.emptySet();
                        }
                        assert (source.isAbstractionActive() || BackwardsInfoflowProblem.this.flowSensitiveAliasing);
                        if (!BackwardsInfoflowProblem.this.inspectSources && isSource) {
                            return Collections.emptySet();
                        }
                        if (!BackwardsInfoflowProblem.this.inspectSinks && isSink) {
                            return Collections.emptySet();
                        }
                        if (BackwardsInfoflowProblem.this.isCallSiteActivatingTaint(stmt, source.getActivationUnit())) {
                            return Collections.emptySet();
                        }
                        if (BackwardsInfoflowProblem.this.taintWrapper != null && BackwardsInfoflowProblem.this.taintWrapper.isExclusive(stmt, source)) {
                            return Collections.emptySet();
                        }
                        if (BackwardsInfoflowProblem.this.enableStaticFields && source.getAccessPath().isStaticFieldRef() && !BackwardsInfoflowProblem.this.interproceduralCFG().isStaticFieldRead(dest, source.getAccessPath().getFirstField())) {
                            return Collections.emptySet();
                        }
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (src instanceof DefinitionStmt && (leftOp = (defnStmt = (DefinitionStmt)src).getLeftOp()) == source.getAccessPath().getPlainValue()) {
                            for (Unit u : dest.getActiveBody().getUnits()) {
                                ReturnStmt rStmt;
                                if (!(u instanceof ReturnStmt) || !((rStmt = (ReturnStmt)u).getOp() instanceof Local) && !(rStmt.getOp() instanceof FieldRef)) continue;
                                Abstraction abs = source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(rStmt.getOp(), null, false), (Stmt)src);
                                res.add(abs);
                            }
                        }
                        if (BackwardsInfoflowProblem.this.enableStaticFields && source.getAccessPath().isStaticFieldRef()) {
                            res.add(source.deriveNewAbstraction(source.getAccessPath(), stmt));
                        }
                        Local sourceBase = source.getAccessPath().getPlainValue();
                        if (!isExecutorExecute && !source.getAccessPath().isStaticFieldRef() && !dest.isStatic() && (iIExpr = (InstanceInvokeExpr)stmt.getInvokeExpr()).getBase() == sourceBase && BackwardsInfoflowProblem.this.hasCompatibleTypesForCall(source.getAccessPath(), dest.getDeclaringClass())) {
                            boolean param = false;
                            for (int i = 0; i < dest.getParameterCount(); ++i) {
                                if (stmt.getInvokeExpr().getArg(i) != sourceBase) continue;
                                param = true;
                                break;
                            }
                            if (!param) {
                                Abstraction abs = source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(thisLocal), (Stmt)src);
                                res.add(abs);
                            }
                        }
                        if (isExecutorExecute) {
                            if (ie.getArg(0) == source.getAccessPath().getPlainValue()) {
                                Abstraction abs = source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(thisLocal), stmt);
                                res.add(abs);
                            }
                        } else if (ie != null && dest.getParameterCount() > 0) {
                            assert (dest.getParameterCount() == ie.getArgCount());
                            for (int i = 0; i < ie.getArgCount(); ++i) {
                                if (ie.getArg(i) != source.getAccessPath().getPlainValue() || source.getAccessPath().getBaseType() instanceof PrimType || BackwardsInfoflowProblem.this.isStringType(source.getAccessPath().getBaseType())) continue;
                                Abstraction abs = source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(paramLocals[i]), stmt);
                                res.add(abs);
                            }
                        }
                        return res;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getReturnFlowFunction(final Unit callSite, final SootMethod callee, final Unit exitStmt, Unit retSite) {
                final Value[] paramLocals = new Value[callee.getParameterCount()];
                for (int i = 0; i < callee.getParameterCount(); ++i) {
                    paramLocals[i] = callee.getActiveBody().getParameterLocal(i);
                }
                Stmt stmt = (Stmt)callSite;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final Local thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
                final boolean isExecutorExecute = BackwardsInfoflowProblem.this.isExecutorExecute(ie, callee);
                return new SolverReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction source, Abstraction d1, Collection<Abstraction> callerD1s) {
                        if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                            return Collections.emptySet();
                        }
                        assert (source.isAbstractionActive() || BackwardsInfoflowProblem.this.flowSensitiveAliasing);
                        if (callSite == null) {
                            return Collections.emptySet();
                        }
                        if (BackwardsInfoflowProblem.this.enableStaticFields && source.getAccessPath().isStaticFieldRef()) {
                            BackwardsInfoflowProblem.this.registerActivationCallSite(callSite, callee, source);
                            return Collections.singleton(source);
                        }
                        Local sourceBase = source.getAccessPath().getPlainValue();
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (isExecutorExecute) {
                            if (source.getAccessPath().getPlainValue() == thisLocal) {
                                Abstraction abs = source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(ie.getArg(0)), (Stmt)exitStmt);
                                res.add(abs);
                                BackwardsInfoflowProblem.this.registerActivationCallSite(callSite, callee, abs);
                            }
                        } else {
                            Stmt stmt;
                            boolean parameterAliases = false;
                            Value originalCallArg = null;
                            for (int i = 0; i < paramLocals.length; ++i) {
                                if (paramLocals[i] != sourceBase) continue;
                                parameterAliases = true;
                                if (!(callSite instanceof Stmt) || !AccessPath.canContainValue(originalCallArg = ie.getArg(i)) || !BackwardsInfoflowProblem.this.checkCast(source.getAccessPath(), originalCallArg.getType()) || source.getAccessPath().getBaseType() instanceof PrimType || BackwardsInfoflowProblem.this.isStringType(source.getAccessPath().getBaseType())) continue;
                                Abstraction abs = source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(originalCallArg), (Stmt)exitStmt);
                                res.add(abs);
                                BackwardsInfoflowProblem.this.registerActivationCallSite(callSite, callee, abs);
                            }
                            if (!callee.isStatic() && thisLocal == sourceBase && BackwardsInfoflowProblem.this.hasCompatibleTypesForCall(source.getAccessPath(), callee.getDeclaringClass()) && !parameterAliases && callSite instanceof Stmt && (stmt = (Stmt)callSite).getInvokeExpr() instanceof InstanceInvokeExpr) {
                                InstanceInvokeExpr iIExpr = (InstanceInvokeExpr)stmt.getInvokeExpr();
                                Abstraction abs = source.deriveNewAbstraction(source.getAccessPath().copyWithNewValue(iIExpr.getBase()), (Stmt)exitStmt);
                                res.add(abs);
                                BackwardsInfoflowProblem.this.registerActivationCallSite(callSite, callee, abs);
                            }
                        }
                        for (Abstraction abs : res) {
                            if (abs == source) continue;
                            abs.setCorrespondingCallSite((Stmt)callSite);
                        }
                        return res;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getCallToReturnFlowFunction(Unit call, Unit returnSite) {
                final Stmt iStmt = (Stmt)call;
                InvokeExpr invExpr = iStmt.getInvokeExpr();
                final Value[] callArgs = new Value[iStmt.getInvokeExpr().getArgCount()];
                for (int i = 0; i < iStmt.getInvokeExpr().getArgCount(); ++i) {
                    callArgs[i] = iStmt.getInvokeExpr().getArg(i);
                }
                final SootMethod callee = invExpr.getMethod();
                return new SolverCallToReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        InstanceInvokeExpr iinv;
                        if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                            return Collections.emptySet();
                        }
                        assert (source.isAbstractionActive() || BackwardsInfoflowProblem.this.flowSensitiveAliasing);
                        if (BackwardsInfoflowProblem.this.enableStaticFields && source.getAccessPath().isStaticFieldRef() && BackwardsInfoflowProblem.this.interproceduralCFG().isStaticFieldUsed(callee, source.getAccessPath().getFirstField())) {
                            return Collections.emptySet();
                        }
                        if (iStmt instanceof DefinitionStmt && ((DefinitionStmt)iStmt).getLeftOp() == source.getAccessPath().getPlainValue()) {
                            return Collections.emptySet();
                        }
                        if (iStmt.getInvokeExpr() instanceof InstanceInvokeExpr && (iinv = (InstanceInvokeExpr)iStmt.getInvokeExpr()).getBase() == source.getAccessPath().getPlainValue()) {
                            return Collections.emptySet();
                        }
                        for (int i = 0; i < callArgs.length; ++i) {
                            if (callArgs[i] != source.getAccessPath().getPlainValue()) continue;
                            return Collections.emptySet();
                        }
                        return Collections.singleton(source);
                    }
                };
            }
        };
    }
}

