/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.FlowFunction;
import heros.FlowFunctions;
import heros.TwoElementSet;
import heros.flowfunc.Identity;
import heros.flowfunc.KillAll;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.ArrayType;
import soot.BooleanType;
import soot.IntType;
import soot.Local;
import soot.NullType;
import soot.PrimType;
import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.aliasing.IAliasingStrategy;
import soot.jimple.infoflow.aliasing.ImplicitFlowAliasStrategy;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.cfg.InfoflowCFG;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.infoflow.source.DefaultSourceSinkManager;
import soot.jimple.infoflow.source.ISourceSinkManager;
import soot.jimple.infoflow.source.SourceInfo;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.infoflow.util.SystemClassHandler;

public class InfoflowProblem
extends AbstractInfoflowProblem {
    private final Aliasing aliasing;
    private final IAliasingStrategy aliasingStrategy;
    private final IAliasingStrategy implicitFlowAliasingStrategy;
    private final MyConcurrentHashMap<Unit, Set<Abstraction>> implicitTargets = new MyConcurrentHashMap();
    protected final MyConcurrentHashMap<AbstractionAtSink, Abstraction> results = new MyConcurrentHashMap();

    public InfoflowProblem(ISourceSinkManager sourceSinkManager, IAliasingStrategy aliasingStrategy) {
        this(new InfoflowCFG(), sourceSinkManager, aliasingStrategy);
    }

    public InfoflowProblem(InfoflowCFG icfg, List<String> sourceList, List<String> sinkList, IAliasingStrategy aliasingStrategy) {
        this(icfg, new DefaultSourceSinkManager(sourceList, sinkList), aliasingStrategy);
    }

    public InfoflowProblem(ISourceSinkManager mySourceSinkManager, Set<Unit> analysisSeeds, IAliasingStrategy aliasingStrategy) {
        this(new InfoflowCFG(), mySourceSinkManager, aliasingStrategy);
        for (Unit u : analysisSeeds) {
            this.initialSeeds.put(u, Collections.singleton(this.getZeroValue()));
        }
    }

    public InfoflowProblem(IInfoflowCFG icfg, ISourceSinkManager sourceSinkManager, IAliasingStrategy aliasingStrategy) {
        super(icfg, sourceSinkManager);
        this.aliasingStrategy = aliasingStrategy;
        this.implicitFlowAliasingStrategy = new ImplicitFlowAliasStrategy(icfg);
        this.aliasing = new Aliasing(aliasingStrategy, icfg);
    }

    private Set<Abstraction> computeWrapperTaints(Abstraction d1, Stmt iStmt, Abstraction source) {
        Set<Abstraction> res;
        assert (this.inspectSources || source != this.getZeroValue());
        if (this.taintWrapper == null) {
            return Collections.emptySet();
        }
        if (!source.getAccessPath().isStaticFieldRef() && !source.getAccessPath().isEmpty()) {
            boolean found = false;
            if (iStmt.getInvokeExpr() instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iiExpr = (InstanceInvokeExpr)iStmt.getInvokeExpr();
                found = this.aliasing.mayAlias(iiExpr.getBase(), (Value)source.getAccessPath().getPlainValue());
            }
            if (!found) {
                for (int paramIdx = 0; paramIdx < iStmt.getInvokeExpr().getArgCount(); ++paramIdx) {
                    if (!this.aliasing.mayAlias(source.getAccessPath().getPlainValue(), iStmt.getInvokeExpr().getArg(paramIdx))) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return Collections.emptySet();
            }
        }
        if ((res = this.taintWrapper.getTaintsForMethod(iStmt, d1, source)) != null) {
            HashSet<Abstraction> resWithAliases = new HashSet<Abstraction>(res);
            for (Abstraction abs : res) {
                if (abs.equals(source)) continue;
                AccessPath val = abs.getAccessPath();
                boolean taintsObjectValue = val.getBaseType() instanceof RefType && abs.getAccessPath().getBaseType() instanceof RefType && !this.isStringType(val.getBaseType());
                boolean taintsStaticField = this.enableStaticFields && abs.getAccessPath().isStaticFieldRef();
                boolean taintedValueOverwritten = iStmt instanceof DefinitionStmt ? this.baseMatches(((DefinitionStmt)iStmt).getLeftOp(), abs) : false;
                if (taintedValueOverwritten || !taintsStaticField && (!taintsObjectValue || !abs.getAccessPath().getTaintSubFields()) && !this.triggerInaktiveTaintOrReverseFlow(iStmt, val.getPlainValue(), abs)) continue;
                this.computeAliasTaints(d1, iStmt, val.getPlainValue(), resWithAliases, (SootMethod)this.interproceduralCFG().getMethodOf(iStmt), abs);
            }
            res = resWithAliases;
        }
        return res;
    }

    private void computeAliasTaints(Abstraction d1, Stmt src, Value targetValue, Set<Abstraction> taintSet, SootMethod method, Abstraction newAbs) {
        if (!d1.getAccessPath().isEmpty()) {
            this.aliasingStrategy.computeAliasTaints(d1, src, targetValue, taintSet, method, newAbs);
        } else if (targetValue instanceof InstanceFieldRef) {
            assert (this.enableImplicitFlows);
            this.implicitFlowAliasingStrategy.computeAliasTaints(d1, src, targetValue, taintSet, method, newAbs);
        }
    }

    private boolean triggerInaktiveTaintOrReverseFlow(Stmt stmt, Value val, Abstraction source) {
        if (stmt instanceof DefinitionStmt) {
            DefinitionStmt defStmt = (DefinitionStmt)stmt;
            if (defStmt.getLeftOp() instanceof Local && defStmt.getLeftOp() == source.getAccessPath().getPlainValue()) {
                return false;
            }
            if (val instanceof ArrayRef) {
                return true;
            }
            if (val instanceof FieldRef) {
                return true;
            }
        }
        if (val.getType() instanceof PrimType) {
            return false;
        }
        if (val instanceof Constant) {
            return false;
        }
        if (this.isStringType(val.getType())) {
            return false;
        }
        return val instanceof FieldRef || val instanceof Local && ((Local)val).getType() instanceof ArrayType;
    }

    @Override
    public FlowFunctions<Unit, Abstraction, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, Abstraction, SootMethod>(){

            private Set<Abstraction> notifyOutFlowHandlers(Unit stmt, Abstraction d1, Abstraction incoming, Set<Abstraction> outgoing, TaintPropagationHandler.FlowFunctionType functionType) {
                if (InfoflowProblem.this.taintPropagationHandlers != null && outgoing != null && !outgoing.isEmpty()) {
                    for (TaintPropagationHandler tp : InfoflowProblem.this.taintPropagationHandlers) {
                        outgoing = tp.notifyFlowOut(stmt, d1, incoming, outgoing, InfoflowProblem.this.interproceduralCFG(), functionType);
                    }
                }
                return outgoing;
            }

            private void addTaintViaStmt(Abstraction d1, AssignStmt assignStmt, Abstraction source, Set<Abstraction> taintSet, boolean cutFirstField, SootMethod method, Type targetType) {
                Value leftValue = assignStmt.getLeftOp();
                Value rightValue = assignStmt.getRightOp();
                if (!InfoflowProblem.this.enableStaticFields && leftValue instanceof StaticFieldRef) {
                    return;
                }
                Abstraction newAbs = null;
                if (!source.getAccessPath().isEmpty()) {
                    if (leftValue instanceof ArrayRef && targetType != null) {
                        targetType = InfoflowProblem.this.buildArrayOrAddDimension(targetType);
                    } else if (assignStmt.getRightOp() instanceof ArrayRef && targetType != null) {
                        targetType = ((ArrayType)targetType).getElementType();
                    }
                    if (rightValue instanceof CastExpr) {
                        CastExpr cast = (CastExpr)assignStmt.getRightOp();
                        if (cast.getType() instanceof ArrayType && !(targetType instanceof ArrayType)) {
                            assert (InfoflowProblem.this.canCastType(targetType, cast.getType()));
                            targetType = cast.getType();
                        }
                    } else if (rightValue instanceof InstanceOfExpr) {
                        newAbs = source.deriveNewAbstraction(new AccessPath(leftValue, null, BooleanType.v(), null, true), assignStmt);
                    }
                } else assert (targetType == null);
                if (newAbs == null) {
                    newAbs = source.getAccessPath().isEmpty() ? source.deriveNewAbstraction(new AccessPath(leftValue, true), assignStmt, true) : source.deriveNewAbstraction(leftValue, cutFirstField, assignStmt, targetType);
                }
                taintSet.add(newAbs);
                if (InfoflowProblem.this.triggerInaktiveTaintOrReverseFlow(assignStmt, leftValue, newAbs)) {
                    InfoflowProblem.this.computeAliasTaints(d1, assignStmt, leftValue, taintSet, method, newAbs);
                }
            }

            private boolean hasValidCallees(Unit call) {
                Set callees = InfoflowProblem.this.interproceduralCFG().getCalleesOfCallAt(call);
                for (SootMethod callee : callees) {
                    if (!callee.isConcrete()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public FlowFunction<Abstraction> getNormalFlowFunction(final Unit src, Unit dest) {
                SourceInfo sourceInfo;
                if (!(src instanceof Stmt)) {
                    return KillAll.v();
                }
                final Stmt stmt = (Stmt)src;
                SourceInfo sourceInfo2 = sourceInfo = InfoflowProblem.this.sourceSinkManager != null ? InfoflowProblem.this.sourceSinkManager.getSourceInfo(stmt, InfoflowProblem.this.interproceduralCFG()) : null;
                if (src instanceof IdentityStmt) {
                    final IdentityStmt is = (IdentityStmt)src;
                    return new NotifyingNormalFlowFunction(is){

                        @Override
                        public Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                            if (source.isTopPostdominator(is) && (source = source.dropTopPostdominator()).getAccessPath().isEmpty() && source.getTopPostdominator() == null) {
                                return Collections.emptySet();
                            }
                            HashSet<Abstraction> res = new HashSet<Abstraction>();
                            if (source == InfoflowProblem.this.getZeroValue() && sourceInfo != null && !sourceInfo.getAccessPaths().isEmpty()) {
                                for (AccessPath ap : sourceInfo.getAccessPaths()) {
                                    Abstraction abs = new Abstraction(ap, is, sourceInfo.getUserData(), false, false);
                                    res.add(abs);
                                    if (!InfoflowProblem.this.triggerInaktiveTaintOrReverseFlow(is, is.getLeftOp(), abs)) continue;
                                    InfoflowProblem.this.computeAliasTaints(d1, is, is.getLeftOp(), res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(is), abs);
                                }
                                return res;
                            }
                            boolean addOriginal = true;
                            if (is.getRightOp() instanceof CaughtExceptionRef && source.getExceptionThrown()) {
                                res.add(source.deriveNewAbstractionOnCatch(is.getLeftOp()));
                                addOriginal = false;
                            }
                            if (addOriginal && source != InfoflowProblem.this.getZeroValue()) {
                                res.add(source);
                            }
                            return res;
                        }
                    };
                }
                if (src instanceof AssignStmt) {
                    final AssignStmt assignStmt = (AssignStmt)src;
                    Value right = assignStmt.getRightOp();
                    final Value leftValue = assignStmt.getLeftOp();
                    final Value[] rightVals = BaseSelector.selectBaseList(right, true);
                    return new NotifyingNormalFlowFunction(assignStmt){

                        @Override
                        public Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                            assert (source.getAccessPath().isEmpty() || source.getTopPostdominator() == null);
                            assert (source.getTopPostdominator() == null || InfoflowProblem.this.interproceduralCFG().getMethodOf(src) == source.getTopPostdominator().getMethod() || ((SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(src)).getActiveBody().getUnits().contains(source.getTopPostdominator().getUnit()));
                            if (source == InfoflowProblem.this.getZeroValue() && sourceInfo != null && !sourceInfo.getAccessPaths().isEmpty()) {
                                HashSet<Abstraction> res = new HashSet<Abstraction>();
                                for (AccessPath ap : sourceInfo.getAccessPaths()) {
                                    Abstraction abs = new Abstraction(ap, assignStmt, sourceInfo.getUserData(), false, false);
                                    res.add(abs);
                                    if (!InfoflowProblem.this.triggerInaktiveTaintOrReverseFlow(assignStmt, leftValue, abs)) continue;
                                    InfoflowProblem.this.computeAliasTaints(d1, assignStmt, leftValue, res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(assignStmt), abs);
                                }
                                return res;
                            }
                            if (source == InfoflowProblem.this.getZeroValue()) {
                                return Collections.emptySet();
                            }
                            if (source.isTopPostdominator(assignStmt) && (source = source.dropTopPostdominator()).getAccessPath().isEmpty() && source.getTopPostdominator() == null) {
                                return Collections.emptySet();
                            }
                            Abstraction newSource = !source.isAbstractionActive() && src == source.getActivationUnit() ? source.getActiveCopy() : source;
                            Set<Abstraction> res = this.createNewTaintOnAssignment(src, assignStmt, rightVals, d1, newSource);
                            if (res != null) {
                                return res;
                            }
                            if (assignStmt.getLeftOp() instanceof ArrayRef) {
                                return Collections.singleton(newSource);
                            }
                            if (newSource.getAccessPath().isInstanceFieldRef()) {
                                if (leftValue instanceof InstanceFieldRef) {
                                    boolean baseAliases;
                                    InstanceFieldRef leftRef = (InstanceFieldRef)leftValue;
                                    boolean bl = baseAliases = source.isAbstractionActive() && InfoflowProblem.this.aliasing.mustAlias((Local)leftRef.getBase(), newSource.getAccessPath().getPlainValue(), assignStmt);
                                    if ((baseAliases || leftRef.getBase() == newSource.getAccessPath().getPlainValue()) && InfoflowProblem.this.aliasing.mustAlias(leftRef.getField(), newSource.getAccessPath().getFirstField())) {
                                        return Collections.emptySet();
                                    }
                                } else if (leftValue instanceof Local && leftValue == newSource.getAccessPath().getPlainValue()) {
                                    return Collections.emptySet();
                                }
                            } else if (newSource.getAccessPath().isStaticFieldRef() ? leftValue instanceof StaticFieldRef && InfoflowProblem.this.aliasing.mustAlias(((StaticFieldRef)leftValue).getField(), newSource.getAccessPath().getFirstField()) : newSource.getAccessPath().isLocal() && leftValue instanceof Local && leftValue == newSource.getAccessPath().getPlainValue()) {
                                return Collections.emptySet();
                            }
                            return Collections.singleton(newSource);
                        }

                        private Set<Abstraction> createNewTaintOnAssignment(Unit src2, AssignStmt assignStmt2, Value[] rightVals2, Abstraction d1, Abstraction newSource) {
                            boolean implicitTaint;
                            Value leftValue2 = assignStmt2.getLeftOp();
                            Value rightValue = assignStmt2.getRightOp();
                            boolean addLeftValue = false;
                            boolean bl = implicitTaint = newSource.getTopPostdominator() != null && newSource.getTopPostdominator().getUnit() != null;
                            if (implicitTaint |= newSource.getAccessPath().isEmpty()) {
                                assert (InfoflowProblem.this.enableImplicitFlows);
                                if ((d1 == null || d1.getAccessPath().isEmpty()) && !(leftValue2 instanceof FieldRef)) {
                                    return Collections.singleton(newSource);
                                }
                                if (newSource.getAccessPath().isEmpty()) {
                                    addLeftValue = true;
                                }
                            }
                            boolean aliasOverwritten = !addLeftValue && !newSource.isAbstractionActive() && InfoflowProblem.this.baseMatchesStrict(rightValue, newSource) && rightValue.getType() instanceof RefType && !newSource.dependsOnCutAP();
                            boolean cutFirstField = false;
                            AccessPath mappedAP = newSource.getAccessPath();
                            Type targetType = null;
                            if (!addLeftValue && !aliasOverwritten) {
                                for (Value rightVal : rightVals2) {
                                    if (rightVal instanceof FieldRef) {
                                        FieldRef rightRef = (FieldRef)rightVal;
                                        if (rightRef instanceof InstanceFieldRef && ((InstanceFieldRef)rightRef).getBase().getType() instanceof NullType) {
                                            return null;
                                        }
                                        mappedAP = InfoflowProblem.this.aliasing.mayAlias(newSource.getAccessPath(), (Value)rightRef);
                                        if (rightVal instanceof StaticFieldRef) {
                                            if (InfoflowProblem.this.enableStaticFields && mappedAP != null) {
                                                addLeftValue = true;
                                                cutFirstField = true;
                                            }
                                        } else if (rightVal instanceof InstanceFieldRef) {
                                            Local rightBase = (Local)((InstanceFieldRef)rightRef).getBase();
                                            Local sourceBase = newSource.getAccessPath().getPlainValue();
                                            SootField rightField = rightRef.getField();
                                            if (mappedAP != null) {
                                                addLeftValue = true;
                                                cutFirstField = mappedAP.getFieldCount() > 0 && mappedAP.getFirstField() == rightField;
                                            } else if (InfoflowProblem.this.aliasing.mayAlias(rightBase, (Value)sourceBase) && newSource.getAccessPath().getFieldCount() == 0 && newSource.getAccessPath().getTaintSubFields()) {
                                                addLeftValue = true;
                                                targetType = rightField.getType();
                                            }
                                        }
                                    } else if (rightVal instanceof Local && newSource.getAccessPath().isInstanceFieldRef()) {
                                        Local base = newSource.getAccessPath().getPlainValue();
                                        if (InfoflowProblem.this.aliasing.mayAlias(rightVal, (Value)base)) {
                                            addLeftValue = true;
                                            targetType = newSource.getAccessPath().getBaseType();
                                        }
                                    } else if (rightVal instanceof ArrayRef) {
                                        Local rightBase = (Local)((ArrayRef)rightVal).getBase();
                                        if (InfoflowProblem.this.aliasing.mayAlias(rightBase, (Value)newSource.getAccessPath().getPlainValue())) {
                                            addLeftValue = true;
                                            targetType = newSource.getAccessPath().getBaseType();
                                            assert (targetType instanceof ArrayType);
                                        }
                                    } else if (InfoflowProblem.this.aliasing.mayAlias(rightVal, (Value)newSource.getAccessPath().getPlainValue())) {
                                        addLeftValue = true;
                                        targetType = newSource.getAccessPath().getBaseType();
                                    }
                                    if (addLeftValue) break;
                                }
                            }
                            if (!addLeftValue) {
                                return null;
                            }
                            if (rightValue instanceof CastExpr) {
                                CastExpr ce = (CastExpr)rightValue;
                                if (!InfoflowProblem.this.checkCast(newSource.getAccessPath(), ce.getCastType())) {
                                    return Collections.emptySet();
                                }
                            } else if (rightValue instanceof LengthExpr) {
                                assert (newSource.getAccessPath().isEmpty() || newSource.getAccessPath().getBaseType() instanceof ArrayType);
                                assert (leftValue2 instanceof Local);
                                Abstraction lenAbs = newSource.deriveNewAbstraction(new AccessPath(leftValue2, null, IntType.v(), null, true), assignStmt2);
                                return new TwoElementSet<Abstraction>(newSource, lenAbs);
                            }
                            if (mappedAP == null) {
                                for (Value val : rightVals2) {
                                    InfoflowProblem.this.aliasing.mayAlias(newSource.getAccessPath(), val);
                                }
                            }
                            if (InfoflowProblem.this.sourceSinkManager != null && InfoflowProblem.this.sourceSinkManager.isSink(stmt, InfoflowProblem.this.interproceduralCFG(), newSource.getAccessPath()) && newSource.isAbstractionActive() && newSource.getAccessPath().isEmpty()) {
                                InfoflowProblem.this.addResult(new AbstractionAtSink(newSource, assignStmt2));
                            }
                            HashSet<Abstraction> res = new HashSet<Abstraction>();
                            Abstraction targetAB = mappedAP.equals(newSource.getAccessPath()) ? newSource : newSource.deriveNewAbstraction(mappedAP, null);
                            this.addTaintViaStmt(d1, assignStmt2, targetAB, res, cutFirstField, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(src2), targetType);
                            res.add(newSource);
                            return res;
                        }
                    };
                }
                if (src instanceof ReturnStmt) {
                    final ReturnStmt returnStmt = (ReturnStmt)src;
                    return new NotifyingNormalFlowFunction(returnStmt){

                        @Override
                        public Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                            if (source.isTopPostdominator(returnStmt) && (source = source.dropTopPostdominator()).getAccessPath().isEmpty() && source.getTopPostdominator() == null) {
                                return Collections.emptySet();
                            }
                            if (InfoflowProblem.this.sourceSinkManager != null && source.isAbstractionActive() && InfoflowProblem.this.aliasing.mayAlias(returnStmt.getOp(), (Value)source.getAccessPath().getPlainValue()) && InfoflowProblem.this.sourceSinkManager.isSink(returnStmt, InfoflowProblem.this.interproceduralCFG(), source.getAccessPath())) {
                                InfoflowProblem.this.addResult(new AbstractionAtSink(source, returnStmt));
                            }
                            return Collections.singleton(source);
                        }
                    };
                }
                if (InfoflowProblem.this.enableExceptions && src instanceof ThrowStmt) {
                    final ThrowStmt throwStmt = (ThrowStmt)src;
                    return new NotifyingNormalFlowFunction(throwStmt){

                        @Override
                        public Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                            if (source.isTopPostdominator(throwStmt) && (source = source.dropTopPostdominator()).getAccessPath().isEmpty() && source.getTopPostdominator() == null) {
                                return Collections.emptySet();
                            }
                            if (InfoflowProblem.this.aliasing.mayAlias(throwStmt.getOp(), (Value)source.getAccessPath().getPlainValue())) {
                                return Collections.singleton(source.deriveNewAbstractionOnThrow(throwStmt));
                            }
                            return Collections.singleton(source);
                        }
                    };
                }
                if (src instanceof IfStmt || src instanceof LookupSwitchStmt || src instanceof TableSwitchStmt) {
                    Value condition;
                    Value value = src instanceof IfStmt ? ((IfStmt)src).getCondition() : (condition = src instanceof LookupSwitchStmt ? ((LookupSwitchStmt)src).getKey() : ((TableSwitchStmt)src).getKey());
                    if (!InfoflowProblem.this.enableImplicitFlows) {
                        return new NotifyingNormalFlowFunction(stmt){

                            @Override
                            public Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                                if (source.isAbstractionActive() && InfoflowProblem.this.sourceSinkManager != null && InfoflowProblem.this.sourceSinkManager.isSink(stmt, InfoflowProblem.this.interproceduralCFG(), source.getAccessPath())) {
                                    for (Value v : BaseSelector.selectBaseList(condition, false)) {
                                        if (!InfoflowProblem.this.aliasing.mayAlias(v, (Value)source.getAccessPath().getPlainValue())) continue;
                                        InfoflowProblem.this.addResult(new AbstractionAtSink(source, stmt));
                                        break;
                                    }
                                }
                                return Collections.singleton(source);
                            }
                        };
                    }
                    return new NotifyingNormalFlowFunction(stmt){

                        @Override
                        public Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                            if (!source.isAbstractionActive()) {
                                return Collections.singleton(source);
                            }
                            if (InfoflowProblem.this.sourceSinkManager != null && InfoflowProblem.this.sourceSinkManager.isSink(stmt, InfoflowProblem.this.interproceduralCFG(), source.getAccessPath())) {
                                for (Value v : BaseSelector.selectBaseList(condition, false)) {
                                    if (!InfoflowProblem.this.aliasing.mayAlias(v, (Value)source.getAccessPath().getPlainValue())) continue;
                                    InfoflowProblem.this.addResult(new AbstractionAtSink(source, stmt));
                                    break;
                                }
                            }
                            if (source.isTopPostdominator(src) && (source = source.dropTopPostdominator()).getAccessPath().isEmpty() && source.getTopPostdominator() == null) {
                                return Collections.emptySet();
                            }
                            if (source.getAccessPath().isEmpty()) {
                                return Collections.singleton(source);
                            }
                            HashSet<Abstraction> res = new HashSet<Abstraction>();
                            res.add(source);
                            HashSet<Value> values = new HashSet<Value>();
                            if (condition instanceof Local) {
                                values.add(condition);
                            } else {
                                for (ValueBox box : condition.getUseBoxes()) {
                                    values.add(box.getValue());
                                }
                            }
                            for (Value val : values) {
                                IInfoflowCFG.UnitContainer postdom;
                                if (!InfoflowProblem.this.aliasing.mayAlias(val, (Value)source.getAccessPath().getPlainValue()) || (postdom = InfoflowProblem.this.interproceduralCFG().getPostdominatorOf(src)).getMethod() == null && source.getTopPostdominator() != null && InfoflowProblem.this.interproceduralCFG().getMethodOf(postdom.getUnit()) == source.getTopPostdominator().getMethod()) continue;
                                Abstraction newAbs = source.deriveConditionalAbstractionEnter(postdom, stmt);
                                res.add(newAbs);
                                break;
                            }
                            return res;
                        }
                    };
                }
                return Identity.v();
            }

            @Override
            public FlowFunction<Abstraction> getCallFlowFunction(final Unit src, final SootMethod dest) {
                if (!dest.isConcrete()) {
                    InfoflowProblem.this.logger.debug("Call skipped because target has no body: {} -> {}", (Object)src, (Object)dest);
                    return KillAll.v();
                }
                final Stmt stmt = (Stmt)src;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final Local[] paramLocals = dest.getActiveBody().getParameterLocals().toArray(new Local[0]);
                final SourceInfo sourceInfo = InfoflowProblem.this.sourceSinkManager != null ? InfoflowProblem.this.sourceSinkManager.getSourceInfo(stmt, InfoflowProblem.this.interproceduralCFG()) : null;
                final boolean isSink = InfoflowProblem.this.sourceSinkManager != null ? InfoflowProblem.this.sourceSinkManager.isSink(stmt, InfoflowProblem.this.interproceduralCFG(), null) : false;
                final Local thisLocal = dest.isStatic() ? null : dest.getActiveBody().getThisLocal();
                return new SolverCallFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                        if (!res.isEmpty()) {
                            for (Abstraction abs : res) {
                                InfoflowProblem.this.aliasingStrategy.injectCallingContext(abs, InfoflowProblem.this.solver, dest, src, source, d1);
                            }
                        }
                        return this.notifyOutFlowHandlers(stmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        if (InfoflowProblem.this.stopAfterFirstFlow && !InfoflowProblem.this.results.isEmpty()) {
                            return Collections.emptySet();
                        }
                        if (!InfoflowProblem.this.inspectSources && sourceInfo != null) {
                            return Collections.emptySet();
                        }
                        if (!InfoflowProblem.this.inspectSinks && isSink) {
                            return Collections.emptySet();
                        }
                        if (source == InfoflowProblem.this.getZeroValue()) {
                            assert (sourceInfo != null);
                            return Collections.singleton(source);
                        }
                        if (InfoflowProblem.this.taintPropagationHandlers != null) {
                            for (TaintPropagationHandler tp : InfoflowProblem.this.taintPropagationHandlers) {
                                tp.notifyFlowIn(stmt, source, InfoflowProblem.this.interproceduralCFG(), TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                            }
                        }
                        if (InfoflowProblem.this.taintWrapper != null && InfoflowProblem.this.taintWrapper.isExclusive(stmt, source)) {
                            return Collections.emptySet();
                        }
                        if (source.isTopPostdominator(stmt) && (source = source.dropTopPostdominator()).getAccessPath().isEmpty() && source.getTopPostdominator() == null) {
                            return Collections.emptySet();
                        }
                        if (source.getAccessPath().isEmpty()) {
                            assert (InfoflowProblem.this.enableImplicitFlows);
                            if (d1 != null) {
                                Set callSites = InfoflowProblem.this.implicitTargets.putIfAbsentElseGet(src, new ConcurrentHashSet());
                                callSites.add(d1);
                            }
                            Abstraction abs = source.deriveConditionalAbstractionCall(src);
                            return Collections.singleton(abs);
                        }
                        if (source.getTopPostdominator() != null) {
                            return Collections.emptySet();
                        }
                        if (InfoflowProblem.this.implicitTargets.containsKey(src) && (d1 == null || ((Set)InfoflowProblem.this.implicitTargets.get(src)).contains(d1))) {
                            return Collections.emptySet();
                        }
                        if (source.getAccessPath().isStaticFieldRef() && !InfoflowProblem.this.enableStaticFields) {
                            return Collections.emptySet();
                        }
                        Set res = this.mapAccessPathToCallee(dest, ie, paramLocals, thisLocal, source.getAccessPath());
                        if (res == null) {
                            return Collections.emptySet();
                        }
                        HashSet<Abstraction> resAbs = new HashSet<Abstraction>(res.size());
                        for (AccessPath ap : res) {
                            if (ap.isStaticFieldRef()) {
                                if (!InfoflowProblem.this.interproceduralCFG().isStaticFieldRead(dest, ap.getFirstField())) continue;
                                resAbs.add(source.deriveNewAbstraction(ap, stmt));
                                continue;
                            }
                            if (!source.isImplicit() && !InfoflowProblem.this.interproceduralCFG().methodReadsValue(dest, ap.getPlainValue())) continue;
                            resAbs.add(source.deriveNewAbstraction(ap, stmt));
                        }
                        return resAbs;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getReturnFlowFunction(final Unit callSite, final SootMethod callee, final Unit exitStmt, Unit retSite) {
                if (callSite != null && !(callSite instanceof Stmt)) {
                    return KillAll.v();
                }
                final Stmt iCallStmt = (Stmt)callSite;
                final ThrowStmt throwStmt = exitStmt instanceof ThrowStmt ? (ThrowStmt)exitStmt : null;
                final ReturnStmt returnStmt = exitStmt instanceof ReturnStmt ? (ReturnStmt)exitStmt : null;
                final Local[] paramLocals = callee.getActiveBody().getParameterLocals().toArray(new Local[0]);
                final Local thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
                return new SolverReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction source, Abstraction d1, Collection<Abstraction> callerD1s) {
                        Set<Abstraction> res = this.computeTargetsInternal(source, callerD1s);
                        return this.notifyOutFlowHandlers(exitStmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction source, Collection<Abstraction> callerD1s) {
                        boolean insideConditional;
                        if (InfoflowProblem.this.stopAfterFirstFlow && !InfoflowProblem.this.results.isEmpty()) {
                            return Collections.emptySet();
                        }
                        if (source == InfoflowProblem.this.getZeroValue()) {
                            return Collections.emptySet();
                        }
                        if (InfoflowProblem.this.taintPropagationHandlers != null) {
                            for (TaintPropagationHandler tp : InfoflowProblem.this.taintPropagationHandlers) {
                                tp.notifyFlowIn(exitStmt, source, InfoflowProblem.this.interproceduralCFG(), TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                            }
                        }
                        boolean callerD1sConditional = false;
                        for (Abstraction d1 : callerD1s) {
                            if (!d1.getAccessPath().isEmpty()) continue;
                            callerD1sConditional = true;
                            break;
                        }
                        Abstraction newSource = source;
                        if (!source.isAbstractionActive() && callSite != null && (callSite == source.getActivationUnit() || InfoflowProblem.this.isCallSiteActivatingTaint(callSite, source.getActivationUnit()))) {
                            newSource = source.getActiveCopy();
                        }
                        if (source.getAccessPath().isEmpty()) {
                            if (returnStmt != null && returnStmt.getOp() instanceof Constant && callSite instanceof DefinitionStmt) {
                                DefinitionStmt def = (DefinitionStmt)callSite;
                                Abstraction abs = newSource.deriveNewAbstraction(newSource.getAccessPath().copyWithNewValue(def.getLeftOp()), (Stmt)exitStmt);
                                HashSet<Abstraction> res = new HashSet<Abstraction>();
                                res.add(abs);
                                if (InfoflowProblem.this.triggerInaktiveTaintOrReverseFlow(def, def.getLeftOp(), abs) && !callerD1sConditional) {
                                    for (Abstraction d1 : callerD1s) {
                                        InfoflowProblem.this.computeAliasTaints(d1, iCallStmt, def.getLeftOp(), res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(callSite), abs);
                                    }
                                }
                                return res;
                            }
                            return Collections.emptySet();
                        }
                        boolean bl = insideConditional = newSource.getTopPostdominator() != null || newSource.getAccessPath().isEmpty();
                        if (newSource.isTopPostdominator(exitStmt) || newSource.isTopPostdominator(callee)) {
                            newSource = newSource.dropTopPostdominator();
                            if (!insideConditional && newSource.getAccessPath().isEmpty() && newSource.getTopPostdominator() == null) {
                                return Collections.emptySet();
                            }
                        }
                        if (!newSource.isAbstractionActive() && newSource.getActivationUnit() != null && InfoflowProblem.this.interproceduralCFG().getMethodOf(newSource.getActivationUnit()) == callee) {
                            return Collections.emptySet();
                        }
                        if (!InfoflowProblem.this.enableStaticFields && newSource.getAccessPath().isStaticFieldRef()) {
                            return Collections.emptySet();
                        }
                        if (returnStmt != null) {
                            assert (returnStmt.getOp() == null || returnStmt.getOp() instanceof Local || returnStmt.getOp() instanceof Constant);
                            boolean mustTaintSink = insideConditional;
                            if ((mustTaintSink |= returnStmt.getOp() != null && newSource.getAccessPath().isLocal() && InfoflowProblem.this.aliasing.mayAlias(newSource.getAccessPath().getPlainValue(), returnStmt.getOp())) && InfoflowProblem.this.sourceSinkManager != null && InfoflowProblem.this.sourceSinkManager.isSink(returnStmt, InfoflowProblem.this.interproceduralCFG(), newSource.getAccessPath()) && newSource.isAbstractionActive()) {
                                InfoflowProblem.this.addResult(new AbstractionAtSink(newSource, returnStmt));
                            }
                        }
                        if (callSite == null) {
                            return Collections.emptySet();
                        }
                        if (throwStmt != null && InfoflowProblem.this.aliasing.mayAlias(throwStmt.getOp(), (Value)source.getAccessPath().getPlainValue())) {
                            return Collections.singleton(source.deriveNewAbstractionOnThrow(throwStmt));
                        }
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (returnStmt != null && callSite instanceof DefinitionStmt) {
                            Value retLocal = returnStmt.getOp();
                            DefinitionStmt defnStmt = (DefinitionStmt)callSite;
                            Value leftOp = defnStmt.getLeftOp();
                            if (insideConditional && leftOp instanceof FieldRef || InfoflowProblem.this.aliasing.mayAlias(retLocal, (Value)newSource.getAccessPath().getPlainValue())) {
                                Abstraction abs = newSource.deriveNewAbstraction(newSource.getAccessPath().copyWithNewValue(leftOp), (Stmt)exitStmt);
                                res.add(abs);
                                if (abs.isImplicit() && (abs.getAccessPath().isInstanceFieldRef() || abs.getAccessPath().isStaticFieldRef()) && !callerD1sConditional || InfoflowProblem.this.aliasingStrategy.requiresAnalysisOnReturn()) {
                                    for (Abstraction d1 : callerD1s) {
                                        InfoflowProblem.this.computeAliasTaints(d1, iCallStmt, leftOp, res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(callSite), abs);
                                    }
                                }
                            }
                        }
                        if (newSource.getAccessPath().isStaticFieldRef()) {
                            Abstraction abs = newSource;
                            res.add(abs);
                            if (abs.isImplicit() && !callerD1sConditional || InfoflowProblem.this.aliasingStrategy.requiresAnalysisOnReturn()) {
                                for (Abstraction d1 : callerD1s) {
                                    InfoflowProblem.this.computeAliasTaints(d1, iCallStmt, null, res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(callSite), abs);
                                }
                            }
                        }
                        Local sourceBase = newSource.getAccessPath().getPlainValue();
                        boolean parameterAliases = false;
                        Value originalCallArg = null;
                        for (int i = 0; i < callee.getParameterCount(); ++i) {
                            if (callSite instanceof DefinitionStmt) {
                                DefinitionStmt defnStmt = (DefinitionStmt)callSite;
                                Value leftOp = defnStmt.getLeftOp();
                                originalCallArg = defnStmt.getInvokeExpr().getArg(i);
                                if (originalCallArg == leftOp) continue;
                            }
                            if (!InfoflowProblem.this.aliasing.mayAlias(paramLocals[i], (Value)sourceBase)) continue;
                            parameterAliases = true;
                            originalCallArg = iCallStmt.getInvokeExpr().getArg(i);
                            if (!AccessPath.canContainValue(originalCallArg) || !InfoflowProblem.this.checkCast(source.getAccessPath(), originalCallArg.getType()) || source.getAccessPath().getBaseType() instanceof PrimType || InfoflowProblem.this.isStringType(source.getAccessPath().getBaseType())) continue;
                            Abstraction abs = newSource.deriveNewAbstraction(newSource.getAccessPath().copyWithNewValue(originalCallArg), (Stmt)exitStmt);
                            res.add(abs);
                            if ((!abs.isImplicit() || !InfoflowProblem.this.implicitFlowAliasingStrategy.hasProcessedMethod(callee) || callerD1sConditional) && !InfoflowProblem.this.aliasingStrategy.requiresAnalysisOnReturn()) continue;
                            assert (originalCallArg.getType() instanceof ArrayType || originalCallArg.getType() instanceof RefType);
                            for (Abstraction d1 : callerD1s) {
                                InfoflowProblem.this.computeAliasTaints(d1, iCallStmt, originalCallArg, res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(callSite), abs);
                            }
                        }
                        if (!callee.isStatic() && InfoflowProblem.this.aliasing.mayAlias(thisLocal, (Value)sourceBase) && !parameterAliases && iCallStmt.getInvokeExpr() instanceof InstanceInvokeExpr) {
                            InstanceInvokeExpr iIExpr = (InstanceInvokeExpr)iCallStmt.getInvokeExpr();
                            Abstraction abs = newSource.deriveNewAbstraction(newSource.getAccessPath().copyWithNewValue(iIExpr.getBase()), (Stmt)exitStmt);
                            res.add(abs);
                            if (abs.isImplicit() && InfoflowProblem.this.triggerInaktiveTaintOrReverseFlow(iCallStmt, iIExpr.getBase(), abs) && InfoflowProblem.this.implicitFlowAliasingStrategy.hasProcessedMethod(callee) && !callerD1sConditional || InfoflowProblem.this.aliasingStrategy.requiresAnalysisOnReturn()) {
                                for (Abstraction d1 : callerD1s) {
                                    InfoflowProblem.this.computeAliasTaints(d1, iCallStmt, iIExpr.getBase(), res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(callSite), abs);
                                }
                            }
                        }
                        for (Abstraction abs : res) {
                            if (abs == newSource) continue;
                            abs.setCorrespondingCallSite(iCallStmt);
                        }
                        return res;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getCallToReturnFlowFunction(final Unit call, Unit returnSite) {
                if (!(call instanceof Stmt)) {
                    return KillAll.v();
                }
                final Stmt iCallStmt = (Stmt)call;
                final InvokeExpr invExpr = iCallStmt.getInvokeExpr();
                final Value[] callArgs = new Value[invExpr.getArgCount()];
                for (int i = 0; i < invExpr.getArgCount(); ++i) {
                    callArgs[i] = invExpr.getArg(i);
                }
                final SourceInfo sourceInfo = InfoflowProblem.this.sourceSinkManager != null ? InfoflowProblem.this.sourceSinkManager.getSourceInfo(iCallStmt, InfoflowProblem.this.interproceduralCFG()) : null;
                final boolean isSink = InfoflowProblem.this.sourceSinkManager != null ? InfoflowProblem.this.sourceSinkManager.isSink(iCallStmt, InfoflowProblem.this.interproceduralCFG(), null) : false;
                final SootMethod callee = invExpr.getMethod();
                final boolean hasValidCallees = this.hasValidCallees(call);
                return new SolverCallToReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                        return this.notifyOutFlowHandlers(call, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        if (InfoflowProblem.this.stopAfterFirstFlow && !InfoflowProblem.this.results.isEmpty()) {
                            return Collections.emptySet();
                        }
                        if (InfoflowProblem.this.taintPropagationHandlers != null) {
                            for (TaintPropagationHandler tp : InfoflowProblem.this.taintPropagationHandlers) {
                                tp.notifyFlowIn(call, source, InfoflowProblem.this.interproceduralCFG(), TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                            }
                        }
                        if (source.isTopPostdominator(call) && (source = source.dropTopPostdominator()).getAccessPath().isEmpty() && source.getTopPostdominator() == null) {
                            return Collections.emptySet();
                        }
                        if (!InfoflowProblem.this.enableStaticFields && source.getAccessPath().isStaticFieldRef()) {
                            return Collections.emptySet();
                        }
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (source == InfoflowProblem.this.getZeroValue() && sourceInfo != null && !sourceInfo.getAccessPaths().isEmpty()) {
                            for (AccessPath ap : sourceInfo.getAccessPaths()) {
                                Abstraction abs = new Abstraction(ap, iCallStmt, sourceInfo.getUserData(), false, false);
                                res.add(abs);
                                if (InfoflowProblem.this.triggerInaktiveTaintOrReverseFlow(iCallStmt, ap.getPlainValue(), abs)) {
                                    InfoflowProblem.this.computeAliasTaints(d1, iCallStmt, ap.getPlainValue(), res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(call), abs);
                                }
                                for (Abstraction absRet : res) {
                                    if (absRet == source) continue;
                                    absRet.setCorrespondingCallSite(iCallStmt);
                                }
                            }
                            return res;
                        }
                        Abstraction newSource = !source.isAbstractionActive() && (call == source.getActivationUnit() || InfoflowProblem.this.isCallSiteActivatingTaint(call, source.getActivationUnit())) ? source.getActiveCopy() : source;
                        boolean passOn = true;
                        Set wrapperTaints = InfoflowProblem.this.computeWrapperTaints(d1, iCallStmt, newSource);
                        if (wrapperTaints != null) {
                            res.addAll(wrapperTaints);
                            for (Abstraction wrapperAbs : wrapperTaints) {
                                if (!wrapperAbs.getAccessPath().equals(newSource.getAccessPath())) continue;
                                passOn = false;
                                break;
                            }
                        }
                        if (InfoflowProblem.this.sourceSinkManager != null && InfoflowProblem.this.sourceSinkManager.isSink(iCallStmt, InfoflowProblem.this.interproceduralCFG(), newSource.getAccessPath())) {
                            boolean taintedParam;
                            boolean conditionalCall = InfoflowProblem.this.enableImplicitFlows && !((SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(call)).isStatic() && InfoflowProblem.this.aliasing.mayAlias(((SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(call)).getActiveBody().getThisLocal(), (Value)newSource.getAccessPath().getPlainValue()) && newSource.getAccessPath().getFirstField() == null;
                            boolean bl = taintedParam = (conditionalCall || newSource.getTopPostdominator() != null || newSource.getAccessPath().isEmpty()) && newSource.isAbstractionActive();
                            if (!taintedParam) {
                                for (int i = 0; i < callArgs.length; ++i) {
                                    if (!InfoflowProblem.this.aliasing.mayAlias(callArgs[i], (Value)newSource.getAccessPath().getPlainValue())) continue;
                                    taintedParam = true;
                                    break;
                                }
                            }
                            if (taintedParam && newSource.isAbstractionActive()) {
                                InfoflowProblem.this.addResult(new AbstractionAtSink(newSource, iCallStmt));
                            }
                            if (invExpr instanceof InstanceInvokeExpr) {
                                InstanceInvokeExpr vie = (InstanceInvokeExpr)iCallStmt.getInvokeExpr();
                                if (newSource.isAbstractionActive() && InfoflowProblem.this.aliasing.mayAlias(vie.getBase(), (Value)newSource.getAccessPath().getPlainValue())) {
                                    InfoflowProblem.this.addResult(new AbstractionAtSink(newSource, iCallStmt));
                                }
                            }
                        }
                        if (newSource.getTopPostdominator() != null && newSource.getTopPostdominator().getUnit() == null) {
                            return Collections.singleton(newSource);
                        }
                        if (call instanceof DefinitionStmt) {
                            boolean implicitTaint;
                            boolean bl = implicitTaint = newSource.getTopPostdominator() != null && newSource.getTopPostdominator().getUnit() != null;
                            if (implicitTaint |= newSource.getAccessPath().isEmpty()) {
                                Value leftVal = ((DefinitionStmt)call).getLeftOp();
                                if ((d1 == null || d1.getAccessPath().isEmpty()) && !(leftVal instanceof FieldRef)) {
                                    return Collections.singleton(newSource);
                                }
                                Abstraction abs = newSource.deriveNewAbstraction(new AccessPath(leftVal, true), iCallStmt);
                                return new TwoElementSet<Abstraction>(newSource, abs);
                            }
                        }
                        if (passOn) {
                            if (newSource.getAccessPath().isStaticFieldRef()) {
                                passOn = false;
                            } else if (call instanceof DefinitionStmt && InfoflowProblem.this.aliasing.mayAlias(((DefinitionStmt)call).getLeftOp(), (Value)newSource.getAccessPath().getPlainValue())) {
                                passOn = false;
                            }
                        }
                        if (passOn && invExpr instanceof InstanceInvokeExpr && newSource.getAccessPath().isInstanceFieldRef() && (InfoflowProblem.this.inspectSinks || !isSink) && (hasValidCallees || InfoflowProblem.this.taintWrapper != null && InfoflowProblem.this.taintWrapper.isExclusive(iCallStmt, newSource))) {
                            boolean allCalleesRead = true;
                            block5: for (SootMethod callee2 : InfoflowProblem.this.interproceduralCFG().getCalleesOfCallAt(call)) {
                                Set calleeAPs;
                                if (!callee2.isConcrete() || !callee2.hasActiveBody() || (calleeAPs = this.mapAccessPathToCallee(callee2, invExpr, null, null, source.getAccessPath())) == null) continue;
                                for (AccessPath ap : calleeAPs) {
                                    if (InfoflowProblem.this.interproceduralCFG().methodReadsValue(callee2, ap.getPlainValue())) continue;
                                    allCalleesRead = false;
                                    break block5;
                                }
                            }
                            if (allCalleesRead) {
                                if (InfoflowProblem.this.aliasing.mayAlias(((InstanceInvokeExpr)invExpr).getBase(), (Value)newSource.getAccessPath().getPlainValue())) {
                                    passOn = false;
                                }
                                if (passOn) {
                                    for (int i = 0; i < callArgs.length; ++i) {
                                        if (!InfoflowProblem.this.aliasing.mayAlias(callArgs[i], (Value)newSource.getAccessPath().getPlainValue())) continue;
                                        passOn = false;
                                        break;
                                    }
                                }
                                if (newSource.getAccessPath().isStaticFieldRef()) {
                                    passOn = false;
                                }
                            }
                        }
                        if (source.getAccessPath().isStaticFieldRef() && !InfoflowProblem.this.interproceduralCFG().isStaticFieldUsed(callee, source.getAccessPath().getFirstField())) {
                            passOn = true;
                        }
                        if ((passOn |= source.getTopPostdominator() != null || source.getAccessPath().isEmpty()) && newSource != InfoflowProblem.this.getZeroValue()) {
                            res.add(newSource);
                        }
                        if (callee.isNative()) {
                            for (Value callVal : callArgs) {
                                if (callVal != newSource.getAccessPath().getPlainValue()) continue;
                                Set<Abstraction> nativeAbs = InfoflowProblem.this.ncHandler.getTaintedValues(iCallStmt, newSource, callArgs);
                                res.addAll(nativeAbs);
                                for (Abstraction abs : nativeAbs) {
                                    if (!abs.getAccessPath().isStaticFieldRef() && !InfoflowProblem.this.triggerInaktiveTaintOrReverseFlow(iCallStmt, abs.getAccessPath().getPlainValue(), abs)) continue;
                                    InfoflowProblem.this.computeAliasTaints(d1, iCallStmt, abs.getAccessPath().getPlainValue(), res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(call), abs);
                                }
                                break;
                            }
                        }
                        for (Abstraction abs : res) {
                            if (abs == newSource) continue;
                            abs.setCorrespondingCallSite(iCallStmt);
                        }
                        return res;
                    }
                };
            }

            private Set<AccessPath> mapAccessPathToCallee(SootMethod callee, InvokeExpr ie, Value[] paramLocals, Local thisLocal, AccessPath ap) {
                if (ap.isEmpty()) {
                    return Collections.emptySet();
                }
                boolean isExecutorExecute = InfoflowProblem.this.isExecutorExecute(ie, callee);
                HashSet<AccessPath> res = null;
                if (!(isExecutorExecute || ap.isStaticFieldRef() || callee.isStatic())) {
                    assert (ie instanceof InstanceInvokeExpr);
                    InstanceInvokeExpr vie = (InstanceInvokeExpr)ie;
                    if (InfoflowProblem.this.aliasing.mayAlias(vie.getBase(), (Value)ap.getPlainValue()) && InfoflowProblem.this.hasCompatibleTypesForCall(ap, callee.getDeclaringClass())) {
                        if (res == null) {
                            res = new HashSet();
                        }
                        if (thisLocal == null) {
                            thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
                        }
                        res.add(ap.copyWithNewValue(thisLocal));
                    }
                } else if (ap.isStaticFieldRef()) {
                    if (res == null) {
                        res = new HashSet<AccessPath>();
                    }
                    res.add(ap);
                }
                if (isExecutorExecute) {
                    if (InfoflowProblem.this.aliasing.mayAlias(ie.getArg(0), (Value)ap.getPlainValue())) {
                        if (res == null) {
                            res = new HashSet();
                        }
                        res.add(ap.copyWithNewValue(callee.getActiveBody().getThisLocal()));
                    }
                } else if (callee.getParameterCount() > 0) {
                    assert (callee.getParameterCount() == ie.getArgCount());
                    for (int i = 0; i < ie.getArgCount(); ++i) {
                        if (!InfoflowProblem.this.aliasing.mayAlias(ie.getArg(i), (Value)ap.getPlainValue())) continue;
                        if (res == null) {
                            res = new HashSet();
                        }
                        if (paramLocals == null) {
                            paramLocals = callee.getActiveBody().getParameterLocals().toArray(new Local[callee.getParameterCount()]);
                        }
                        res.add(ap.copyWithNewValue(paramLocals[i]));
                    }
                }
                return res;
            }

            abstract class NotifyingNormalFlowFunction
            extends SolverNormalFlowFunction {
                private final Stmt stmt;

                public NotifyingNormalFlowFunction(Stmt stmt) {
                    this.stmt = stmt;
                }

                @Override
                public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                    if (InfoflowProblem.this.stopAfterFirstFlow && !InfoflowProblem.this.results.isEmpty()) {
                        return Collections.emptySet();
                    }
                    if (InfoflowProblem.this.taintPropagationHandlers != null) {
                        for (TaintPropagationHandler tp : InfoflowProblem.this.taintPropagationHandlers) {
                            tp.notifyFlowIn(this.stmt, source, InfoflowProblem.this.interproceduralCFG(), TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                        }
                    }
                    Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                    return this.notifyOutFlowHandlers(this.stmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                }

                public abstract Set<Abstraction> computeTargetsInternal(Abstraction var1, Abstraction var2);
            }
        };
    }

    @Override
    public boolean autoAddZero() {
        return false;
    }

    private void addResult(AbstractionAtSink resultAbs) {
        if (this.ignoreFlowsInSystemPackages && SystemClassHandler.isClassInSystemPackage(((SootMethod)this.interproceduralCFG().getMethodOf(resultAbs.getSinkStmt())).getDeclaringClass().getName())) {
            return;
        }
        resultAbs = new AbstractionAtSink(resultAbs.getAbstraction().deriveNewAbstraction(resultAbs.getAbstraction().getAccessPath(), resultAbs.getSinkStmt()), resultAbs.getSinkStmt());
        resultAbs.getAbstraction().setCorrespondingCallSite(resultAbs.getSinkStmt());
        Abstraction newAbs = this.results.putIfAbsentElseGet(resultAbs, resultAbs.getAbstraction());
        if (newAbs != resultAbs.getAbstraction()) {
            newAbs.addNeighbor(resultAbs.getAbstraction());
        }
    }

    public Set<AbstractionAtSink> getResults() {
        return this.results.keySet();
    }
}

