/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MutableTwoElementSet<E>
extends AbstractSet<E> {
    protected E first;
    protected E second;

    public MutableTwoElementSet() {
        this.first = null;
        this.second = null;
    }

    public MutableTwoElementSet(E first, E second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean add(E item) {
        if (this.first == null) {
            this.first = item;
            return true;
        }
        if (this.first != null && this.first.equals(item)) {
            return false;
        }
        if (this.second == null) {
            this.second = item;
            return true;
        }
        if (this.second != null && this.second.equals(item)) {
            return false;
        }
        throw new RuntimeException("Capacity exceeded");
    }

    public static <E> MutableTwoElementSet<E> twoElementSet(E first, E second) {
        return new MutableTwoElementSet<E>(first, second);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int size = -1;
            int elementsRead = 0;

            @Override
            public boolean hasNext() {
                if (this.size < 0) {
                    this.size = MutableTwoElementSet.this.size();
                }
                return this.elementsRead < this.size;
            }

            @Override
            public E next() {
                switch (this.elementsRead) {
                    case 0: {
                        ++this.elementsRead;
                        return MutableTwoElementSet.this.first;
                    }
                    case 1: {
                        ++this.elementsRead;
                        return MutableTwoElementSet.this.second;
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        int size = 0;
        if (this.first != null) {
            ++size;
        }
        if (this.second != null) {
            ++size;
        }
        return size;
    }
}

