/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.results;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;

public class InfoflowResults {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MyConcurrentHashMap<ResultSinkInfo, Set<ResultSourceInfo>> results = new MyConcurrentHashMap();

    public int size() {
        return this.results == null ? 0 : this.results.size();
    }

    public int numConnections() {
        int num = 0;
        if (this.results != null) {
            for (Map.Entry entry : this.results.entrySet()) {
                num += ((Set)entry.getValue()).size();
            }
        }
        return num;
    }

    public boolean isEmpty() {
        return this.results == null || this.results.isEmpty();
    }

    public boolean containsSink(Stmt sink) {
        for (ResultSinkInfo si : this.results.keySet()) {
            if (!si.getSink().equals(sink)) continue;
            return true;
        }
        return false;
    }

    public boolean containsSinkMethod(String sinkSignature) {
        return !this.findSinkByMethodSignature(sinkSignature).isEmpty();
    }

    public void addResult(AccessPath sink, Stmt sinkStmt, AccessPath source, Stmt sourceStmt) {
        this.addResult(new ResultSinkInfo(sink, sinkStmt), new ResultSourceInfo(source, sourceStmt));
    }

    public void addResult(AccessPath sink, Stmt sinkStmt, AccessPath source, Stmt sourceStmt, Object userData, List<Stmt> propagationPath) {
        this.addResult(new ResultSinkInfo(sink, sinkStmt), new ResultSourceInfo(source, sourceStmt, userData, propagationPath));
    }

    public void addResult(ResultSinkInfo sink, ResultSourceInfo source) {
        assert (sink != null);
        assert (source != null);
        Set sourceInfo = this.results.putIfAbsentElseGet(sink, new ConcurrentHashSet());
        sourceInfo.add(source);
    }

    public Map<ResultSinkInfo, Set<ResultSourceInfo>> getResults() {
        return this.results;
    }

    public boolean isPathBetween(Stmt sink, Stmt source) {
        Set sources = null;
        for (ResultSinkInfo sI : this.results.keySet()) {
            if (!sI.getSink().equals(sink)) continue;
            sources = (Set)this.results.get(sI);
            break;
        }
        if (sources == null) {
            return false;
        }
        for (ResultSourceInfo src : sources) {
            if (!src.getAccessPath().equals(source)) continue;
            return true;
        }
        return false;
    }

    public boolean isPathBetween(String sink, String source) {
        for (ResultSinkInfo si : this.results.keySet()) {
            if (!si.getAccessPath().getPlainValue().toString().equals(sink)) continue;
            Set sources = (Set)this.results.get(si);
            for (ResultSourceInfo src : sources) {
                if (!src.getSource().toString().contains(source)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPathBetweenMethods(String sinkSignature, String sourceSignature) {
        List<ResultSinkInfo> sinkVals = this.findSinkByMethodSignature(sinkSignature);
        for (ResultSinkInfo si : sinkVals) {
            Set sources = (Set)this.results.get(si);
            if (sources == null) {
                return false;
            }
            for (ResultSourceInfo src : sources) {
                InvokeExpr expr;
                if (!src.getSource().containsInvokeExpr() || !(expr = src.getSource().getInvokeExpr()).getMethod().getSignature().equals(sourceSignature)) continue;
                return true;
            }
        }
        return false;
    }

    private List<ResultSinkInfo> findSinkByMethodSignature(String sinkSignature) {
        ArrayList<ResultSinkInfo> sinkVals = new ArrayList<ResultSinkInfo>();
        for (ResultSinkInfo si : this.results.keySet()) {
            InvokeExpr expr;
            if (!si.getSink().containsInvokeExpr() || !(expr = si.getSink().getInvokeExpr()).getMethod().getSignature().equals(sinkSignature)) continue;
            sinkVals.add(si);
        }
        return sinkVals;
    }

    public void printResults() {
        for (ResultSinkInfo sink : this.results.keySet()) {
            this.logger.info("Found a flow to sink {}, from the following sources:", (Object)sink);
            for (ResultSourceInfo source : (Set)this.results.get(sink)) {
                this.logger.info("\t- {}", (Object)source.getSource());
                if (source.getPath() == null || source.getPath().isEmpty()) continue;
                this.logger.info("\t\ton Path {}", (Object)source.getPath());
            }
        }
    }

    public void printResults(Writer wr) throws IOException {
        for (ResultSinkInfo sink : this.results.keySet()) {
            wr.write("Found a flow to sink " + sink + ", from the following sources:\n");
            for (ResultSourceInfo source : (Set)this.results.get(sink)) {
                wr.write("\t- " + source.getSource() + "\n");
                if (source.getPath() == null || source.getPath().isEmpty()) continue;
                wr.write("\t\ton Path " + source.getPath() + "\n");
            }
        }
    }

    public void clear() {
        this.results.clear();
    }

    public String toString() {
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (ResultSinkInfo sink : this.results.keySet()) {
            for (ResultSourceInfo source : (Set)this.results.get(sink)) {
                if (!isFirst) {
                    sb.append(", ");
                }
                isFirst = false;
                sb.append(source);
                sb.append(" -> ");
                sb.append(sink);
            }
        }
        return sb.toString();
    }
}

