/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.results;

import soot.jimple.Stmt;
import soot.jimple.infoflow.Infoflow;
import soot.jimple.infoflow.data.AccessPath;
import soot.tagkit.LineNumberTag;

public class ResultSinkInfo {
    private final AccessPath accessPath;
    private final Stmt sink;

    public ResultSinkInfo(AccessPath sink, Stmt context) {
        assert (sink != null);
        this.accessPath = sink;
        this.sink = context;
    }

    public AccessPath getAccessPath() {
        return this.accessPath;
    }

    public Stmt getSink() {
        return this.sink;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.sink == null ? this.accessPath.toString() : this.sink.toString());
        if (this.sink != null && this.sink.hasTag("LineNumberTag")) {
            sb.append(" on line ").append(((LineNumberTag)this.sink.getTag("LineNumberTag")).getLineNumber());
        }
        return sb.toString();
    }

    public int hashCode() {
        return (Infoflow.getOneResultPerAccessPath() ? 31 * this.accessPath.hashCode() : 0) + 7 * (this.sink == null ? 0 : this.sink.hashCode());
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (o == null || !(o instanceof ResultSinkInfo)) {
            return false;
        }
        ResultSinkInfo si = (ResultSinkInfo)o;
        if (this.sink == null ? si.sink != null : !this.sink.equals(si.sink)) {
            return false;
        }
        return !Infoflow.getOneResultPerAccessPath() || this.accessPath.equals(si.accessPath);
    }
}

