/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.results;

import java.util.List;
import soot.jimple.Stmt;
import soot.jimple.infoflow.Infoflow;
import soot.jimple.infoflow.data.AccessPath;
import soot.tagkit.LineNumberTag;

public class ResultSourceInfo {
    private final AccessPath accessPath;
    private final Stmt source;
    private final Object userData;
    private final List<Stmt> path;

    public ResultSourceInfo(AccessPath source, Stmt context) {
        assert (source != null);
        this.accessPath = source;
        this.source = context;
        this.userData = null;
        this.path = null;
    }

    public ResultSourceInfo(AccessPath source, Stmt context, Object userData, List<Stmt> path) {
        assert (source != null);
        this.accessPath = source;
        this.source = context;
        this.userData = userData;
        this.path = path;
    }

    public AccessPath getAccessPath() {
        return this.accessPath;
    }

    public Stmt getSource() {
        return this.source;
    }

    public Object getUserData() {
        return this.userData;
    }

    public List<Stmt> getPath() {
        return this.path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.source.toString());
        if (this.source.hasTag("LineNumberTag")) {
            sb.append(" on line ").append(((LineNumberTag)this.source.getTag("LineNumberTag")).getLineNumber());
        }
        return sb.toString();
    }

    public int hashCode() {
        return (this.path != null && !Infoflow.getPathAgnosticResults() ? 31 * this.path.hashCode() : 0) + (Infoflow.getOneResultPerAccessPath() ? 31 * this.accessPath.hashCode() : 0) + 7 * (this.source == null ? 0 : this.source.hashCode());
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (o == null || !(o instanceof ResultSourceInfo)) {
            return false;
        }
        ResultSourceInfo si = (ResultSourceInfo)o;
        if (!Infoflow.getPathAgnosticResults()) {
            if (this.path == null && si.path != null) {
                return false;
            }
            if (this.path != null && si.path == null) {
                return false;
            }
            if (!this.path.equals(si.path)) {
                return false;
            }
        }
        if (this.source == null ? si.source != null : !this.source.equals(si.source)) {
            return false;
        }
        return !Infoflow.getOneResultPerAccessPath() || this.accessPath.equals(si.accessPath);
    }
}

