/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.rifl;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import soot.jimple.infoflow.rifl.RIFLDocument;

public class RIFLWriter {
    private final RIFLDocument document;

    public RIFLWriter(RIFLDocument document) {
        this.document = document;
    }

    public String write() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element rootElement = document.createElement("riflspec");
            document.appendChild(rootElement);
            this.writeAttackerIO(document, rootElement);
            this.writeDomains(document, rootElement);
            this.writeDomainAssignment(document, rootElement);
            this.writeDomainHierarchy(document, rootElement);
            this.writeFlowPolicy(document, rootElement);
            StringWriter stringWriter = new StringWriter();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stringWriter);
            transformer.transform(source, result);
            return stringWriter.toString();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeAttackerIO(Document document, Element rootElement) {
        Element attackerIO = document.createElement("attackerio");
        rootElement.appendChild(attackerIO);
        Element sources = document.createElement("sources");
        attackerIO.appendChild(sources);
        for (RIFLDocument.SourceSinkSpec spec : this.document.getAttackerIO().getSources()) {
            Element source = document.createElement("source");
            sources.appendChild(source);
            this.writeSourceSinkSpec(spec, document, source);
        }
        Element sinks = document.createElement("sinks");
        attackerIO.appendChild(sinks);
        for (RIFLDocument.SourceSinkSpec spec : this.document.getAttackerIO().getSinks()) {
            Element sink = document.createElement("sink");
            sinks.appendChild(sink);
            this.writeSourceSinkSpec(spec, document, sink);
        }
    }

    private void writeSourceSinkSpec(RIFLDocument.SourceSinkSpec spec, Document document, Element parentElement) {
        if (spec instanceof RIFLDocument.JavaParameterSpec) {
            this.writeJavaParameterSpec((RIFLDocument.JavaParameterSpec)spec, document, parentElement);
        } else if (spec instanceof RIFLDocument.JavaFieldSpec) {
            this.writeJavaFieldSpec((RIFLDocument.JavaFieldSpec)spec, document, parentElement);
        } else {
            throw new RuntimeException("Unsupported source or sink specification type");
        }
    }

    private void writeJavaParameterSpec(RIFLDocument.JavaParameterSpec spec, Document document, Element parentElement) {
        Element parameter = document.createElement("parameter");
        parentElement.appendChild(parameter);
        parameter.setAttribute("package", spec.getPackageName());
        parameter.setAttribute("class", spec.getClassName());
        parameter.setAttribute("method", spec.getHalfSignature());
        parameter.setAttribute("parameter", Integer.toString(spec.getParamIdx()));
    }

    private void writeJavaFieldSpec(RIFLDocument.JavaFieldSpec spec, Document document, Element parentElement) {
        Element parameter = document.createElement("parameter");
        parameter.appendChild(parentElement);
        parameter.setAttribute("package", spec.getPackageName());
        parameter.setAttribute("class", spec.getClassName());
        parameter.setAttribute("field", spec.getFieldName());
    }

    private void writeDomains(Document document, Element rootElement) {
        Element domains = document.createElement("domains");
        rootElement.appendChild(domains);
        for (RIFLDocument.DomainSpec spec : this.document.getDomains()) {
            this.writeDomainSpec(spec, document, domains);
        }
    }

    private void writeDomainSpec(RIFLDocument.DomainSpec spec, Document document, Element parentElement) {
        if (spec instanceof RIFLDocument.TopDomain) {
            Element topDomain = document.createElement("top");
            parentElement.appendChild(topDomain);
        } else if (spec instanceof RIFLDocument.BottomDomain) {
            Element bottomDomain = document.createElement("bottom");
            parentElement.appendChild(bottomDomain);
        } else if (spec instanceof RIFLDocument.Category) {
            Element categoryDomain = document.createElement("category");
            parentElement.appendChild(categoryDomain);
            RIFLDocument.Category cat = (RIFLDocument.Category)spec;
            categoryDomain.setAttribute("value", cat.getValue());
        } else {
            throw new RuntimeException("Unsupported source or sink specification type");
        }
    }

    private void writeDomainAssignment(Document document, Element rootElement) {
        Element domainAssignment = document.createElement("domainassignment");
        rootElement.appendChild(domainAssignment);
        for (RIFLDocument.SourceSinkDomPair spec : this.document.getDomainAssignment()) {
            this.writeSourceSinkDomPair(spec, document, domainAssignment);
        }
    }

    private void writeSourceSinkDomPair(RIFLDocument.SourceSinkDomPair pair, Document document, Element rootElement) {
        Element sourceSinkElement;
        Element pairElement;
        switch (pair.getType()) {
            case SourceDomPair: {
                pairElement = document.createElement("sourcedompair");
                sourceSinkElement = document.createElement("source");
                break;
            }
            case SinkDomPair: {
                pairElement = document.createElement("sinkdompair");
                sourceSinkElement = document.createElement("sink");
                break;
            }
            default: {
                throw new RuntimeException("Invalid source/sink domain pair type");
            }
        }
        rootElement.appendChild(pairElement);
        pairElement.appendChild(sourceSinkElement);
        this.writeSourceSinkSpec(pair.getSourceOrSink(), document, sourceSinkElement);
        this.writeDomainSpec(pair.getDomain(), document, pairElement);
    }

    private void writeDomainHierarchy(Document document, Element rootElement) {
        Element domainHierarchy = document.createElement("domainhierarchy");
        rootElement.appendChild(domainHierarchy);
        for (RIFLDocument.DomPair pair : this.document.getDomainHierarchy()) {
            this.writeDomainPair(pair, document, domainHierarchy);
        }
    }

    private void writeDomainPair(RIFLDocument.DomPair pair, Document document, Element parentElement) {
        Element domPair = document.createElement("dompair");
        parentElement.appendChild(domPair);
        this.writeDomainSpec(pair.getFirstDomain(), document, domPair);
        this.writeDomainSpec(pair.getSecondDomain(), document, domPair);
    }

    private void writeFlowPolicy(Document document, Element rootElement) {
        Element flowPolicy = document.createElement("flowpolicy");
        rootElement.appendChild(flowPolicy);
        for (RIFLDocument.FlowPair pair : this.document.getFlowPolicy()) {
            this.writeFlowPair(pair, document, flowPolicy);
        }
    }

    private void writeFlowPair(RIFLDocument.FlowPair pair, Document document, Element parentElement) {
        Element flowPair = document.createElement("flowpair");
        parentElement.appendChild(flowPair);
        this.writeDomainSpec(pair.getFirstDomain(), document, flowPair);
        this.writeDomainSpec(pair.getSecondDomain(), document, flowPair);
    }

    public RIFLDocument getDocument() {
        return this.document;
    }
}

