/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.Stmt;
import soot.jimple.infoflow.solver.IInfoflowCFG;
import soot.jimple.infoflow.util.ConcurrentHashSet;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.jimple.toolkits.ide.icfg.JimpleBasedInterproceduralCFG;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.SideEffectAnalysis;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.MHGPostDominatorsFinder;

public class InfoflowCFG
implements IInfoflowCFG {
    protected final BiDiInterproceduralCFG<Unit, SootMethod> delegate;
    protected final LoadingCache<Unit, IInfoflowCFG.UnitContainer> unitToPostdominator = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<Unit, IInfoflowCFG.UnitContainer>(){

        @Override
        public IInfoflowCFG.UnitContainer load(Unit unit) throws Exception {
            SootMethod method = InfoflowCFG.this.getMethodOf(unit);
            DirectedGraph<Unit> graph = InfoflowCFG.this.delegate.getOrCreateUnitGraph(method);
            MHGPostDominatorsFinder<Unit> postdominatorFinder = new MHGPostDominatorsFinder<Unit>(graph);
            Unit postdom = postdominatorFinder.getImmediateDominator(unit);
            if (postdom == null) {
                return new IInfoflowCFG.UnitContainer(method);
            }
            return new IInfoflowCFG.UnitContainer(postdom);
        }
    });
    protected final SideEffectAnalysis sideEffectAnalysis;

    public InfoflowCFG() {
        this(new JimpleBasedInterproceduralCFG());
    }

    public InfoflowCFG(BiDiInterproceduralCFG<Unit, SootMethod> delegate) {
        this.delegate = delegate;
        this.sideEffectAnalysis = Scene.v().hasCallGraph() ? new SideEffectAnalysis(Scene.v().getPointsToAnalysis(), Scene.v().getCallGraph()) : null;
    }

    @Override
    public IInfoflowCFG.UnitContainer getPostdominatorOf(Unit u) {
        return this.unitToPostdominator.getUnchecked(u);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SootField> getReadVariables(SootMethod caller, Stmt inv) {
        RWSet rwSet;
        if (this.sideEffectAnalysis == null) {
            return null;
        }
        SideEffectAnalysis sideEffectAnalysis = this.sideEffectAnalysis;
        synchronized (sideEffectAnalysis) {
            rwSet = this.sideEffectAnalysis.readSet(caller, inv);
        }
        if (rwSet == null) {
            return null;
        }
        ConcurrentHashSet<SootField> objSet = new ConcurrentHashSet<SootField>();
        for (Object o : rwSet.getFields()) {
            if (!(o instanceof SootField)) continue;
            objSet.add((SootField)o);
        }
        for (Object o : rwSet.getGlobals()) {
            if (!(o instanceof SootField)) continue;
            objSet.add((SootField)o);
        }
        return objSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SootField> getWriteVariables(SootMethod caller, Stmt inv) {
        RWSet rwSet;
        if (this.sideEffectAnalysis == null) {
            return null;
        }
        SideEffectAnalysis sideEffectAnalysis = this.sideEffectAnalysis;
        synchronized (sideEffectAnalysis) {
            rwSet = this.sideEffectAnalysis.writeSet(caller, inv);
        }
        if (rwSet == null) {
            return null;
        }
        ConcurrentHashSet<SootField> objSet = new ConcurrentHashSet<SootField>();
        for (Object o : rwSet.getFields()) {
            if (!(o instanceof SootField)) continue;
            objSet.add((SootField)o);
        }
        for (Object o : rwSet.getGlobals()) {
            if (!(o instanceof SootField)) continue;
            objSet.add((SootField)o);
        }
        return objSet;
    }

    @Override
    public SootMethod getMethodOf(Unit u) {
        return (SootMethod)this.delegate.getMethodOf(u);
    }

    @Override
    public List<Unit> getSuccsOf(Unit u) {
        return this.delegate.getSuccsOf(u);
    }

    @Override
    public boolean isExitStmt(Unit u) {
        return this.delegate.isExitStmt(u);
    }

    @Override
    public boolean isStartPoint(Unit u) {
        return this.delegate.isStartPoint(u);
    }

    @Override
    public boolean isFallThroughSuccessor(Unit u, Unit succ) {
        return this.delegate.isFallThroughSuccessor(u, succ);
    }

    @Override
    public boolean isBranchTarget(Unit u, Unit succ) {
        return this.delegate.isBranchTarget(u, succ);
    }

    @Override
    public Collection<Unit> getStartPointsOf(SootMethod m) {
        return this.delegate.getStartPointsOf(m);
    }

    @Override
    public boolean isCallStmt(Unit u) {
        return this.delegate.isCallStmt(u);
    }

    @Override
    public Set<Unit> allNonCallStartNodes() {
        return this.delegate.allNonCallStartNodes();
    }

    @Override
    public Set<SootMethod> getCalleesOfCallAt(Unit u) {
        return this.delegate.getCalleesOfCallAt(u);
    }

    @Override
    public Set<Unit> getCallersOf(SootMethod m) {
        return this.delegate.getCallersOf(m);
    }

    @Override
    public Collection<Unit> getReturnSitesOfCallAt(Unit u) {
        return this.delegate.getReturnSitesOfCallAt(u);
    }

    @Override
    public Set<Unit> getCallsFromWithin(SootMethod m) {
        return this.delegate.getCallsFromWithin(m);
    }

    @Override
    public List<Unit> getPredsOf(Unit u) {
        return this.delegate.getPredsOf(u);
    }

    @Override
    public Collection<Unit> getEndPointsOf(SootMethod m) {
        return this.delegate.getEndPointsOf(m);
    }

    @Override
    public List<Unit> getPredsOfCallAt(Unit u) {
        return this.delegate.getPredsOf(u);
    }

    @Override
    public Set<Unit> allNonCallEndNodes() {
        return this.delegate.allNonCallEndNodes();
    }

    @Override
    public DirectedGraph<Unit> getOrCreateUnitGraph(SootMethod m) {
        return this.delegate.getOrCreateUnitGraph(m);
    }

    @Override
    public List<Value> getParameterRefs(SootMethod m) {
        return this.delegate.getParameterRefs(m);
    }

    @Override
    public boolean isReturnSite(Unit n) {
        return this.delegate.isReturnSite(n);
    }
}

