/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.cfg;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import soot.Local;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.jimple.toolkits.ide.icfg.JimpleBasedInterproceduralCFG;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.MHGPostDominatorsFinder;

public class InfoflowCFG
implements IInfoflowCFG {
    protected final Map<SootMethod, Map<SootField, StaticFieldUse>> staticFieldUses = new ConcurrentHashMap<SootMethod, Map<SootField, StaticFieldUse>>();
    protected final Map<SootMethod, Boolean> methodSideEffects = new ConcurrentHashMap<SootMethod, Boolean>();
    protected final BiDiInterproceduralCFG<Unit, SootMethod> delegate;
    protected final LoadingCache<Unit, IInfoflowCFG.UnitContainer> unitToPostdominator = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<Unit, IInfoflowCFG.UnitContainer>(){

        @Override
        public IInfoflowCFG.UnitContainer load(Unit unit) throws Exception {
            SootMethod method = InfoflowCFG.this.getMethodOf(unit);
            DirectedGraph<Unit> graph = InfoflowCFG.this.delegate.getOrCreateUnitGraph(method);
            MHGPostDominatorsFinder<Unit> postdominatorFinder = new MHGPostDominatorsFinder<Unit>(graph);
            Unit postdom = postdominatorFinder.getImmediateDominator(unit);
            if (postdom == null) {
                return new IInfoflowCFG.UnitContainer(method);
            }
            return new IInfoflowCFG.UnitContainer(postdom);
        }
    });
    protected final LoadingCache<SootMethod, Local[]> methodToUsedLocals = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<SootMethod, Local[]>(){

        @Override
        public Local[] load(SootMethod method) throws Exception {
            if (!method.isConcrete() || !method.hasActiveBody()) {
                return new Local[0];
            }
            ArrayList<Local> lcs = new ArrayList<Local>(method.getParameterCount() + (method.isStatic() ? 0 : 1));
            for (Unit u : method.getActiveBody().getUnits()) {
                block1: for (ValueBox vb : u.getUseBoxes()) {
                    for (int i = 0; i < method.getParameterCount(); ++i) {
                        if (method.getActiveBody().getParameterLocal(i) != vb.getValue()) continue;
                        lcs.add((Local)vb.getValue());
                        continue block1;
                    }
                }
            }
            if (!method.isStatic()) {
                lcs.add(method.getActiveBody().getThisLocal());
            }
            return lcs.toArray(new Local[lcs.size()]);
        }
    });

    public InfoflowCFG() {
        this(new JimpleBasedInterproceduralCFG());
    }

    public InfoflowCFG(BiDiInterproceduralCFG<Unit, SootMethod> delegate) {
        this.delegate = delegate;
    }

    @Override
    public IInfoflowCFG.UnitContainer getPostdominatorOf(Unit u) {
        return this.unitToPostdominator.getUnchecked(u);
    }

    @Override
    public SootMethod getMethodOf(Unit u) {
        return (SootMethod)this.delegate.getMethodOf(u);
    }

    @Override
    public List<Unit> getSuccsOf(Unit u) {
        return this.delegate.getSuccsOf(u);
    }

    @Override
    public boolean isExitStmt(Unit u) {
        return this.delegate.isExitStmt(u);
    }

    @Override
    public boolean isStartPoint(Unit u) {
        return this.delegate.isStartPoint(u);
    }

    @Override
    public boolean isFallThroughSuccessor(Unit u, Unit succ) {
        return this.delegate.isFallThroughSuccessor(u, succ);
    }

    @Override
    public boolean isBranchTarget(Unit u, Unit succ) {
        return this.delegate.isBranchTarget(u, succ);
    }

    @Override
    public Collection<Unit> getStartPointsOf(SootMethod m) {
        return this.delegate.getStartPointsOf(m);
    }

    @Override
    public boolean isCallStmt(Unit u) {
        return this.delegate.isCallStmt(u);
    }

    @Override
    public Set<Unit> allNonCallStartNodes() {
        return this.delegate.allNonCallStartNodes();
    }

    @Override
    public Collection<SootMethod> getCalleesOfCallAt(Unit u) {
        return this.delegate.getCalleesOfCallAt(u);
    }

    @Override
    public Collection<Unit> getCallersOf(SootMethod m) {
        return this.delegate.getCallersOf(m);
    }

    @Override
    public Collection<Unit> getReturnSitesOfCallAt(Unit u) {
        return this.delegate.getReturnSitesOfCallAt(u);
    }

    @Override
    public Set<Unit> getCallsFromWithin(SootMethod m) {
        return this.delegate.getCallsFromWithin(m);
    }

    @Override
    public List<Unit> getPredsOf(Unit u) {
        return this.delegate.getPredsOf(u);
    }

    @Override
    public Collection<Unit> getEndPointsOf(SootMethod m) {
        return this.delegate.getEndPointsOf(m);
    }

    @Override
    public List<Unit> getPredsOfCallAt(Unit u) {
        return this.delegate.getPredsOf(u);
    }

    @Override
    public Set<Unit> allNonCallEndNodes() {
        return this.delegate.allNonCallEndNodes();
    }

    @Override
    public DirectedGraph<Unit> getOrCreateUnitGraph(SootMethod m) {
        return this.delegate.getOrCreateUnitGraph(m);
    }

    @Override
    public List<Value> getParameterRefs(SootMethod m) {
        return this.delegate.getParameterRefs(m);
    }

    @Override
    public boolean isReturnSite(Unit n) {
        return this.delegate.isReturnSite(n);
    }

    @Override
    public boolean isStaticFieldRead(SootMethod method, SootField variable) {
        return this.isStaticFieldUsed(method, variable, new HashSet<SootMethod>(), true);
    }

    @Override
    public boolean isStaticFieldUsed(SootMethod method, SootField variable) {
        return this.isStaticFieldUsed(method, variable, new HashSet<SootMethod>(), false);
    }

    private boolean isStaticFieldUsed(SootMethod method, SootField variable, Set<SootMethod> runList, boolean readOnly) {
        StaticFieldUse b;
        if (!method.hasActiveBody()) {
            return false;
        }
        if (!runList.add(method)) {
            return false;
        }
        Map<SootField, StaticFieldUse> entry = this.staticFieldUses.get(method);
        if (entry != null && (b = entry.get(variable)) != null && b != StaticFieldUse.Unknown) {
            if (readOnly) {
                return b == StaticFieldUse.Read || b == StaticFieldUse.ReadWrite;
            }
            return b != StaticFieldUse.Unused;
        }
        for (Unit u : method.getActiveBody().getUnits()) {
            if (u instanceof AssignStmt) {
                SootField sf;
                AssignStmt assign = (AssignStmt)u;
                if (assign.getLeftOp() instanceof StaticFieldRef) {
                    sf = ((StaticFieldRef)assign.getLeftOp()).getField();
                    this.registerStaticVariableUse(method, sf, StaticFieldUse.Write);
                    if (!readOnly && variable.equals(sf)) {
                        return true;
                    }
                }
                if (assign.getRightOp() instanceof StaticFieldRef) {
                    sf = ((StaticFieldRef)assign.getRightOp()).getField();
                    this.registerStaticVariableUse(method, sf, StaticFieldUse.Read);
                    if (variable.equals(sf)) {
                        return true;
                    }
                }
            }
            if (!((Stmt)u).containsInvokeExpr()) continue;
            Iterator<Edge> edgeIt = Scene.v().getCallGraph().edgesOutOf(u);
            while (edgeIt.hasNext()) {
                Edge e = edgeIt.next();
                if (!this.isStaticFieldUsed(e.getTgt().method(), variable, runList, readOnly)) continue;
                return true;
            }
        }
        this.registerStaticVariableUse(method, variable, StaticFieldUse.Unused);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerStaticVariableUse(SootMethod method, SootField variable, StaticFieldUse fieldUse) {
        StaticFieldUse newUse;
        StaticFieldUse oldUse;
        Map<SootField, StaticFieldUse> entry = this.staticFieldUses.get(method);
        Map<SootMethod, Map<SootField, StaticFieldUse>> map = this.staticFieldUses;
        synchronized (map) {
            if (entry == null) {
                entry = new ConcurrentHashMap<SootField, StaticFieldUse>();
                this.staticFieldUses.put(method, entry);
                entry.put(variable, fieldUse);
                return;
            }
            oldUse = entry.get(variable);
            if (oldUse == null) {
                entry.put(variable, fieldUse);
                return;
            }
        }
        switch (oldUse) {
            case Unknown: 
            case Unused: 
            case ReadWrite: {
                newUse = fieldUse;
                break;
            }
            case Read: {
                newUse = fieldUse == StaticFieldUse.Read ? oldUse : StaticFieldUse.ReadWrite;
                break;
            }
            case Write: {
                newUse = fieldUse == StaticFieldUse.Write ? oldUse : StaticFieldUse.ReadWrite;
                break;
            }
            default: {
                throw new RuntimeException("Invalid field use");
            }
        }
        entry.put(variable, newUse);
    }

    @Override
    public boolean hasSideEffects(SootMethod method) {
        return this.hasSideEffects(method, new HashSet<SootMethod>());
    }

    private boolean hasSideEffects(SootMethod method, Set<SootMethod> runList) {
        if (!method.hasActiveBody()) {
            return false;
        }
        if (!runList.add(method)) {
            return false;
        }
        Boolean hasSideEffects = this.methodSideEffects.get(method);
        if (hasSideEffects != null) {
            return hasSideEffects;
        }
        for (Unit u : method.getActiveBody().getUnits()) {
            AssignStmt assign;
            if (u instanceof AssignStmt && (assign = (AssignStmt)u).getLeftOp() instanceof FieldRef) {
                this.methodSideEffects.put(method, true);
                return true;
            }
            if (!((Stmt)u).containsInvokeExpr()) continue;
            Iterator<Edge> edgeIt = Scene.v().getCallGraph().edgesOutOf(u);
            while (edgeIt.hasNext()) {
                Edge e = edgeIt.next();
                if (!this.hasSideEffects(e.getTgt().method(), runList)) continue;
                return true;
            }
        }
        this.methodSideEffects.put(method, false);
        return false;
    }

    @Override
    public void notifyMethodChanged(SootMethod m) {
        if (this.delegate instanceof JimpleBasedInterproceduralCFG) {
            ((JimpleBasedInterproceduralCFG)this.delegate).initializeUnitToOwner(m);
        }
    }

    @Override
    public boolean methodReadsValue(SootMethod m, Value v) {
        Local[] reads = this.methodToUsedLocals.getUnchecked(m);
        if (reads != null) {
            for (Local l : reads) {
                if (l != v) continue;
                return true;
            }
        }
        return false;
    }

    private static enum StaticFieldUse {
        Unknown,
        Unused,
        Read,
        Write,
        ReadWrite;

    }
}

