/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.List;
import soot.DoubleType;
import soot.LongType;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.ValueBox;
import soot.VoidType;
import soot.baf.Baf;
import soot.baf.InterfaceInvokeInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.JimpleToBafContext;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.util.Switch;

public abstract class AbstractInterfaceInvokeExpr
extends AbstractInstanceInvokeExpr
implements InterfaceInvokeExpr,
ConvertToBaf {
    protected AbstractInterfaceInvokeExpr(ValueBox baseBox, SootMethodRef methodRef, ValueBox[] argBoxes) {
        super(methodRef, baseBox, argBoxes);
        if (methodRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractInterfaceInvokeExpr) {
            AbstractInterfaceInvokeExpr ie = (AbstractInterfaceInvokeExpr)o;
            if (!this.baseBox.getValue().equivTo(ie.baseBox.getValue()) || !this.getMethod().equals(ie.getMethod()) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            int i = 0;
            while (i < this.argBoxes.length) {
                if (!this.argBoxes[i].getValue().equivTo(ie.argBoxes[i].getValue())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.baseBox.getValue().equivHashCode() * 101 + this.getMethod().equivHashCode() * 17;
    }

    @Override
    public abstract Object clone();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("interfaceinvoke " + this.baseBox.getValue().toString() + "." + this.methodRef.getSignature() + "(");
        int i = 0;
        while (i < this.argBoxes.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("interfaceinvoke");
        up.literal(" ");
        this.baseBox.toString(up);
        up.literal(".");
        up.methodRef(this.methodRef);
        up.literal("(");
        int i = 0;
        while (i < this.argBoxes.length) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
            ++i;
        }
        up.literal(")");
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseInterfaceInvokeExpr(this);
    }

    private static int sizeOfType(Type t) {
        if (t instanceof DoubleType || t instanceof LongType) {
            return 2;
        }
        if (t instanceof VoidType) {
            return 0;
        }
        return 1;
    }

    private static int argCountOf(SootMethodRef m) {
        int argCount = 0;
        for (Type t : m.parameterTypes()) {
            argCount += AbstractInterfaceInvokeExpr.sizeOfType(t);
        }
        return argCount;
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ((ConvertToBaf)((Object)this.getBase())).convertToBaf(context, out);
        ValueBox[] valueBoxArray = this.argBoxes;
        int n = this.argBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ValueBox element = valueBoxArray[n2];
            ((ConvertToBaf)((Object)element.getValue())).convertToBaf(context, out);
            ++n2;
        }
        InterfaceInvokeInst u = Baf.v().newInterfaceInvokeInst(this.methodRef, AbstractInterfaceInvokeExpr.argCountOf(this.methodRef));
        out.add(u);
        u.addAllTagsOf(context.getCurrentUnit());
    }
}

