/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.ArrayType;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.NewMultiArrayInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.JimpleToBafContext;
import soot.jimple.NewMultiArrayExpr;
import soot.util.Switch;

public abstract class AbstractNewMultiArrayExpr
implements NewMultiArrayExpr,
ConvertToBaf {
    ArrayType baseType;
    protected final ValueBox[] sizeBoxes;

    @Override
    public abstract Object clone();

    protected AbstractNewMultiArrayExpr(ArrayType type, ValueBox[] sizeBoxes) {
        this.baseType = type;
        this.sizeBoxes = sizeBoxes;
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractNewMultiArrayExpr) {
            AbstractNewMultiArrayExpr ae = (AbstractNewMultiArrayExpr)o;
            return this.baseType.equals(ae.baseType) && this.sizeBoxes.length == ae.sizeBoxes.length;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.baseType.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Type t = this.baseType.baseType;
        buffer.append("newmultiarray (" + t.toString() + ")");
        ValueBox[] valueBoxArray = this.sizeBoxes;
        int n = this.sizeBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ValueBox element = valueBoxArray[n2];
            buffer.append("[" + element.getValue().toString() + "]");
            ++n2;
        }
        int i = 0;
        while (i < this.baseType.numDimensions - this.sizeBoxes.length) {
            buffer.append("[]");
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        Type t = this.baseType.baseType;
        up.literal("newmultiarray");
        up.literal(" (");
        up.type(t);
        up.literal(")");
        ValueBox[] valueBoxArray = this.sizeBoxes;
        int n = this.sizeBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ValueBox element = valueBoxArray[n2];
            up.literal("[");
            element.toString(up);
            up.literal("]");
            ++n2;
        }
        int i = 0;
        while (i < this.baseType.numDimensions - this.sizeBoxes.length) {
            up.literal("[]");
            ++i;
        }
    }

    @Override
    public ArrayType getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(ArrayType baseType) {
        this.baseType = baseType;
    }

    @Override
    public ValueBox getSizeBox(int index) {
        return this.sizeBoxes[index];
    }

    @Override
    public int getSizeCount() {
        return this.sizeBoxes.length;
    }

    @Override
    public Value getSize(int index) {
        return this.sizeBoxes[index].getValue();
    }

    @Override
    public List<Value> getSizes() {
        ArrayList<Value> toReturn = new ArrayList<Value>();
        ValueBox[] valueBoxArray = this.sizeBoxes;
        int n = this.sizeBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ValueBox element = valueBoxArray[n2];
            toReturn.add(element.getValue());
            ++n2;
        }
        return toReturn;
    }

    @Override
    public void setSize(int index, Value size) {
        this.sizeBoxes[index].setValue(size);
    }

    @Override
    public final List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        Collections.addAll(list, this.sizeBoxes);
        ValueBox[] valueBoxArray = this.sizeBoxes;
        int n = this.sizeBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ValueBox element = valueBoxArray[n2];
            list.addAll(element.getValue().getUseBoxes());
            ++n2;
        }
        return list;
    }

    @Override
    public Type getType() {
        return this.baseType;
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseNewMultiArrayExpr(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        List<Value> sizes = this.getSizes();
        int i = 0;
        while (i < sizes.size()) {
            ((ConvertToBaf)((Object)sizes.get(i))).convertToBaf(context, out);
            ++i;
        }
        NewMultiArrayInst u = Baf.v().newNewMultiArrayInst(this.getBaseType(), sizes.size());
        out.add(u);
        u.addAllTagsOf(context.getCurrentUnit());
    }
}

