/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.ValueBox;
import soot.jimple.SwitchStmt;
import soot.jimple.internal.AbstractStmt;

abstract class AbstractSwitchStmt
extends AbstractStmt
implements SwitchStmt {
    final UnitBox defaultTargetBox;
    final ValueBox keyBox;
    final List<UnitBox> stmtBoxes;
    protected final UnitBox[] targetBoxes;

    protected AbstractSwitchStmt(ValueBox keyBox, UnitBox defaultTargetBox, UnitBox ... targetBoxes) {
        this.keyBox = keyBox;
        this.defaultTargetBox = defaultTargetBox;
        this.targetBoxes = targetBoxes;
        ArrayList<UnitBox> list = new ArrayList<UnitBox>();
        this.stmtBoxes = Collections.unmodifiableList(list);
        Collections.addAll(list, targetBoxes);
        list.add(defaultTargetBox);
    }

    @Override
    public final Unit getDefaultTarget() {
        return this.defaultTargetBox.getUnit();
    }

    @Override
    public final void setDefaultTarget(Unit defaultTarget) {
        this.defaultTargetBox.setUnit(defaultTarget);
    }

    @Override
    public final UnitBox getDefaultTargetBox() {
        return this.defaultTargetBox;
    }

    @Override
    public final Value getKey() {
        return this.keyBox.getValue();
    }

    @Override
    public final void setKey(Value key) {
        this.keyBox.setValue(key);
    }

    @Override
    public final ValueBox getKeyBox() {
        return this.keyBox;
    }

    @Override
    public final List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> list = new ArrayList<ValueBox>();
        list.addAll(this.keyBox.getValue().getUseBoxes());
        list.add(this.keyBox);
        return list;
    }

    public final int getTargetCount() {
        return this.targetBoxes.length;
    }

    @Override
    public final Unit getTarget(int index) {
        return this.targetBoxes[index].getUnit();
    }

    @Override
    public final UnitBox getTargetBox(int index) {
        return this.targetBoxes[index];
    }

    @Override
    public final void setTarget(int index, Unit target) {
        this.targetBoxes[index].setUnit(target);
    }

    @Override
    public final List<Unit> getTargets() {
        ArrayList<Unit> targets = new ArrayList<Unit>();
        UnitBox[] unitBoxArray = this.targetBoxes;
        int n = this.targetBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            UnitBox element = unitBoxArray[n2];
            targets.add(element.getUnit());
            ++n2;
        }
        return targets;
    }

    public final void setTargets(List<? extends Unit> targets) {
        int i = 0;
        while (i < targets.size()) {
            this.targetBoxes[i].setUnit(targets.get(i));
            ++i;
        }
    }

    public final void setTargets(Unit[] targets) {
        int i = 0;
        while (i < targets.length) {
            this.targetBoxes[i].setUnit(targets[i]);
            ++i;
        }
    }

    @Override
    public final List<UnitBox> getUnitBoxes() {
        return this.stmtBoxes;
    }

    @Override
    public final boolean fallsThrough() {
        return false;
    }

    @Override
    public final boolean branches() {
        return true;
    }
}

