/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.List;
import soot.RefType;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.DynamicInvokeInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.ExprSwitch;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.util.Switch;

public class JDynamicInvokeExpr
extends AbstractInvokeExpr
implements DynamicInvokeExpr,
ConvertToBaf {
    protected SootMethodRef bsmRef;
    protected ValueBox[] bsmArgBoxes;
    protected int tag;

    public JDynamicInvokeExpr(SootMethodRef bootstrapMethodRef, List<? extends Value> bootstrapArgs, SootMethodRef methodRef, int tag, List<? extends Value> methodArgs) {
        super(methodRef, new ValueBox[methodArgs.size()]);
        if (!methodRef.getSignature().startsWith("<soot.dummy.InvokeDynamic: ")) {
            throw new IllegalArgumentException("Receiver type of JDynamicInvokeExpr must be soot.dummy.InvokeDynamic!");
        }
        if (!bootstrapMethodRef.returnType().equals(RefType.v("java.lang.invoke.CallSite"))) {
            throw new IllegalArgumentException("Return type of bootstrap method must be java.lang.invoke.CallSite!");
        }
        this.bsmRef = bootstrapMethodRef;
        this.bsmArgBoxes = new ValueBox[bootstrapArgs.size()];
        this.tag = tag;
        int i = 0;
        while (i < bootstrapArgs.size()) {
            this.bsmArgBoxes[i] = Jimple.v().newImmediateBox(bootstrapArgs.get(i));
            ++i;
        }
        i = 0;
        while (i < methodArgs.size()) {
            this.argBoxes[i] = Jimple.v().newImmediateBox(methodArgs.get(i));
            ++i;
        }
    }

    public JDynamicInvokeExpr(SootMethodRef bootstrapMethodRef, List<? extends Value> bootstrapArgs, SootMethodRef methodRef, List<? extends Value> methodArgs) {
        this(bootstrapMethodRef, bootstrapArgs, methodRef, 6, methodArgs);
    }

    @Override
    public int getBootstrapArgCount() {
        return this.bsmArgBoxes.length;
    }

    @Override
    public Value getBootstrapArg(int index) {
        return this.bsmArgBoxes[index].getValue();
    }

    @Override
    public Object clone() {
        ArrayList<Value> clonedBsmArgs = new ArrayList<Value>(this.getBootstrapArgCount());
        int i = 0;
        while (i < this.getBootstrapArgCount()) {
            clonedBsmArgs.add(i, this.getBootstrapArg(i));
            ++i;
        }
        ArrayList<Value> clonedArgs = new ArrayList<Value>(this.getArgCount());
        int i2 = 0;
        while (i2 < this.getArgCount()) {
            clonedArgs.add(i2, this.getArg(i2));
            ++i2;
        }
        return new JDynamicInvokeExpr(this.bsmRef, clonedBsmArgs, this.methodRef, this.tag, clonedArgs);
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof JDynamicInvokeExpr) {
            ValueBox element;
            JDynamicInvokeExpr ie = (JDynamicInvokeExpr)o;
            if (!this.getMethod().equals(ie.getMethod()) || this.bsmArgBoxes.length != ie.bsmArgBoxes.length) {
                return false;
            }
            int i = 0;
            ValueBox[] valueBoxArray = this.bsmArgBoxes;
            int n = this.bsmArgBoxes.length;
            int n2 = 0;
            while (n2 < n) {
                element = valueBoxArray[n2];
                if (!element.getValue().equivTo(ie.getBootstrapArg(i))) {
                    return false;
                }
                ++i;
                ++n2;
            }
            if (!this.getMethod().equals(ie.getMethod()) || this.argBoxes.length != ie.argBoxes.length) {
                return false;
            }
            i = 0;
            valueBoxArray = this.argBoxes;
            n = this.argBoxes.length;
            n2 = 0;
            while (n2 < n) {
                element = valueBoxArray[n2];
                if (!element.getValue().equivTo(ie.getArg(i))) {
                    return false;
                }
                ++i;
                ++n2;
            }
            if (!this.methodRef.equals(ie.methodRef)) {
                return false;
            }
            return this.bsmRef.equals(ie.bsmRef);
        }
        return false;
    }

    public SootMethod getBootstrapMethod() {
        return this.bsmRef.resolve();
    }

    @Override
    public int equivHashCode() {
        return this.getBootstrapMethod().equivHashCode() * this.getMethod().equivHashCode() * 17;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("dynamicinvoke");
        buffer.append(" \"");
        buffer.append(this.methodRef.name());
        buffer.append("\" <");
        buffer.append(SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()));
        buffer.append(">(");
        int i = 0;
        while (i < this.argBoxes.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.argBoxes[i].getValue().toString());
            ++i;
        }
        buffer.append(") ");
        buffer.append(this.bsmRef.getSignature());
        buffer.append("(");
        i = 0;
        while (i < this.bsmArgBoxes.length) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.bsmArgBoxes[i].getValue().toString());
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("dynamicinvoke");
        up.literal(" \"" + this.methodRef.name() + "\" <" + SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()) + ">(");
        int i = 0;
        while (i < this.argBoxes.length) {
            if (i != 0) {
                up.literal(", ");
            }
            this.argBoxes[i].toString(up);
            ++i;
        }
        up.literal(") ");
        up.methodRef(this.bsmRef);
        up.literal("(");
        i = 0;
        while (i < this.bsmArgBoxes.length) {
            if (i != 0) {
                up.literal(", ");
            }
            this.bsmArgBoxes[i].toString(up);
            ++i;
        }
        up.literal(")");
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseDynamicInvokeExpr(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ValueBox[] valueBoxArray = this.argBoxes;
        int n = this.argBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ValueBox element = valueBoxArray[n2];
            ((ConvertToBaf)((Object)element.getValue())).convertToBaf(context, out);
            ++n2;
        }
        ArrayList<Value> bsmArgs = new ArrayList<Value>();
        ValueBox[] valueBoxArray2 = this.bsmArgBoxes;
        int n3 = this.bsmArgBoxes.length;
        n = 0;
        while (n < n3) {
            ValueBox argBox = valueBoxArray2[n];
            bsmArgs.add(argBox.getValue());
            ++n;
        }
        DynamicInvokeInst u = Baf.v().newDynamicInvokeInst(this.bsmRef, bsmArgs, this.methodRef, this.tag);
        u.addAllTagsOf(context.getCurrentUnit());
        out.add(u);
    }

    @Override
    public SootMethodRef getBootstrapMethodRef() {
        return this.bsmRef;
    }

    @Override
    public List<Value> getBootstrapArgs() {
        ArrayList<Value> l = new ArrayList<Value>();
        ValueBox[] valueBoxArray = this.bsmArgBoxes;
        int n = this.bsmArgBoxes.length;
        int n2 = 0;
        while (n2 < n) {
            ValueBox element = valueBoxArray[n2];
            l.add(element.getValue());
            ++n2;
        }
        return l;
    }

    @Override
    public int getHandleTag() {
        return this.tag;
    }
}

