/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.LookupSwitchInst;
import soot.baf.PlaceholderInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.StmtSwitch;
import soot.jimple.internal.AbstractSwitchStmt;
import soot.util.Switch;

public class JLookupSwitchStmt
extends AbstractSwitchStmt
implements LookupSwitchStmt {
    List<IntConstant> lookupValues;

    private static UnitBox[] getTargetBoxesArray(List<? extends Unit> targets) {
        UnitBox[] targetBoxes = new UnitBox[targets.size()];
        int i = 0;
        while (i < targetBoxes.length) {
            targetBoxes[i] = Jimple.v().newStmtBox(targets.get(i));
            ++i;
        }
        return targetBoxes;
    }

    @Override
    public Object clone() {
        int lookupValueCount = this.lookupValues.size();
        ArrayList<IntConstant> clonedLookupValues = new ArrayList<IntConstant>(lookupValueCount);
        int i = 0;
        while (i < lookupValueCount) {
            clonedLookupValues.add(i, IntConstant.v(this.getLookupValue(i)));
            ++i;
        }
        return new JLookupSwitchStmt(this.getKey(), clonedLookupValues, this.getTargets(), this.getDefaultTarget());
    }

    public JLookupSwitchStmt(Value key, List<IntConstant> lookupValues, List<? extends Unit> targets, Unit defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lookupValues, JLookupSwitchStmt.getTargetBoxesArray(targets), Jimple.v().newStmtBox(defaultTarget));
    }

    public JLookupSwitchStmt(Value key, List<IntConstant> lookupValues, List<? extends UnitBox> targets, UnitBox defaultTarget) {
        this(Jimple.v().newImmediateBox(key), lookupValues, targets.toArray(new UnitBox[targets.size()]), defaultTarget);
    }

    protected JLookupSwitchStmt(ValueBox keyBox, List<IntConstant> lookupValues, UnitBox[] targetBoxes, UnitBox defaultTargetBox) {
        super(keyBox, defaultTargetBox, targetBoxes);
        this.setLookupValues(lookupValues);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String endOfLine = " ";
        buffer.append("lookupswitch(" + this.keyBox.getValue().toString() + ")" + endOfLine);
        buffer.append("{" + endOfLine);
        int i = 0;
        while (i < this.lookupValues.size()) {
            buffer.append("    case " + this.lookupValues.get(i) + ": " + "goto" + " " + this.getTarget(i) + ";" + endOfLine);
            ++i;
        }
        buffer.append("    default: goto " + this.getDefaultTarget() + ";" + endOfLine);
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("lookupswitch");
        up.literal("(");
        this.keyBox.toString(up);
        up.literal(")");
        up.newline();
        up.literal("{");
        up.newline();
        int i = 0;
        while (i < this.lookupValues.size()) {
            up.literal("    ");
            up.literal("case");
            up.literal(" ");
            up.constant(this.lookupValues.get(i));
            up.literal(": ");
            up.literal("goto");
            up.literal(" ");
            this.targetBoxes[i].toString(up);
            up.literal(";");
            up.newline();
            ++i;
        }
        up.literal("    ");
        up.literal("default");
        up.literal(": ");
        up.literal("goto");
        up.literal(" ");
        this.defaultTargetBox.toString(up);
        up.literal(";");
        up.newline();
        up.literal("}");
    }

    @Override
    public void setLookupValues(List<IntConstant> lookupValues) {
        this.lookupValues = new ArrayList<IntConstant>(lookupValues);
    }

    @Override
    public void setLookupValue(int index, int value) {
        this.lookupValues.set(index, IntConstant.v(value));
    }

    @Override
    public int getLookupValue(int index) {
        return this.lookupValues.get((int)index).value;
    }

    @Override
    public List<IntConstant> getLookupValues() {
        return Collections.unmodifiableList(this.lookupValues);
    }

    @Override
    public void apply(Switch sw) {
        ((StmtSwitch)sw).caseLookupSwitchStmt(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ArrayList<PlaceholderInst> targetPlaceholders = new ArrayList<PlaceholderInst>();
        ((ConvertToBaf)((Object)this.getKey())).convertToBaf(context, out);
        for (Unit target : this.getTargets()) {
            targetPlaceholders.add(Baf.v().newPlaceholderInst(target));
        }
        LookupSwitchInst u = Baf.v().newLookupSwitchInst(Baf.v().newPlaceholderInst(this.getDefaultTarget()), this.getLookupValues(), targetPlaceholders);
        u.addAllTagsOf(this);
        out.add(u);
    }
}

