/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.geomPA;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import soot.Local;
import soot.PointsToSet;
import soot.SootMethod;
import soot.jimple.spark.geom.dataMgr.ContextsCollector;
import soot.jimple.spark.geom.dataMgr.Obj_full_extractor;
import soot.jimple.spark.geom.dataMgr.PtSensVisitor;
import soot.jimple.spark.geom.dataRep.CgEdge;
import soot.jimple.spark.geom.dataRep.IntervalContextVar;
import soot.jimple.spark.geom.dataRep.SimpleInterval;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.geomPA.Parameters;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.toolkits.callgraph.Edge;

public class GeomQueries {
    protected GeomPointsTo geomPts = null;
    protected int n_func;
    protected CgEdge[] call_graph;
    protected int[] vis_cg;
    protected int[] rep_cg;
    protected int[] top_rank;
    protected int[] block_num;
    protected long[] max_context_size_block;
    private boolean prop_initialized = false;
    protected Queue<Integer> topQ;
    protected int[] in_degree;
    protected ContextsCollector[] contextsForMethods;

    public GeomQueries(GeomPointsTo geom_pts) {
        this.geomPts = geom_pts;
        this.n_func = this.geomPts.n_func;
        this.vis_cg = this.geomPts.vis_cg;
        this.rep_cg = this.geomPts.rep_cg;
        this.block_num = this.geomPts.block_num;
        this.max_context_size_block = this.geomPts.max_context_size_block;
        this.call_graph = new CgEdge[this.n_func];
        Arrays.fill(this.call_graph, null);
        this.in_degree = new int[this.n_func];
        Arrays.fill(this.in_degree, 0);
        CgEdge[] raw_call_graph = this.geomPts.call_graph;
        int i = 0;
        while (i < this.n_func) {
            if (this.vis_cg[i] != 0) {
                CgEdge p = raw_call_graph[i];
                int rep = this.rep_cg[i];
                while (p != null) {
                    if (!p.scc_edge) {
                        CgEdge q = p.duplicate();
                        q.next = this.call_graph[rep];
                        this.call_graph[rep] = q;
                        int n = this.rep_cg[q.t];
                        this.in_degree[n] = this.in_degree[n] + 1;
                    }
                    p = p.next;
                }
            }
            ++i;
        }
    }

    private void prepareIntervalPropagations() {
        if (this.prop_initialized) {
            return;
        }
        this.top_rank = new int[this.n_func];
        Arrays.fill(this.top_rank, 0);
        this.topQ = new LinkedList<Integer>();
        this.topQ.add(0);
        while (!this.topQ.isEmpty()) {
            int s = this.topQ.poll();
            CgEdge p = this.call_graph[s];
            while (p != null) {
                int t = p.t;
                int rep_t = this.rep_cg[t];
                int w = this.top_rank[s] + 1;
                if (this.top_rank[rep_t] < w) {
                    this.top_rank[rep_t] = w;
                }
                int n = rep_t;
                this.in_degree[n] = this.in_degree[n] - 1;
                if (this.in_degree[n] == 0) {
                    this.topQ.add(rep_t);
                }
                p = p.next;
            }
        }
        this.contextsForMethods = new ContextsCollector[this.n_func];
        int i = 0;
        while (i < this.n_func) {
            ContextsCollector cc = new ContextsCollector();
            cc.setBudget(Parameters.qryBudgetSize);
            this.contextsForMethods[i] = cc;
            ++i;
        }
        this.prop_initialized = true;
    }

    protected boolean dfsScanSubgraph(int s, int target) {
        int rep_s = this.rep_cg[s];
        int rep_target = this.rep_cg[target];
        if (rep_s == rep_target) {
            return true;
        }
        s = rep_s;
        boolean reachable = false;
        CgEdge p = this.call_graph[s];
        while (p != null) {
            int t = p.t;
            int rep_t = this.rep_cg[t];
            if (this.in_degree[rep_t] != 0 || this.top_rank[rep_t] <= this.top_rank[rep_target] && this.dfsScanSubgraph(t, target)) {
                int n = rep_t;
                this.in_degree[n] = this.in_degree[n] + 1;
                reachable = true;
            }
            p = p.next;
        }
        return reachable;
    }

    protected void transferInSCC(int s, int t, long L, long R2, ContextsCollector tContexts) {
        if (s == t) {
            tContexts.insert(L, R2);
            return;
        }
        int n_blocks = this.block_num[t];
        long block_size = this.max_context_size_block[this.rep_cg[s]];
        long offset = (L - 1L) % block_size;
        long ctxtLength = R2 - L;
        long block_offset = 0L;
        int i = 0;
        while (i < n_blocks) {
            long lEnd = 1L + offset + block_offset;
            long rEnd = lEnd + ctxtLength;
            tContexts.insert(lEnd, rEnd);
            block_offset += block_size;
            ++i;
        }
    }

    protected boolean propagateIntervals(int start, long L, long R2, int target) {
        if (!this.dfsScanSubgraph(start, target)) {
            return false;
        }
        int rep_start = this.rep_cg[start];
        int rep_target = this.rep_cg[target];
        ContextsCollector targetContexts = this.contextsForMethods[target];
        if (rep_start == rep_target) {
            this.transferInSCC(start, target, L, R2, targetContexts);
        } else {
            this.transferInSCC(start, rep_start, L, R2, this.contextsForMethods[rep_start]);
            this.topQ.clear();
            this.topQ.add(rep_start);
            while (!this.topQ.isEmpty()) {
                int s = this.topQ.poll();
                ContextsCollector sContexts = this.contextsForMethods[s];
                CgEdge p = this.call_graph[s];
                while (p != null) {
                    int t = p.t;
                    int rep_t = this.rep_cg[t];
                    if (this.in_degree[rep_t] != 0) {
                        ContextsCollector reptContexts = this.contextsForMethods[rep_t];
                        long block_size = this.max_context_size_block[s];
                        for (SimpleInterval si : sContexts.bars) {
                            long in_block_offset = (si.L - 1L) % block_size;
                            long newL = p.map_offset + in_block_offset;
                            long newR = si.R - si.L + newL;
                            if (rep_t == rep_target) {
                                this.transferInSCC(t, target, newL, newR, targetContexts);
                                continue;
                            }
                            this.transferInSCC(t, rep_t, newL, newR, reptContexts);
                        }
                        int n = rep_t;
                        this.in_degree[n] = this.in_degree[n] - 1;
                        if (this.in_degree[n] == 0 && rep_t != rep_target) {
                            this.topQ.add(rep_t);
                        }
                    }
                    p = p.next;
                }
                sContexts.clear();
            }
        }
        return true;
    }

    public boolean contexsByAnyCallEdge(Edge sootEdge, Local l, PtSensVisitor visitor) {
        CgEdge ctxt = this.geomPts.getInternalEdgeFromSootEdge(sootEdge);
        if (ctxt == null || ctxt.is_obsoleted) {
            return false;
        }
        LocalVarNode vn = this.geomPts.findLocalVarNode(l);
        if (vn == null) {
            return false;
        }
        IVarAbstraction pn = this.geomPts.findInternalNode(vn);
        if (pn == null) {
            return false;
        }
        if (!(pn = pn.getRepresentative()).hasPTResult()) {
            return false;
        }
        SootMethod sm = vn.getMethod();
        int target = this.geomPts.getIDFromSootMethod(sm);
        if (target == -1) {
            return false;
        }
        long L = ctxt.map_offset;
        long R2 = L + this.max_context_size_block[this.rep_cg[ctxt.s]];
        assert (L < R2);
        visitor.prepare();
        this.prepareIntervalPropagations();
        if (this.propagateIntervals(ctxt.t, L, R2, target)) {
            ContextsCollector targetContexts = this.contextsForMethods[target];
            for (SimpleInterval si : targetContexts.bars) {
                assert (si.L < si.R);
                pn.get_all_context_sensitive_objects(si.L, si.R, visitor);
            }
            targetContexts.clear();
        }
        visitor.finish();
        return visitor.numOfDiffObjects() != 0;
    }

    public boolean contextsByAnyCallEdge(Edge sootEdge, Local l, SparkField field, PtSensVisitor visitor) {
        Obj_full_extractor pts_l = new Obj_full_extractor();
        if (!this.contexsByAnyCallEdge(sootEdge, l, pts_l)) {
            return false;
        }
        visitor.prepare();
        for (IntervalContextVar icv : pts_l.outList) {
            IVarAbstraction objField;
            AllocNode obj = (AllocNode)icv.var;
            AllocDotField obj_f = this.geomPts.findAllocDotField(obj, field);
            if (obj_f == null || (objField = this.geomPts.findInternalNode(obj_f)) == null) continue;
            long L = icv.L;
            long R2 = icv.R;
            assert (L < R2);
            objField.get_all_context_sensitive_objects(L, R2, visitor);
        }
        pts_l = null;
        visitor.finish();
        return visitor.numOfDiffObjects() != 0;
    }

    public boolean contextsByCallChain(Edge[] callEdgeChain, Local l, PtSensVisitor visitor) {
        SootMethod firstMethod = callEdgeChain[0].src();
        int firstMethodID = this.geomPts.getIDFromSootMethod(firstMethod);
        if (firstMethodID == -1) {
            return false;
        }
        LocalVarNode vn = this.geomPts.findLocalVarNode(l);
        if (vn == null) {
            return false;
        }
        IVarAbstraction pn = this.geomPts.findInternalNode(vn);
        if (pn == null) {
            return false;
        }
        if (!(pn = pn.getRepresentative()).hasPTResult()) {
            return false;
        }
        SootMethod sm = vn.getMethod();
        if (this.geomPts.getIDFromSootMethod(sm) == -1) {
            return false;
        }
        visitor.prepare();
        long L = 1L;
        int i = 0;
        while (i < callEdgeChain.length) {
            Edge sootEdge = callEdgeChain[i];
            CgEdge ctxt = this.geomPts.getInternalEdgeFromSootEdge(sootEdge);
            if (ctxt == null || ctxt.is_obsoleted) {
                return false;
            }
            int caller = this.geomPts.getIDFromSootMethod(sootEdge.src());
            long block_size = this.max_context_size_block[this.rep_cg[caller]];
            long in_block_offset = (L - 1L) % block_size;
            L = ctxt.map_offset + in_block_offset;
            ++i;
        }
        long ctxtLength = this.max_context_size_block[this.rep_cg[firstMethodID]];
        long R2 = L + ctxtLength;
        pn.get_all_context_sensitive_objects(L, R2, visitor);
        visitor.finish();
        return visitor.numOfDiffObjects() != 0;
    }

    public boolean contextByCallChain(Edge[] callEdgeChain, Local l, SparkField field, PtSensVisitor visitor) {
        Obj_full_extractor pts_l = new Obj_full_extractor();
        if (!this.contextsByCallChain(callEdgeChain, l, pts_l)) {
            return false;
        }
        visitor.prepare();
        for (IntervalContextVar icv : pts_l.outList) {
            IVarAbstraction objField;
            AllocNode obj = (AllocNode)icv.var;
            AllocDotField obj_f = this.geomPts.findAllocDotField(obj, field);
            if (obj_f == null || (objField = this.geomPts.findInternalNode(obj_f)) == null) continue;
            long L = icv.L;
            long R2 = icv.R;
            assert (L < R2);
            objField.get_all_context_sensitive_objects(L, R2, visitor);
        }
        pts_l = null;
        visitor.finish();
        return visitor.numOfDiffObjects() != 0;
    }

    public boolean isAliasCI(Local l1, Local l2) {
        PointsToSet pts1 = this.geomPts.reachingObjects(l1);
        PointsToSet pts2 = this.geomPts.reachingObjects(l2);
        return pts1.hasNonEmptyIntersection(pts2);
    }

    public boolean isAlias(IVarAbstraction pn1, IVarAbstraction pn2) {
        pn1 = pn1.getRepresentative();
        pn2 = pn2.getRepresentative();
        if (!pn1.hasPTResult() || !pn2.hasPTResult()) {
            VarNode vn1 = (VarNode)pn1.getWrappedNode();
            VarNode vn2 = (VarNode)pn2.getWrappedNode();
            return this.isAliasCI((Local)vn1.getVariable(), (Local)vn2.getVariable());
        }
        return pn1.heap_sensitive_intersection(pn2);
    }

    public boolean isAlias(Local l1, Local l2) {
        LocalVarNode vn1 = this.geomPts.findLocalVarNode(l1);
        LocalVarNode vn2 = this.geomPts.findLocalVarNode(l2);
        if (vn1 == null || vn2 == null) {
            return false;
        }
        IVarAbstraction pn1 = this.geomPts.findInternalNode(vn1);
        IVarAbstraction pn2 = this.geomPts.findInternalNode(vn2);
        if (pn1 == null || pn2 == null) {
            return this.isAliasCI(l1, l2);
        }
        pn1 = pn1.getRepresentative();
        pn2 = pn2.getRepresentative();
        if (!pn1.hasPTResult() || !pn2.hasPTResult()) {
            return this.isAliasCI(l1, l2);
        }
        return pn1.heap_sensitive_intersection(pn2);
    }
}

