/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.geom.ptinsE;

import soot.jimple.spark.geom.dataRep.CgEdge;
import soot.jimple.spark.geom.dataRep.PlainConstraint;
import soot.jimple.spark.geom.geomPA.DummyNode;
import soot.jimple.spark.geom.geomPA.GeomPointsTo;
import soot.jimple.spark.geom.geomPA.IEncodingBroker;
import soot.jimple.spark.geom.geomPA.IVarAbstraction;
import soot.jimple.spark.geom.heapinsE.HeapInsNode;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.toolkits.callgraph.Edge;

public class PtInsNodeGenerator
extends IEncodingBroker {
    private static final int[] full_convertor;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 1;
        full_convertor = nArray;
    }

    @Override
    public void initFlowGraph(GeomPointsTo ptAnalyzer) {
        int n_legal_cons = 0;
        for (PlainConstraint cons : ptAnalyzer.constraints) {
            if (!cons.isActive) continue;
            IVarAbstraction my_lhs = cons.getLHS().getRepresentative();
            IVarAbstraction my_rhs = cons.getRHS().getRepresentative();
            int nf1 = ptAnalyzer.getMappedMethodID(my_lhs);
            int nf2 = ptAnalyzer.getMappedMethodID(my_rhs);
            int code = (nf1 == 0 ? 1 : 0) << 1 | (nf2 == 0 ? 1 : 0);
            switch (cons.type) {
                case 0: {
                    my_rhs.add_points_to_3((AllocNode)my_lhs.getWrappedNode(), nf2 == 0 ? 0 : 1, nf1 == 0 ? 0 : 1, nf2 == 0 ? ptAnalyzer.context_size[nf1] : ptAnalyzer.context_size[nf2]);
                    ptAnalyzer.getWorklist().push(my_rhs);
                    break;
                }
                case 1: {
                    if (cons.interCallEdges != null) {
                        for (Edge sEdge : cons.interCallEdges) {
                            int k;
                            CgEdge q = ptAnalyzer.getInternalEdgeFromSootEdge(sEdge);
                            if (q.is_obsoleted) continue;
                            if (nf2 == q.t) {
                                if (nf1 == 0) {
                                    my_lhs.add_simple_constraint_3(my_rhs, 0L, q.map_offset, ptAnalyzer.max_context_size_block[q.s]);
                                    continue;
                                }
                                if (q.s == q.t) {
                                    my_lhs.add_simple_constraint_3(my_rhs, 1L, 1L, ptAnalyzer.context_size[nf1]);
                                    continue;
                                }
                                k = 0;
                                while (k < ptAnalyzer.block_num[nf1]) {
                                    my_lhs.add_simple_constraint_3(my_rhs, (long)k * ptAnalyzer.max_context_size_block[nf1] + 1L, q.map_offset, ptAnalyzer.max_context_size_block[nf1]);
                                    ++k;
                                }
                                continue;
                            }
                            if (q.s == q.t) {
                                my_lhs.add_simple_constraint_3(my_rhs, 1L, 1L, ptAnalyzer.context_size[nf2]);
                                continue;
                            }
                            k = 0;
                            while (k < ptAnalyzer.block_num[nf2]) {
                                my_lhs.add_simple_constraint_3(my_rhs, q.map_offset, (long)k * ptAnalyzer.max_context_size_block[nf2] + 1L, ptAnalyzer.max_context_size_block[nf2]);
                                ++k;
                            }
                        }
                        break;
                    }
                    my_lhs.add_simple_constraint_3(my_rhs, nf1 == 0 ? 0 : 1, nf2 == 0 ? 0 : 1, nf1 == 0 ? ptAnalyzer.context_size[nf2] : ptAnalyzer.context_size[nf1]);
                    break;
                }
                case 2: {
                    cons.code = full_convertor[code];
                    cons.otherSide = my_rhs;
                    my_lhs.put_complex_constraint(cons);
                    break;
                }
                case 3: {
                    cons.code = full_convertor[code];
                    cons.otherSide = my_lhs;
                    my_rhs.put_complex_constraint(cons);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid node type");
                }
            }
            ++n_legal_cons;
        }
        ptAnalyzer.ps.printf("Only %d (%.1f%%) constraints are needed for this run.\n", n_legal_cons, (double)n_legal_cons / (double)ptAnalyzer.n_init_constraints * 100.0);
    }

    @Override
    public IVarAbstraction generateNode(Node vNode) {
        IVarAbstraction ret = vNode instanceof AllocNode || vNode instanceof FieldRefNode ? new DummyNode(vNode) : new HeapInsNode(vNode);
        return ret;
    }

    @Override
    public String getSignature() {
        return "PtIns";
    }
}

