/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import soot.SootMethod;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class PAG2HTML {
    protected PAG pag;
    protected String output_dir;
    protected MultiMap mergedNodes = new HashMultiMap();
    protected MultiMap methodToNodes = new HashMultiMap();

    public PAG2HTML(PAG pag, String output_dir) {
        this.pag = pag;
        this.output_dir = output_dir;
    }

    public void dump() {
        for (VarNode v : this.pag.getVarNodeNumberer()) {
            SootMethod m;
            this.mergedNodes.put(v.getReplacement(), v);
            if (!(v instanceof LocalVarNode) || (m = ((LocalVarNode)v).getMethod()) == null) continue;
            this.methodToNodes.put(m, v);
        }
        try {
            JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(new File(this.output_dir, "pag.jar")));
            for (VarNode v : this.mergedNodes.keySet()) {
                this.dumpVarNode(v, jarOut);
            }
            for (SootMethod m : this.methodToNodes.keySet()) {
                this.dumpMethod(m, jarOut);
            }
            this.addSymLinks(this.pag.getVarNodeNumberer().iterator(), jarOut);
            jarOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump html" + e);
        }
    }

    protected void dumpVarNode(VarNode v, JarOutputStream jarOut) throws IOException {
        VarNode succ;
        Node element;
        Node[] succs;
        jarOut.putNextEntry(new ZipEntry("nodes/n" + v.getNumber() + ".html"));
        final PrintWriter out = new PrintWriter(jarOut);
        out.println("<html>");
        out.println("Green node for:");
        out.println(this.varNodeReps(v));
        out.println("Declared type: " + v.getType());
        out.println("<hr>Reaching blue nodes:");
        out.println("<ul>");
        v.getP2Set().forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                out.println("<li>" + PAG2HTML.htmlify(n.toString()));
            }
        });
        out.println("</ul>");
        out.println("<hr>Outgoing edges:");
        Node[] nodeArray = succs = this.pag.simpleLookup(v);
        int n = succs.length;
        int n2 = 0;
        while (n2 < n) {
            element = nodeArray[n2];
            succ = (VarNode)element;
            out.println(this.varNodeReps(succ));
            ++n2;
        }
        out.println("<hr>Incoming edges: ");
        nodeArray = succs = this.pag.simpleInvLookup(v);
        n = succs.length;
        n2 = 0;
        while (n2 < n) {
            element = nodeArray[n2];
            succ = (VarNode)element;
            out.println(this.varNodeReps(succ));
            ++n2;
        }
        out.println("</html>");
        out.flush();
    }

    protected String varNodeReps(VarNode v) {
        StringBuffer ret = new StringBuffer();
        ret.append("<ul>\n");
        for (VarNode vv : this.mergedNodes.get(v)) {
            ret.append(this.varNode("", vv));
        }
        ret.append("</ul>\n");
        return ret.toString();
    }

    protected String varNode(String dirPrefix, VarNode vv) {
        LocalVarNode lvn;
        SootMethod m;
        StringBuffer ret = new StringBuffer();
        ret.append("<li><a href=\"" + dirPrefix + "n" + vv.getNumber() + ".html\">");
        if (vv.getVariable() != null) {
            ret.append(PAG2HTML.htmlify(vv.getVariable().toString()));
        }
        ret.append("GlobalVarNode");
        ret.append("</a><br>");
        ret.append("<li>Context: ");
        ret.append(vv.context() == null ? "null" : PAG2HTML.htmlify(vv.context().toString()));
        ret.append("</a><br>");
        if (vv instanceof LocalVarNode && (m = (lvn = (LocalVarNode)vv).getMethod()) != null) {
            ret.append("<a href=\"../" + this.toFileName(m.toString()) + ".html\">");
            ret.append(String.valueOf(PAG2HTML.htmlify(m.toString())) + "</a><br>");
        }
        ret.append(String.valueOf(PAG2HTML.htmlify(vv.getType().toString())) + "\n");
        return ret.toString();
    }

    protected static String htmlify(String s) {
        StringBuffer b = new StringBuffer(s);
        int i = 0;
        while (i < b.length()) {
            if (b.charAt(i) == '<') {
                b.replace(i, i + 1, "&lt;");
            }
            if (b.charAt(i) == '>') {
                b.replace(i, i + 1, "&gt;");
            }
            ++i;
        }
        return b.toString();
    }

    protected void dumpMethod(SootMethod m, JarOutputStream jarOut) throws IOException {
        jarOut.putNextEntry(new ZipEntry(this.toFileName(m.toString()) + ".html"));
        PrintWriter out = new PrintWriter(jarOut);
        out.println("<html>");
        out.println("This is method " + PAG2HTML.htmlify(m.toString()) + "<hr>");
        Iterator it = this.methodToNodes.get(m).iterator();
        while (it.hasNext()) {
            out.println(this.varNode("nodes/", (VarNode)it.next()));
        }
        out.println("</html>");
        out.flush();
    }

    protected void addSymLinks(Iterator nodes, JarOutputStream jarOut) throws IOException {
        jarOut.putNextEntry(new ZipEntry("symlinks.sh"));
        PrintWriter out = new PrintWriter(jarOut);
        out.println("#!/bin/sh");
        while (nodes.hasNext()) {
            VarNode rep;
            VarNode v = (VarNode)nodes.next();
            if (v == (rep = (VarNode)v.getReplacement())) continue;
            out.println("ln -s n" + rep.getNumber() + ".html n" + v.getNumber() + ".html");
        }
        out.flush();
    }

    protected String toFileName(String s) {
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '<') {
                ret.append('{');
            } else if (c == '>') {
                ret.append('}');
            } else {
                ret.append(c);
            }
            ++i;
        }
        return ret.toString();
    }
}

