/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.ValNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.TopoSorter;

public class PAGDumper {
    protected PAG pag;
    protected String output_dir;
    protected int fieldNum = 0;
    protected HashMap<SparkField, Integer> fieldMap = new HashMap();
    protected ObjectNumberer root = new ObjectNumberer(null, 0);

    public PAGDumper(PAG pag, String output_dir) {
        this.pag = pag;
        this.output_dir = output_dir;
    }

    public void dumpPointsToSets() {
        try {
            final PrintWriter file = new PrintWriter(new FileOutputStream(new File(this.output_dir, "solution")));
            file.println("Solution:");
            for (final VarNode vn : this.pag.getVarNodeNumberer()) {
                PointsToSetInternal p2set;
                if (vn.getReplacement() != vn || (p2set = vn.getP2Set()) == null) continue;
                p2set.forall(new P2SetVisitor(){

                    @Override
                    public final void visit(Node n) {
                        try {
                            PAGDumper.this.dumpNode(vn, file);
                            file.print(" ");
                            PAGDumper.this.dumpNode(n, file);
                            file.println("");
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Couldn't dump solution." + e);
                        }
                    }
                });
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump solution." + e);
        }
    }

    public void dump() {
        try {
            ValNode n;
            Node element0;
            int n2;
            int n3;
            Node[] nodeArray;
            Node[] succs;
            PrintWriter file = new PrintWriter(new FileOutputStream(new File(this.output_dir, "pag")));
            if (this.pag.getOpts().topo_sort()) {
                new TopoSorter(this.pag, false).sort();
            }
            file.println("Allocations:");
            for (AllocNode allocNode : this.pag.allocSources()) {
                AllocNode n32 = allocNode;
                if (n32.getReplacement() != n32) continue;
                nodeArray = succs = this.pag.allocLookup(n32);
                n3 = succs.length;
                n2 = 0;
                while (n2 < n3) {
                    element0 = nodeArray[n2];
                    this.dumpNode(n32, file);
                    file.print(" ");
                    this.dumpNode(element0, file);
                    file.println("");
                    ++n2;
                }
            }
            file.println("Assignments:");
            for (Node node : this.pag.simpleSources()) {
                n = (VarNode)node;
                if (n.getReplacement() != n) continue;
                nodeArray = succs = this.pag.simpleLookup((VarNode)n);
                n3 = succs.length;
                n2 = 0;
                while (n2 < n3) {
                    element0 = nodeArray[n2];
                    this.dumpNode(n, file);
                    file.print(" ");
                    this.dumpNode(element0, file);
                    file.println("");
                    ++n2;
                }
            }
            file.println("Loads:");
            for (Node node : this.pag.loadSources()) {
                n = (FieldRefNode)node;
                nodeArray = succs = this.pag.loadLookup((FieldRefNode)n);
                n3 = succs.length;
                n2 = 0;
                while (n2 < n3) {
                    element0 = nodeArray[n2];
                    this.dumpNode(n, file);
                    file.print(" ");
                    this.dumpNode(element0, file);
                    file.println("");
                    ++n2;
                }
            }
            file.println("Stores:");
            for (Node node : this.pag.storeSources()) {
                n = (VarNode)node;
                if (n.getReplacement() != n) continue;
                nodeArray = succs = this.pag.storeLookup((VarNode)n);
                n3 = succs.length;
                n2 = 0;
                while (n2 < n3) {
                    element0 = nodeArray[n2];
                    this.dumpNode(n, file);
                    file.print(" ");
                    this.dumpNode(element0, file);
                    file.println("");
                    ++n2;
                }
            }
            if (this.pag.getOpts().dump_types()) {
                this.dumpTypes(file);
            }
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't dump PAG." + e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void dumpTypes(PrintWriter file) throws IOException {
        HashSet<Type> declaredTypes = new HashSet<Type>();
        HashSet<Type> actualTypes = new HashSet<Type>();
        HashSet<SparkField> allFields = new HashSet<SparkField>();
        for (Node node : this.pag.getVarNodeNumberer()) {
            Type type = node.getType();
            if (type == null) continue;
            declaredTypes.add(type);
        }
        for (FieldRefNode fieldRefNode : this.pag.loadSources()) {
            Node node = fieldRefNode;
            if (node.getReplacement() != node) continue;
            Type type = node.getType();
            if (type != null) {
                declaredTypes.add(type);
            }
            allFields.add(((FieldRefNode)node).getField());
        }
        for (FieldRefNode fieldRefNode : this.pag.storeInvSources()) {
            Node node = fieldRefNode;
            if (node.getReplacement() != node) continue;
            Type type = node.getType();
            if (type != null) {
                declaredTypes.add(type);
            }
            allFields.add(((FieldRefNode)node).getField());
        }
        for (AllocNode allocNode : this.pag.allocSources()) {
            Type type;
            Node node = allocNode;
            if (node.getReplacement() != node || (type = node.getType()) == null) continue;
            actualTypes.add(type);
        }
        HashMap<Type, Integer> hashMap = new HashMap<Type, Integer>();
        boolean bl = true;
        for (Type type : declaredTypes) {
            void var6_18;
            hashMap.put(type, new Integer((int)(++var6_18)));
        }
        for (Type type : actualTypes) {
            void var6_19;
            if (hashMap.containsKey(type)) continue;
            hashMap.put(type, new Integer((int)(++var6_19)));
        }
        file.println("Declared Types:");
        for (Type type : declaredTypes) {
            for (Type type2 : actualTypes) {
                if (!this.pag.getTypeManager().castNeverFails(type2, type)) continue;
                file.println(hashMap.get(type) + " " + hashMap.get(type2));
            }
        }
        file.println("Allocation Types:");
        for (AllocNode allocNode : this.pag.allocSources()) {
            Node node = allocNode;
            if (node.getReplacement() != node) continue;
            Type t3 = node.getType();
            this.dumpNode(node, file);
            if (t3 == null) {
                throw new RuntimeException("allocnode with null type");
            }
            file.println(" " + hashMap.get(t3));
        }
        file.println("Variable Types:");
        for (Node node : this.pag.getVarNodeNumberer()) {
            if (node.getReplacement() != node) continue;
            Type type = node.getType();
            this.dumpNode(node, file);
            if (type == null) {
                file.println(" 0");
                continue;
            }
            file.println(" " + hashMap.get(type));
        }
    }

    protected int fieldToNum(SparkField f) {
        Integer ret = this.fieldMap.get(f);
        if (ret == null) {
            ret = new Integer(++this.fieldNum);
            this.fieldMap.put(f, ret);
        }
        return ret;
    }

    protected void dumpNode(Node n, PrintWriter out) throws IOException {
        if (n.getReplacement() != n) {
            throw new RuntimeException("Attempt to dump collapsed node.");
        }
        if (n instanceof FieldRefNode) {
            FieldRefNode fn = (FieldRefNode)n;
            this.dumpNode(fn.getBase(), out);
            out.print(" " + this.fieldToNum(fn.getField()));
        } else if (this.pag.getOpts().class_method_var() && n instanceof VarNode) {
            VarNode vn = (VarNode)n;
            SootMethod m = null;
            if (vn instanceof LocalVarNode) {
                m = ((LocalVarNode)vn).getMethod();
            }
            SootClass c = null;
            if (m != null) {
                c = m.getDeclaringClass();
            }
            ObjectNumberer cl = this.root.findOrAdd(c);
            ObjectNumberer me = cl.findOrAdd(m);
            ObjectNumberer vr = me.findOrAdd(vn);
            out.print(cl.num + " " + me.num + " " + vr.num);
        } else if (this.pag.getOpts().topo_sort() && n instanceof VarNode) {
            out.print("" + ((VarNode)n).finishingNumber);
        } else {
            out.print("" + n.getNumber());
        }
    }

    class ObjectNumberer {
        Object o = null;
        int num = 0;
        int nextChildNum = 1;
        HashMap<Object, ObjectNumberer> children = null;

        ObjectNumberer(Object o, int num) {
            this.o = o;
            this.num = num;
        }

        ObjectNumberer findOrAdd(Object child) {
            ObjectNumberer ret;
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((ret = this.children.get(child)) == null) {
                ret = new ObjectNumberer(child, this.nextChildNum++);
                this.children.put(child, ret);
            }
            return ret;
        }
    }
}

