/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.sets;

import soot.Scene;
import soot.Type;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.sets.P2SetFactory;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.util.BitSetIterator;
import soot.util.BitVector;

public final class HybridPointsToSet
extends PointsToSetInternal {
    private Node[] nodes = new Node[16];
    private BitVector bits = null;
    private PAG pag;
    private boolean empty = true;

    public HybridPointsToSet(Type type, PAG pag) {
        super(type);
        this.pag = pag;
    }

    @Override
    public final boolean isEmpty() {
        return this.empty;
    }

    private boolean superAddAll(PointsToSetInternal other, PointsToSetInternal exclude) {
        boolean ret = super.addAll(other, exclude);
        if (ret) {
            this.empty = false;
        }
        return ret;
    }

    private boolean nativeAddAll(HybridPointsToSet other, HybridPointsToSet exclude) {
        boolean ret = false;
        TypeManager typeManager = this.pag.getTypeManager();
        if (other.bits != null) {
            this.convertToBits();
            if (exclude != null) {
                exclude.convertToBits();
            }
            BitVector mask = null;
            if (!typeManager.castNeverFails(other.getType(), this.getType())) {
                mask = typeManager.get(this.getType());
            }
            BitVector ebits = exclude == null ? null : exclude.bits;
            ret = this.bits.orAndAndNot(other.bits, mask, ebits);
        } else {
            int i = 0;
            while (i < this.nodes.length) {
                if (other.nodes[i] == null) break;
                if (exclude == null || !exclude.contains(other.nodes[i])) {
                    ret = this.add(other.nodes[i]) | ret;
                }
                ++i;
            }
        }
        if (ret) {
            this.empty = false;
        }
        return ret;
    }

    @Override
    public final boolean addAll(PointsToSetInternal other, PointsToSetInternal exclude) {
        if (other != null && !(other instanceof HybridPointsToSet)) {
            return this.superAddAll(other, exclude);
        }
        if (exclude != null && !(exclude instanceof HybridPointsToSet)) {
            return this.superAddAll(other, exclude);
        }
        return this.nativeAddAll((HybridPointsToSet)other, (HybridPointsToSet)exclude);
    }

    @Override
    public final boolean forall(P2SetVisitor v) {
        if (this.bits == null) {
            Node[] nodeArray = this.nodes;
            int n = this.nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                if (node == null) {
                    return v.getReturnValue();
                }
                v.visit(node);
                ++n2;
            }
        } else {
            BitSetIterator it = this.bits.iterator();
            while (it.hasNext()) {
                v.visit((Node)this.pag.getAllocNodeNumberer().get(it.next()));
            }
        }
        return v.getReturnValue();
    }

    @Override
    public final boolean add(Node n) {
        if (this.pag.getTypeManager().castNeverFails(n.getType(), this.type)) {
            return this.fastAdd(n);
        }
        return false;
    }

    @Override
    public final boolean contains(Node n) {
        if (this.bits == null) {
            Node[] nodeArray = this.nodes;
            int n2 = this.nodes.length;
            int n3 = 0;
            while (n3 < n2) {
                Node node = nodeArray[n3];
                if (node == n) {
                    return true;
                }
                if (node == null) break;
                ++n3;
            }
            return false;
        }
        return this.bits.get(n.getNumber());
    }

    public static P2SetFactory getFactory() {
        return new P2SetFactory(){

            @Override
            public final PointsToSetInternal newSet(Type type, PAG pag) {
                return new HybridPointsToSet(type, pag);
            }
        };
    }

    protected final boolean fastAdd(Node n) {
        boolean ret;
        if (this.bits == null) {
            int i = 0;
            while (i < this.nodes.length) {
                if (this.nodes[i] == null) {
                    this.empty = false;
                    this.nodes[i] = n;
                    return true;
                }
                if (this.nodes[i] == n) {
                    return false;
                }
                ++i;
            }
            this.convertToBits();
        }
        if (ret = this.bits.set(n.getNumber())) {
            this.empty = false;
        }
        return ret;
    }

    protected final void convertToBits() {
        if (this.bits != null) {
            return;
        }
        this.bits = new BitVector(this.pag.getAllocNodeNumberer().size());
        Node[] nodeArray = this.nodes;
        int n = this.nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node != null) {
                this.fastAdd(node);
            }
            ++n2;
        }
    }

    public static HybridPointsToSet intersection(HybridPointsToSet set1, HybridPointsToSet set2, PAG pag) {
        final HybridPointsToSet ret = new HybridPointsToSet(Scene.v().getObjectType(), pag);
        BitVector s1Bits = set1.bits;
        BitVector s2Bits = set2.bits;
        if (s1Bits == null || s2Bits == null) {
            if (s1Bits != null) {
                set2.forall(new P2SetVisitor(){

                    @Override
                    public void visit(Node n) {
                        if (HybridPointsToSet.this.contains(n)) {
                            ret.add(n);
                        }
                    }
                });
            } else {
                set1.forall(new P2SetVisitor(){

                    @Override
                    public void visit(Node n) {
                        if (HybridPointsToSet.this.contains(n)) {
                            ret.add(n);
                        }
                    }
                });
            }
        } else {
            ret.bits = BitVector.and(s1Bits, s2Bits);
            ret.empty = false;
        }
        return ret;
    }
}

