/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.sets;

import soot.Type;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.sets.P2SetFactory;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.util.BitVector;

public final class SortedArraySet
extends PointsToSetInternal {
    private Node[] nodes = null;
    private int size = 0;
    private PAG pag = null;

    public SortedArraySet(Type type, PAG pag) {
        super(type);
        this.pag = pag;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final boolean addAll(PointsToSetInternal other, PointsToSetInternal exclude) {
        boolean ret = false;
        BitVector typeMask = this.pag.getTypeManager().get(this.type);
        if (other instanceof SortedArraySet) {
            SortedArraySet o = (SortedArraySet)other;
            Node[] mya = this.nodes;
            Node[] oa = o.nodes;
            int osize = o.size;
            Node[] newa = new Node[this.size + osize];
            int myi = 0;
            int oi = 0;
            int newi = 0;
            while (true) {
                if (myi < this.size) {
                    if (oi < osize) {
                        int ohc;
                        int myhc = mya[myi].getNumber();
                        if (myhc < (ohc = oa[oi].getNumber())) {
                            newa[newi++] = mya[myi++];
                            continue;
                        }
                        if (myhc > ohc) {
                            if (!(this.type != null && typeMask != null && !typeMask.get(ohc) || exclude != null && exclude.contains(oa[oi]))) {
                                newa[newi++] = oa[oi];
                                ret = true;
                            }
                            ++oi;
                            continue;
                        }
                        newa[newi++] = mya[myi++];
                        ++oi;
                        continue;
                    }
                    newa[newi++] = mya[myi++];
                    continue;
                }
                if (oi >= osize) break;
                int ohc = oa[oi].getNumber();
                if (!(this.type != null && typeMask != null && !typeMask.get(ohc) || exclude != null && exclude.contains(oa[oi]))) {
                    newa[newi++] = oa[oi];
                    ret = true;
                }
                ++oi;
            }
            this.nodes = newa;
            this.size = newi;
            return ret;
        }
        return super.addAll(other, exclude);
    }

    @Override
    public final boolean forall(P2SetVisitor v) {
        int i = 0;
        while (i < this.size) {
            v.visit(this.nodes[i]);
            ++i;
        }
        return v.getReturnValue();
    }

    @Override
    public final boolean add(Node n) {
        if (this.pag.getTypeManager().castNeverFails(n.getType(), this.type)) {
            if (this.contains(n)) {
                return false;
            }
            int left = 0;
            int right = this.size;
            int hc = n.getNumber();
            while (left < right) {
                int mid = (left + right) / 2;
                int midhc = this.nodes[mid].getNumber();
                if (midhc < hc) {
                    left = mid + 1;
                    continue;
                }
                if (midhc <= hc) break;
                right = mid;
            }
            if (this.nodes == null) {
                this.nodes = new Node[this.size + 4];
            } else if (this.size == this.nodes.length) {
                Node[] newNodes = new Node[this.size + 4];
                System.arraycopy(this.nodes, 0, newNodes, 0, this.nodes.length);
                this.nodes = newNodes;
            }
            System.arraycopy(this.nodes, left, this.nodes, left + 1, this.size - left);
            this.nodes[left] = n;
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public final boolean contains(Node n) {
        int left = 0;
        int right = this.size;
        int hc = n.getNumber();
        while (left < right) {
            int mid = (left + right) / 2;
            int midhc = this.nodes[mid].getNumber();
            if (midhc < hc) {
                left = mid + 1;
                continue;
            }
            if (midhc > hc) {
                right = mid;
                continue;
            }
            return true;
        }
        return false;
    }

    public static final P2SetFactory getFactory() {
        return new P2SetFactory(){

            @Override
            public final PointsToSetInternal newSet(Type type, PAG pag) {
                return new SortedArraySet(type, pag);
            }
        };
    }
}

