/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import soot.FastHierarchy;
import soot.G;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;

public class Checker {
    protected PAG pag;

    public Checker(PAG pag) {
        this.pag = pag;
    }

    public void check() {
        for (AllocNode allocNode : this.pag.allocSources()) {
            this.handleAllocNode(allocNode);
        }
        for (Node node : this.pag.simpleSources()) {
            this.handleSimples((VarNode)node);
        }
        for (Node node : this.pag.loadSources()) {
            this.handleLoads((FieldRefNode)node);
        }
        for (Node node : this.pag.storeSources()) {
            this.handleStores((VarNode)node);
        }
    }

    protected void checkAll(final Node container2, PointsToSetInternal nodes, final Node upstream) {
        nodes.forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                Checker.this.checkNode(container2, n, upstream);
            }
        });
    }

    protected void checkNode(Node container2, Node n, Node upstream) {
        if (container2.getReplacement() != container2) {
            throw new RuntimeException("container " + container2 + " is illegal");
        }
        if (upstream.getReplacement() != upstream) {
            throw new RuntimeException("upstream " + upstream + " is illegal");
        }
        PointsToSetInternal p2set = container2.getP2Set();
        FastHierarchy fh = this.pag.getTypeManager().getFastHierarchy();
        if (!p2set.contains(n) && (fh == null || container2.getType() == null || fh.canStoreType(n.getType(), container2.getType()))) {
            G.v().out.println("Check failure: " + container2 + " does not have " + n + "; upstream is " + upstream);
        }
    }

    protected void handleAllocNode(AllocNode src) {
        Node[] targets;
        Node[] nodeArray = targets = this.pag.allocLookup(src);
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            Node element = nodeArray[n2];
            this.checkNode(element, src, src);
            ++n2;
        }
    }

    protected void handleSimples(VarNode src) {
        Node[] simpleTargets;
        PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return;
        }
        Node[] nodeArray = simpleTargets = this.pag.simpleLookup(src);
        int n = simpleTargets.length;
        int n2 = 0;
        while (n2 < n) {
            Node element = nodeArray[n2];
            this.checkAll(element, srcSet, src);
            ++n2;
        }
    }

    protected void handleStores(final VarNode src) {
        Node[] storeTargets;
        final PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return;
        }
        Node[] nodeArray = storeTargets = this.pag.storeLookup(src);
        int n = storeTargets.length;
        int n2 = 0;
        while (n2 < n) {
            Node element = nodeArray[n2];
            FieldRefNode fr = (FieldRefNode)element;
            final SparkField f = fr.getField();
            fr.getBase().getP2Set().forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = Checker.this.pag.makeAllocDotField((AllocNode)n, f);
                    Checker.this.checkAll(nDotF, srcSet, src);
                }
            });
            ++n2;
        }
    }

    protected void handleLoads(final FieldRefNode src) {
        final Node[] loadTargets = this.pag.loadLookup(src);
        final SparkField f = src.getField();
        src.getBase().getP2Set().forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                AllocDotField nDotF = ((AllocNode)n).dot(f);
                if (nDotF == null) {
                    return;
                }
                PointsToSetInternal set = nDotF.getP2Set();
                if (set.isEmpty()) {
                    return;
                }
                Node[] nodeArray = loadTargets;
                int n2 = loadTargets.length;
                int n3 = 0;
                while (n3 < n2) {
                    Node element = nodeArray[n3];
                    VarNode target = (VarNode)element;
                    Checker.this.checkAll(target, set, src);
                    ++n3;
                }
            }
        });
    }
}

