/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import soot.G;
import soot.Type;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;

public class EBBCollapser {
    protected int numCollapsed = 0;
    protected PAG pag;

    public void collapse() {
        boolean verbose = this.pag.getOpts().verbose();
        if (verbose) {
            G.v().out.println("Total VarNodes: " + this.pag.getVarNodeNumberer().size() + ". Collapsing EBBs...");
        }
        this.collapseAlloc();
        this.collapseLoad();
        this.collapseSimple();
        if (verbose) {
            G.v().out.println(this.numCollapsed + " nodes were collapsed.");
        }
    }

    public EBBCollapser(PAG pag) {
        this.pag = pag;
    }

    protected void collapseAlloc() {
        boolean ofcg = this.pag.getOnFlyCallGraph() != null;
        Iterator<AllocNode> iterator = this.pag.allocSources().iterator();
        while (iterator.hasNext()) {
            AllocNode object;
            AllocNode n = object = iterator.next();
            Node[] succs = this.pag.allocLookup(n);
            VarNode firstSucc = null;
            Node[] nodeArray = succs;
            int n2 = succs.length;
            int n3 = 0;
            while (n3 < n2) {
                Node element0 = nodeArray[n3];
                VarNode succ = (VarNode)element0;
                if (!(this.pag.allocInvLookup(succ).length > 1 || this.pag.loadInvLookup(succ).length > 0 || this.pag.simpleInvLookup(succ).length > 0 || ofcg && succ.isInterProcTarget())) {
                    if (firstSucc == null) {
                        firstSucc = succ;
                    } else if (firstSucc.getType().equals(succ.getType())) {
                        firstSucc.mergeWith(succ);
                        ++this.numCollapsed;
                    }
                }
                ++n3;
            }
        }
    }

    protected void collapseSimple() {
        boolean change;
        boolean ofcg = this.pag.getOnFlyCallGraph() != null;
        TypeManager typeManager = this.pag.getTypeManager();
        do {
            change = false;
            for (VarNode n : new ArrayList<VarNode>(this.pag.simpleSources())) {
                Node[] succs;
                Type nType = n.getType();
                Node[] nodeArray = succs = this.pag.simpleLookup(n);
                int n2 = succs.length;
                int n3 = 0;
                while (n3 < n2) {
                    Node element = nodeArray[n3];
                    VarNode succ = (VarNode)element;
                    Type sType = succ.getType();
                    if (typeManager.castNeverFails(nType, sType) && this.pag.allocInvLookup(succ).length <= 0 && this.pag.loadInvLookup(succ).length <= 0 && this.pag.simpleInvLookup(succ).length <= 1 && (!ofcg || !succ.isInterProcTarget() && !n.isInterProcSource())) {
                        n.mergeWith(succ);
                        change = true;
                        ++this.numCollapsed;
                    }
                    ++n3;
                }
            }
        } while (change);
    }

    protected void collapseLoad() {
        boolean ofcg = this.pag.getOnFlyCallGraph() != null;
        TypeManager typeManager = this.pag.getTypeManager();
        for (FieldRefNode n : new ArrayList<FieldRefNode>(this.pag.loadSources())) {
            Type nType = n.getType();
            Node[] succs = this.pag.loadLookup(n);
            VarNode firstSucc = null;
            HashMap<Type, VarNode> typeToSucc = new HashMap<Type, VarNode>();
            Node[] nodeArray = succs;
            int n2 = succs.length;
            int n3 = 0;
            while (n3 < n2) {
                Node element = nodeArray[n3];
                VarNode succ = (VarNode)element;
                Type sType = succ.getType();
                if (!(this.pag.allocInvLookup(succ).length > 0 || this.pag.loadInvLookup(succ).length > 1 || this.pag.simpleInvLookup(succ).length > 0 || ofcg && succ.isInterProcTarget())) {
                    if (typeManager.castNeverFails(nType, sType)) {
                        if (firstSucc == null) {
                            firstSucc = succ;
                        } else {
                            firstSucc.mergeWith(succ);
                            ++this.numCollapsed;
                        }
                    } else {
                        VarNode rep = (VarNode)typeToSucc.get(succ.getType());
                        if (rep == null) {
                            typeToSucc.put(succ.getType(), succ);
                        } else {
                            rep.mergeWith(succ);
                            ++this.numCollapsed;
                        }
                    }
                }
                ++n3;
            }
        }
    }
}

