/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import soot.FastHierarchy;
import soot.G;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class MergeChecker {
    protected PAG pag;
    protected MultiMap<SparkField, VarNode> fieldToBase = new HashMultiMap<SparkField, VarNode>();

    public MergeChecker(PAG pag) {
        this.pag = pag;
    }

    public void check() {
        for (AllocNode allocNode : this.pag.allocSources()) {
            this.handleAllocNode(allocNode);
        }
        for (Node node : this.pag.simpleSources()) {
            this.handleSimples((VarNode)node);
        }
        for (Node node : this.pag.loadSources()) {
            this.handleLoads((FieldRefNode)node);
        }
        for (Node node : this.pag.storeSources()) {
            this.handleStores((VarNode)node);
        }
        for (Node node : this.pag.loadSources()) {
            FieldRefNode fr2 = (FieldRefNode)node;
            this.fieldToBase.put(fr2.getField(), fr2.getBase());
        }
        for (Node node : this.pag.storeInvSources()) {
            FieldRefNode fr = (FieldRefNode)node;
            this.fieldToBase.put(fr.getField(), fr.getBase());
        }
        for (VarNode varNode : this.pag.getVarNodeNumberer()) {
            for (FieldRefNode fr : varNode.getAllFieldRefs()) {
                for (VarNode dst : this.fieldToBase.get(fr.getField())) {
                    FieldRefNode fr22;
                    if (!varNode.getP2Set().hasNonEmptyIntersection(dst.getP2Set()) || (fr22 = dst.dot(fr.getField())).getReplacement() == fr.getReplacement()) continue;
                    G.v().out.println("Check failure: " + fr + " should be merged with " + fr22);
                }
            }
        }
    }

    protected void checkAll(final Node container2, PointsToSetInternal nodes, final Node upstream) {
        nodes.forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                MergeChecker.this.checkNode(container2, n, upstream);
            }
        });
    }

    protected void checkNode(Node container2, Node n, Node upstream) {
        if (container2.getReplacement() != container2) {
            throw new RuntimeException("container " + container2 + " is illegal");
        }
        if (upstream.getReplacement() != upstream) {
            throw new RuntimeException("upstream " + upstream + " is illegal");
        }
        PointsToSetInternal p2set = container2.getP2Set();
        FastHierarchy fh = this.pag.getTypeManager().getFastHierarchy();
        if (!p2set.contains(n) && (fh == null || container2.getType() == null || fh.canStoreType(n.getType(), container2.getType()))) {
            G.v().out.println("Check failure: " + container2 + " does not have " + n + "; upstream is " + upstream);
        }
    }

    protected void handleAllocNode(AllocNode src) {
        Node[] targets;
        Node[] nodeArray = targets = this.pag.allocLookup(src);
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            Node element = nodeArray[n2];
            this.checkNode(element, src, src);
            ++n2;
        }
    }

    protected void handleSimples(VarNode src) {
        Node[] simpleTargets;
        PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return;
        }
        Node[] nodeArray = simpleTargets = this.pag.simpleLookup(src);
        int n = simpleTargets.length;
        int n2 = 0;
        while (n2 < n) {
            Node element = nodeArray[n2];
            this.checkAll(element, srcSet, src);
            ++n2;
        }
    }

    protected void handleStores(VarNode src) {
        Node[] storeTargets;
        PointsToSetInternal srcSet = src.getP2Set();
        if (srcSet.isEmpty()) {
            return;
        }
        Node[] nodeArray = storeTargets = this.pag.storeLookup(src);
        int n = storeTargets.length;
        int n2 = 0;
        while (n2 < n) {
            Node element = nodeArray[n2];
            FieldRefNode fr = (FieldRefNode)element;
            this.checkAll(fr, srcSet, src);
            ++n2;
        }
    }

    protected void handleLoads(FieldRefNode src) {
        Node[] loadTargets = this.pag.loadLookup(src);
        PointsToSetInternal set = src.getP2Set();
        if (set.isEmpty()) {
            return;
        }
        Node[] nodeArray = loadTargets;
        int n = loadTargets.length;
        int n2 = 0;
        while (n2 < n) {
            Node element = nodeArray[n2];
            VarNode target = (VarNode)element;
            this.checkAll(target, set, src);
            ++n2;
        }
    }
}

