/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.TreeSet;
import soot.G;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.TopoSorter;
import soot.util.queue.QueueReader;

public final class PropWorklist
extends Propagator {
    protected final Set<VarNode> varNodeWorkList = new TreeSet<VarNode>();
    protected PAG pag;
    protected OnFlyCallGraph ofcg;

    public PropWorklist(PAG pag) {
        this.pag = pag;
    }

    @Override
    public final void propagate() {
        this.ofcg = this.pag.getOnFlyCallGraph();
        new TopoSorter(this.pag, false).sort();
        for (AllocNode object : this.pag.allocSources()) {
            this.handleAllocNode(object);
        }
        boolean verbose = this.pag.getOpts().verbose();
        do {
            if (verbose) {
                G.v().out.println("Worklist has " + this.varNodeWorkList.size() + " nodes.");
            }
            while (!this.varNodeWorkList.isEmpty()) {
                VarNode src = this.varNodeWorkList.iterator().next();
                this.varNodeWorkList.remove(src);
                this.handleVarNode(src);
            }
            if (verbose) {
                G.v().out.println("Now handling field references");
            }
            for (VarNode object : this.pag.storeSources()) {
                Node[] targets;
                final VarNode src = object;
                Node[] nodeArray = targets = this.pag.storeLookup(src);
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    Node element0 = nodeArray[n2];
                    final FieldRefNode target = (FieldRefNode)element0;
                    target.getBase().makeP2Set().forall(new P2SetVisitor(){

                        @Override
                        public final void visit(Node n) {
                            AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, target.getField());
                            nDotF.makeP2Set().addAll(src.getP2Set(), null);
                        }
                    });
                    ++n2;
                }
            }
            HashSet<Object[]> edgesToPropagate = new HashSet<Object[]>();
            for (Object e : this.pag.loadSources()) {
                this.handleFieldRefNode((FieldRefNode)e, edgesToPropagate);
            }
            Set<PointsToSetInternal> set = Collections.newSetFromMap(new IdentityHashMap());
            for (Object[] pair : edgesToPropagate) {
                PointsToSetInternal nDotF = (PointsToSetInternal)pair[0];
                PointsToSetInternal newP2Set = nDotF.getNewSet();
                VarNode loadTarget = (VarNode)pair[1];
                if (loadTarget.makeP2Set().addAll(newP2Set, null)) {
                    this.varNodeWorkList.add(loadTarget);
                }
                set.add(nDotF);
            }
            for (PointsToSetInternal nDotF : set) {
                nDotF.flushNew();
            }
        } while (!this.varNodeWorkList.isEmpty());
    }

    protected final boolean handleAllocNode(AllocNode src) {
        Node[] targets;
        boolean ret = false;
        Node[] nodeArray = targets = this.pag.allocLookup(src);
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            Node element = nodeArray[n2];
            if (element.makeP2Set().add(src)) {
                this.varNodeWorkList.add((VarNode)element);
                ret = true;
            }
            ++n2;
        }
        return ret;
    }

    protected final boolean handleVarNode(VarNode src) {
        Object edgeTgt22;
        boolean ret = false;
        boolean flush = true;
        if (src.getReplacement() != src) {
            throw new RuntimeException("Got bad node " + src + " with rep " + src.getReplacement());
        }
        final PointsToSetInternal newP2Set = src.getP2Set().getNewSet();
        if (newP2Set.isEmpty()) {
            return false;
        }
        if (this.ofcg != null) {
            QueueReader<Node> addedEdges = this.pag.edgeReader();
            this.ofcg.updatedNode(src);
            this.ofcg.build();
            while (addedEdges.hasNext()) {
                Node edgeSrc;
                Node addedSrc = addedEdges.next();
                Node addedTgt = addedEdges.next();
                ret = true;
                if (addedSrc instanceof VarNode) {
                    if (!(addedTgt instanceof VarNode)) continue;
                    edgeSrc = (VarNode)addedSrc.getReplacement();
                    edgeTgt22 = (VarNode)addedTgt.getReplacement();
                    if (!((Node)edgeTgt22).makeP2Set().addAll(edgeSrc.getP2Set(), null)) continue;
                    this.varNodeWorkList.add((VarNode)edgeTgt22);
                    if (edgeTgt22 != src) continue;
                    flush = false;
                    continue;
                }
                if (!(addedSrc instanceof AllocNode)) continue;
                edgeSrc = (AllocNode)addedSrc;
                edgeTgt22 = (VarNode)addedTgt.getReplacement();
                if (!((Node)edgeTgt22).makeP2Set().add(edgeSrc)) continue;
                this.varNodeWorkList.add((VarNode)edgeTgt22);
                if (edgeTgt22 != src) continue;
                flush = false;
            }
        }
        Node[] simpleTargets = this.pag.simpleLookup(src);
        edgeTgt22 = simpleTargets;
        int edgeSrc = simpleTargets.length;
        int addedTgt = 0;
        while (addedTgt < edgeSrc) {
            Node element = edgeTgt22[addedTgt];
            if (element.makeP2Set().addAll(newP2Set, null)) {
                this.varNodeWorkList.add((VarNode)element);
                if (element == src) {
                    flush = false;
                }
                ret = true;
            }
            ++addedTgt;
        }
        Node[] storeTargets = this.pag.storeLookup(src);
        Node[] nodeArray = storeTargets;
        int edgeTgt22 = storeTargets.length;
        edgeSrc = 0;
        while (edgeSrc < edgeTgt22) {
            Node element = nodeArray[edgeSrc];
            FieldRefNode fr = (FieldRefNode)element;
            final SparkField f = fr.getField();
            ret = fr.getBase().getP2Set().forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, f);
                    if (nDotF.makeP2Set().addAll(newP2Set, null)) {
                        this.returnValue = true;
                    }
                }
            }) | ret;
            ++edgeSrc;
        }
        final HashSet storesToPropagate = new HashSet();
        final HashSet loadsToPropagate = new HashSet();
        for (FieldRefNode fr : src.getAllFieldRefs()) {
            Node[] loadTargets;
            final SparkField field = fr.getField();
            final Node[] storeSources = this.pag.storeInvLookup(fr);
            if (storeSources.length > 0) {
                newP2Set.forall(new P2SetVisitor(){

                    @Override
                    public final void visit(Node n) {
                        AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field);
                        Node[] nodeArray = storeSources;
                        int n2 = storeSources.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            Node element = nodeArray[n3];
                            Node[] pair = new Node[]{element, nDotF.getReplacement()};
                            storesToPropagate.add(pair);
                            ++n3;
                        }
                    }
                });
            }
            if ((loadTargets = this.pag.loadLookup(fr)).length <= 0) continue;
            newP2Set.forall(new P2SetVisitor(){

                @Override
                public final void visit(Node n) {
                    AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field);
                    if (nDotF != null) {
                        Node[] nodeArray = loadTargets;
                        int n2 = loadTargets.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            Node element = nodeArray[n3];
                            Node[] pair = new Node[]{nDotF.getReplacement(), element};
                            loadsToPropagate.add(pair);
                            ++n3;
                        }
                    }
                }
            });
        }
        if (flush) {
            src.getP2Set().flushNew();
        }
        for (Node[] p : storesToPropagate) {
            VarNode storeSource = (VarNode)p[0];
            AllocDotField nDotF = (AllocDotField)p[1];
            if (!nDotF.makeP2Set().addAll(storeSource.getP2Set(), null)) continue;
            ret = true;
        }
        for (Node[] p : loadsToPropagate) {
            AllocDotField nDotF = (AllocDotField)p[0];
            VarNode loadTarget = (VarNode)p[1];
            if (!loadTarget.makeP2Set().addAll(nDotF.getP2Set(), null)) continue;
            this.varNodeWorkList.add(loadTarget);
            ret = true;
        }
        return ret;
    }

    protected final void handleFieldRefNode(FieldRefNode src, final HashSet<Object[]> edgesToPropagate) {
        final Node[] loadTargets = this.pag.loadLookup(src);
        if (loadTargets.length == 0) {
            return;
        }
        final SparkField field = src.getField();
        src.getBase().getP2Set().forall(new P2SetVisitor(){

            @Override
            public final void visit(Node n) {
                PointsToSetInternal p2Set;
                AllocDotField nDotF = PropWorklist.this.pag.makeAllocDotField((AllocNode)n, field);
                if (nDotF != null && !(p2Set = nDotF.getP2Set()).getNewSet().isEmpty()) {
                    Node[] nodeArray = loadTargets;
                    int n2 = loadTargets.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Node element = nodeArray[n3];
                        Object[] pair = new Object[]{p2Set, element};
                        edgesToPropagate.add(pair);
                        ++n3;
                    }
                }
            }
        });
    }
}

