/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.HashSet;
import java.util.TreeSet;
import soot.G;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.TopoSorter;

public class SCCCollapser {
    protected int numCollapsed = 0;
    protected PAG pag;
    protected HashSet<VarNode> visited = new HashSet();
    protected boolean ignoreTypes;
    protected TypeManager typeManager;

    public void collapse() {
        boolean verbose = this.pag.getOpts().verbose();
        if (verbose) {
            G.v().out.println("Total VarNodes: " + this.pag.getVarNodeNumberer().size() + ". Collapsing SCCs...");
        }
        new TopoSorter(this.pag, this.ignoreTypes).sort();
        TreeSet<VarNode> s = new TreeSet<VarNode>();
        for (VarNode v : this.pag.getVarNodeNumberer()) {
            s.add(v);
        }
        for (VarNode v : s) {
            this.dfsVisit(v, v);
        }
        if (verbose) {
            G.v().out.println(this.numCollapsed + " nodes were collapsed.");
        }
        this.visited = null;
    }

    public SCCCollapser(PAG pag, boolean ignoreTypes) {
        this.pag = pag;
        this.ignoreTypes = ignoreTypes;
        this.typeManager = pag.getTypeManager();
    }

    protected final void dfsVisit(VarNode v, VarNode rootOfSCC) {
        Node[] succs;
        if (this.visited.contains(v)) {
            return;
        }
        this.visited.add(v);
        Node[] nodeArray = succs = this.pag.simpleInvLookup(v);
        int n = succs.length;
        int n2 = 0;
        while (n2 < n) {
            Node element = nodeArray[n2];
            if (this.ignoreTypes || this.typeManager.castNeverFails(element.getType(), v.getType())) {
                this.dfsVisit((VarNode)element, rootOfSCC);
            }
            ++n2;
        }
        if (v != rootOfSCC) {
            if (!this.ignoreTypes) {
                if (this.typeManager.castNeverFails(v.getType(), rootOfSCC.getType()) && this.typeManager.castNeverFails(rootOfSCC.getType(), v.getType())) {
                    rootOfSCC.mergeWith(v);
                    ++this.numCollapsed;
                }
            } else {
                if (this.typeManager.castNeverFails(v.getType(), rootOfSCC.getType())) {
                    rootOfSCC.mergeWith(v);
                } else if (this.typeManager.castNeverFails(rootOfSCC.getType(), v.getType())) {
                    v.mergeWith(rootOfSCC);
                } else {
                    rootOfSCC.getReplacement().setType(null);
                    PointsToSetInternal set = rootOfSCC.getP2Set();
                    if (set != null) {
                        set.setType(null);
                    }
                    rootOfSCC.mergeWith(v);
                }
                ++this.numCollapsed;
            }
        }
    }
}

