/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.HashSet;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;

public class TopoSorter {
    protected boolean ignoreTypes;
    protected PAG pag;
    protected int nextFinishNumber = 1;
    protected HashSet<VarNode> visited;

    public void sort() {
        for (VarNode v : this.pag.getVarNodeNumberer()) {
            this.dfsVisit(v);
        }
        this.visited = null;
    }

    public TopoSorter(PAG pag, boolean ignoreTypes) {
        this.pag = pag;
        this.ignoreTypes = ignoreTypes;
        this.visited = new HashSet();
    }

    protected void dfsVisit(VarNode n) {
        Node[] succs;
        if (this.visited.contains(n)) {
            return;
        }
        this.visited.add(n);
        Node[] nodeArray = succs = this.pag.simpleLookup(n);
        int n2 = succs.length;
        int n3 = 0;
        while (n3 < n2) {
            Node element = nodeArray[n3];
            if (this.ignoreTypes || this.pag.getTypeManager().castNeverFails(n.getType(), element.getType())) {
                this.dfsVisit((VarNode)element);
            }
            ++n3;
        }
        n.setFinishingNumber(this.nextFinishNumber++);
    }
}

