/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.parity;

import java.util.HashMap;
import java.util.Map;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AddExpr;
import soot.jimple.ArithmeticConstant;
import soot.jimple.BinopExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.MulExpr;
import soot.jimple.SubExpr;
import soot.options.Options;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.LiveLocals;

public class ParityAnalysis
extends ForwardFlowAnalysis<Unit, Map<Value, Parity>> {
    private UnitGraph g;
    private LiveLocals filter;

    public ParityAnalysis(UnitGraph g, LiveLocals filter) {
        super(g);
        this.g = g;
        this.filter = filter;
        this.filterUnitToBeforeFlow = new HashMap();
        this.buildBeforeFilterMap();
        this.filterUnitToAfterFlow = new HashMap();
        this.doAnalysis();
    }

    public ParityAnalysis(UnitGraph g) {
        super(g);
        this.g = g;
        this.doAnalysis();
    }

    private void buildBeforeFilterMap() {
        for (Unit s : this.g.getBody().getUnits()) {
            HashMap<Local, Parity> map = new HashMap<Local, Parity>();
            for (Local l : this.filter.getLiveLocalsBefore(s)) {
                map.put(l, Parity.BOTTOM);
            }
            this.filterUnitToBeforeFlow.put(s, map);
        }
    }

    @Override
    protected void merge(Map<Value, Parity> inMap1, Map<Value, Parity> inMap2, Map<Value, Parity> outMap) {
        for (Value var1 : inMap1.keySet()) {
            Parity inVal1 = inMap1.get(var1);
            Parity inVal2 = inMap2.get(var1);
            if (inVal2 == null) {
                outMap.put(var1, inVal1);
                continue;
            }
            if (inVal1.equals((Object)Parity.BOTTOM)) {
                outMap.put(var1, inVal2);
                continue;
            }
            if (inVal2.equals((Object)Parity.BOTTOM)) {
                outMap.put(var1, inVal1);
                continue;
            }
            if (inVal1.equals((Object)Parity.EVEN) && inVal2.equals((Object)Parity.EVEN)) {
                outMap.put(var1, Parity.EVEN);
                continue;
            }
            if (inVal1.equals((Object)Parity.ODD) && inVal2.equals((Object)Parity.ODD)) {
                outMap.put(var1, Parity.ODD);
                continue;
            }
            outMap.put(var1, Parity.TOP);
        }
    }

    @Override
    protected void copy(Map<Value, Parity> sourceIn, Map<Value, Parity> destOut) {
        destOut.clear();
        destOut.putAll(sourceIn);
    }

    private Parity getParity(Map<Value, Parity> in, Value val) {
        if (val instanceof AddExpr | val instanceof SubExpr) {
            Parity resVal1 = this.getParity(in, ((BinopExpr)val).getOp1());
            Parity resVal2 = this.getParity(in, ((BinopExpr)val).getOp2());
            if (resVal1.equals((Object)Parity.TOP) | resVal2.equals((Object)Parity.TOP)) {
                return Parity.TOP;
            }
            if (resVal1.equals((Object)Parity.BOTTOM) | resVal2.equals((Object)Parity.BOTTOM)) {
                return Parity.BOTTOM;
            }
            if (resVal1.equals((Object)resVal2)) {
                return Parity.EVEN;
            }
            return Parity.ODD;
        }
        if (val instanceof MulExpr) {
            Parity resVal1 = this.getParity(in, ((BinopExpr)val).getOp1());
            Parity resVal2 = this.getParity(in, ((BinopExpr)val).getOp2());
            if (resVal1.equals((Object)Parity.TOP) | resVal2.equals((Object)Parity.TOP)) {
                return Parity.TOP;
            }
            if (resVal1.equals((Object)Parity.BOTTOM) | resVal2.equals((Object)Parity.BOTTOM)) {
                return Parity.BOTTOM;
            }
            if (resVal1.equals((Object)resVal2)) {
                return resVal1;
            }
            return Parity.EVEN;
        }
        if (val instanceof IntConstant) {
            int value = ((IntConstant)val).value;
            return Parity.valueOf(value);
        }
        if (val instanceof LongConstant) {
            long value = ((LongConstant)val).value;
            return Parity.valueOf(value);
        }
        Parity p = in.get(val);
        if (p == null) {
            return Parity.TOP;
        }
        return p;
    }

    @Override
    protected void flowThrough(Map<Value, Parity> in, Unit s, Map<Value, Parity> out) {
        Value left;
        out.putAll(in);
        if (s instanceof DefinitionStmt && (left = ((DefinitionStmt)s).getLeftOp()) instanceof Local && (left.getType() instanceof IntegerType || left.getType() instanceof LongType)) {
            Value right = ((DefinitionStmt)s).getRightOp();
            out.put(left, this.getParity(out, right));
        }
        for (ValueBox next : s.getUseAndDefBoxes()) {
            Value val = next.getValue();
            if (!(val instanceof ArithmeticConstant)) continue;
            out.put(val, this.getParity(out, val));
        }
        if (Options.v().interactive_mode()) {
            this.buildAfterFilterMap(s);
            this.updateAfterFilterMap(s);
        }
    }

    private void buildAfterFilterMap(Unit s) {
        HashMap<Local, Parity> map = new HashMap<Local, Parity>();
        for (Local local : this.filter.getLiveLocalsAfter(s)) {
            map.put(local, Parity.BOTTOM);
        }
        this.filterUnitToAfterFlow.put(s, map);
    }

    @Override
    protected Map<Value, Parity> entryInitialFlow() {
        return this.newInitialFlow();
    }

    private void updateBeforeFilterMap() {
        for (Unit s : this.filterUnitToBeforeFlow.keySet()) {
            Map allData = (Map)this.getFlowBefore(s);
            Map filterData = (Map)this.filterUnitToBeforeFlow.get(s);
            this.filterUnitToBeforeFlow.put(s, this.updateFilter(allData, filterData));
        }
    }

    private void updateAfterFilterMap(Unit s) {
        Map allData = (Map)this.getFlowAfter(s);
        Map filterData = (Map)this.filterUnitToAfterFlow.get(s);
        this.filterUnitToAfterFlow.put(s, this.updateFilter(allData, filterData));
    }

    private Map<Value, Parity> updateFilter(Map<Value, Parity> allData, Map<Value, Parity> filterData) {
        if (allData == null) {
            return filterData;
        }
        for (Value v : filterData.keySet()) {
            Parity d = allData.get(v);
            if (d == null) {
                filterData.remove(v);
                continue;
            }
            filterData.put(v, d);
        }
        return filterData;
    }

    @Override
    protected Map<Value, Parity> newInitialFlow() {
        HashMap<Value, Parity> initMap = new HashMap<Value, Parity>();
        for (Local l : this.g.getBody().getLocals()) {
            Type t = l.getType();
            if (!(t instanceof IntegerType) && !(t instanceof LongType)) continue;
            initMap.put(l, Parity.BOTTOM);
        }
        for (ValueBox vb : this.g.getBody().getUseAndDefBoxes()) {
            Value val = vb.getValue();
            if (!(val instanceof ArithmeticConstant)) continue;
            initMap.put(val, this.getParity(initMap, val));
        }
        if (Options.v().interactive_mode()) {
            this.updateBeforeFilterMap();
        }
        return initMap;
    }

    public static enum Parity {
        TOP,
        BOTTOM,
        EVEN,
        ODD;


        static Parity valueOf(long v) {
            return v % 2L == 0L ? EVEN : ODD;
        }

        public static Parity valueOf(String string) {
            return Enum.valueOf(Parity.class, string);
        }
    }
}

