/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.purity;

import java.io.File;
import java.util.HashMap;
import soot.Local;
import soot.RefLikeType;
import soot.SourceLocator;
import soot.Unit;
import soot.Value;
import soot.jimple.AnyNewExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.Constant;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceOfExpr;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.NopStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.UnopExpr;
import soot.jimple.toolkits.annotation.purity.AbstractInterproceduralAnalysis;
import soot.jimple.toolkits.annotation.purity.PurityGraph;
import soot.jimple.toolkits.annotation.purity.PurityGraphBox;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.util.dot.DotGraph;
import soot.util.dot.DotGraphEdge;
import soot.util.dot.DotGraphNode;

public class PurityIntraproceduralAnalysis
extends ForwardFlowAnalysis {
    AbstractInterproceduralAnalysis inter;

    @Override
    protected Object newInitialFlow() {
        return new PurityGraphBox();
    }

    @Override
    protected Object entryInitialFlow() {
        return new PurityGraphBox();
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        PurityGraphBox i1 = (PurityGraphBox)in1;
        PurityGraphBox i2 = (PurityGraphBox)in2;
        PurityGraphBox o = (PurityGraphBox)out;
        if (out != i1) {
            o.g = new PurityGraph(i1.g);
        }
        o.g.union(i2.g);
    }

    @Override
    protected void copy(Object source, Object dest) {
        PurityGraphBox src = (PurityGraphBox)source;
        PurityGraphBox dst = (PurityGraphBox)dest;
        dst.g = new PurityGraph(src.g);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        PurityGraphBox i = (PurityGraphBox)inValue;
        PurityGraphBox o = (PurityGraphBox)outValue;
        Stmt stmt = (Stmt)unit;
        o.g = new PurityGraph(i.g);
        if (stmt.containsInvokeExpr()) {
            this.inter.analyseCall(inValue, stmt, outValue);
            return;
        }
        if (stmt instanceof AssignStmt) {
            Value leftOp = ((AssignStmt)stmt).getLeftOp();
            Value rightOp = ((AssignStmt)stmt).getRightOp();
            if (leftOp instanceof Local) {
                Local left = (Local)leftOp;
                if (rightOp instanceof CastExpr) {
                    rightOp = ((CastExpr)rightOp).getOp();
                }
                if (!(left.getType() instanceof RefLikeType)) return;
                if (rightOp instanceof Local) {
                    Local right = (Local)rightOp;
                    o.g.assignLocalToLocal(right, left);
                    return;
                }
                if (rightOp instanceof ArrayRef) {
                    Local right = (Local)((ArrayRef)rightOp).getBase();
                    o.g.assignFieldToLocal(stmt, right, "[]", left);
                    return;
                }
                if (rightOp instanceof InstanceFieldRef) {
                    Local right = (Local)((InstanceFieldRef)rightOp).getBase();
                    String field = ((InstanceFieldRef)rightOp).getField().getName();
                    o.g.assignFieldToLocal(stmt, right, field, left);
                    return;
                }
                if (rightOp instanceof StaticFieldRef) {
                    o.g.localIsUnknown(left);
                    return;
                }
                if (rightOp instanceof Constant) return;
                if (rightOp instanceof AnyNewExpr) {
                    o.g.assignNewToLocal(stmt, left);
                    return;
                }
                if (rightOp instanceof BinopExpr) return;
                if (rightOp instanceof UnopExpr) return;
                if (rightOp instanceof InstanceOfExpr) return;
                throw new Error("AssignStmt match failure (rightOp)" + stmt);
            }
            if (leftOp instanceof ArrayRef) {
                Local left = (Local)((ArrayRef)leftOp).getBase();
                if (!(rightOp instanceof Local)) {
                    if (!(rightOp instanceof Constant)) throw new Error("AssignStmt match failure (rightOp)" + stmt);
                    o.g.mutateField(left, "[]");
                    return;
                }
                Local right = (Local)rightOp;
                if (right.getType() instanceof RefLikeType) {
                    o.g.assignLocalToField(right, left, "[]");
                    return;
                }
                o.g.mutateField(left, "[]");
                return;
            }
            if (leftOp instanceof InstanceFieldRef) {
                Local left = (Local)((InstanceFieldRef)leftOp).getBase();
                String field = ((InstanceFieldRef)leftOp).getField().getName();
                if (!(rightOp instanceof Local)) {
                    if (!(rightOp instanceof Constant)) throw new Error("AssignStmt match failure (rightOp) " + stmt);
                    o.g.mutateField(left, field);
                    return;
                }
                Local right = (Local)rightOp;
                if (right.getType() instanceof RefLikeType) {
                    o.g.assignLocalToField(right, left, field);
                    return;
                }
                o.g.mutateField(left, field);
                return;
            }
            if (!(leftOp instanceof StaticFieldRef)) throw new Error("AssignStmt match failure (leftOp) " + stmt);
            String field = ((StaticFieldRef)leftOp).getField().getName();
            if (!(rightOp instanceof Local)) {
                if (!(rightOp instanceof Constant)) throw new Error("AssignStmt match failure (rightOp) " + stmt);
                o.g.mutateStaticField(field);
                return;
            }
            Local right = (Local)rightOp;
            if (right.getType() instanceof RefLikeType) {
                o.g.assignLocalToStaticField(right, field);
                return;
            }
            o.g.mutateStaticField(field);
            return;
        }
        if (stmt instanceof IdentityStmt) {
            Local left = (Local)((IdentityStmt)stmt).getLeftOp();
            Value rightOp = ((IdentityStmt)stmt).getRightOp();
            if (rightOp instanceof ThisRef) {
                o.g.assignThisToLocal(left);
                return;
            }
            if (rightOp instanceof ParameterRef) {
                ParameterRef p = (ParameterRef)rightOp;
                if (!(p.getType() instanceof RefLikeType)) return;
                o.g.assignParamToLocal(p.getIndex(), left);
                return;
            }
            if (!(rightOp instanceof CaughtExceptionRef)) throw new Error("IdentityStmt match failure (rightOp) " + stmt);
            o.g.localIsUnknown(left);
            return;
        }
        if (stmt instanceof ThrowStmt) {
            Value op = ((ThrowStmt)stmt).getOp();
            if (op instanceof Local) {
                Local v = (Local)op;
                o.g.localEscapes(v);
                return;
            }
            if (op instanceof Constant) return;
            throw new Error("ThrowStmt match failure " + stmt);
        }
        if (stmt instanceof ReturnVoidStmt) return;
        if (!(stmt instanceof ReturnStmt)) {
            if (stmt instanceof IfStmt) return;
            if (stmt instanceof GotoStmt) return;
            if (stmt instanceof LookupSwitchStmt) return;
            if (stmt instanceof TableSwitchStmt) return;
            if (stmt instanceof MonitorStmt) return;
            if (stmt instanceof BreakpointStmt) return;
            if (stmt instanceof NopStmt) return;
            throw new Error("Stmt match faliure " + stmt);
        }
        Value v = ((ReturnStmt)stmt).getOp();
        if (v instanceof Local) {
            if (!(v.getType() instanceof RefLikeType)) return;
            o.g.returnLocal((Local)v);
            return;
        }
        if (v instanceof Constant) return;
        throw new Error("ReturnStmt match failure " + stmt);
    }

    public void drawAsOneDot(String prefix, String name) {
        DotGraph dot = new DotGraph(name);
        dot.setGraphLabel(name);
        dot.setGraphAttribute("compound", "true");
        dot.setGraphAttribute("rankdir", "LR");
        HashMap<Unit, Integer> node = new HashMap<Unit, Integer>();
        int id = 0;
        for (Unit stmt : this.graph) {
            PurityGraphBox ref = (PurityGraphBox)this.getFlowAfter(stmt);
            DotGraph sub = dot.createSubGraph("cluster" + id);
            DotGraphNode label = sub.drawNode("head" + id);
            String lbl = stmt.toString();
            if (lbl.startsWith("lookupswitch")) {
                lbl = "lookupswitch...";
            }
            if (lbl.startsWith("tableswitch")) {
                lbl = "tableswitch...";
            }
            sub.setGraphLabel(" ");
            label.setLabel(lbl);
            label.setAttribute("fontsize", "18");
            label.setShape("box");
            ref.g.fillDotGraph("X" + id, sub);
            node.put(stmt, new Integer(id));
            ++id;
        }
        for (Object src : this.graph) {
            for (Object dst : this.graph.getSuccsOf(src)) {
                DotGraphEdge edge = dot.drawEdge("head" + node.get(src), "head" + node.get(dst));
                edge.setAttribute("ltail", "cluster" + node.get(src));
                edge.setAttribute("lhead", "cluster" + node.get(dst));
            }
        }
        File f = new File(SourceLocator.v().getOutputDir(), String.valueOf(prefix) + name + ".dot");
        dot.plot(f.getPath());
    }

    public void copyResult(Object dst) {
        PurityGraph r = new PurityGraph();
        for (Stmt stmt : this.graph.getTails()) {
            PurityGraphBox ref = (PurityGraphBox)this.getFlowAfter(stmt);
            r.union(ref.g);
        }
        r.removeLocals();
        ((PurityGraphBox)dst).g = r;
    }

    PurityIntraproceduralAnalysis(UnitGraph g, AbstractInterproceduralAnalysis inter) {
        super(g);
        this.inter = inter;
        this.doAnalysis();
    }
}

