/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.PhaseOptions;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.options.Options;
import soot.util.Chain;

public class RenameDuplicatedClasses
extends SceneTransformer {
    private static final String FIXED_CLASS_NAME_SPERATOR = "-";

    public RenameDuplicatedClasses(Singletons.Global g) {
    }

    public static RenameDuplicatedClasses v() {
        return G.v().soot_jimple_toolkits_base_RenameDuplicatedClasses();
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        if (this.isFileSystemCaseSensitive()) {
            return;
        }
        String fixedClassNamesStr = PhaseOptions.getString(options, "fixedClassNames");
        String[] classNames = fixedClassNamesStr.split(FIXED_CLASS_NAME_SPERATOR);
        List<String> fixedClassNames = Arrays.asList(classNames);
        this.duplicatedCheck(fixedClassNames);
        if (Options.v().verbose()) {
            G.v().out.println("The fixed class names are: " + fixedClassNames);
        }
        Chain<SootClass> sootClasses = Scene.v().getClasses();
        HashMap<String, String> lowerCaseClassNameToReal = new HashMap<String, String>();
        int count = 0;
        Iterator<SootClass> iter = sootClasses.snapshotIterator();
        while (iter.hasNext()) {
            SootClass sootClass = iter.next();
            String className = sootClass.getName();
            if (lowerCaseClassNameToReal.containsKey(className.toLowerCase())) {
                if (fixedClassNames.contains(className)) {
                    sootClass = Scene.v().getSootClass((String)lowerCaseClassNameToReal.get(className.toLowerCase()));
                    className = (String)lowerCaseClassNameToReal.get(className.toLowerCase());
                }
                String newClassName = String.valueOf(className) + count++;
                sootClass.rename(newClassName);
                G.v().out.println("Rename duplicated class " + className + " to class " + newClassName);
                continue;
            }
            lowerCaseClassNameToReal.put(className.toLowerCase(), className);
        }
    }

    public void duplicatedCheck(List<String> classNames) {
        HashSet<String> classNameSet = new HashSet<String>();
        for (String className : classNames) {
            if (classNameSet.contains(className.toLowerCase())) {
                throw new RuntimeException("The fixed class names cannot contain duplicated class names.");
            }
            classNameSet.add(className.toLowerCase());
        }
    }

    public boolean isFileSystemCaseSensitive() {
        File dir = new File(".");
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                String lowerCaseFilePath = file.getAbsolutePath().toLowerCase();
                String upperCaseFilePath = file.getAbsolutePath().toUpperCase();
                File lowerCaseFile = new File(lowerCaseFilePath);
                File upperCaseFile = new File(upperCaseFilePath);
                if (!lowerCaseFile.exists() || !upperCaseFile.exists()) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }
}

