/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.MethodOrMethodContext;
import soot.Unit;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.Filter;

public class TransitiveTargets {
    private CallGraph cg;
    private Filter filter;

    public TransitiveTargets(CallGraph cg) {
        this.cg = cg;
    }

    public TransitiveTargets(CallGraph cg, Filter filter) {
        this.cg = cg;
        this.filter = filter;
    }

    public Iterator<MethodOrMethodContext> iterator(Unit u) {
        ArrayList<MethodOrMethodContext> methods = new ArrayList<MethodOrMethodContext>();
        Iterator<Edge> it = this.cg.edgesOutOf(u);
        if (this.filter != null) {
            it = this.filter.wrap(it);
        }
        while (it.hasNext()) {
            Edge e = it.next();
            methods.add(e.getTgt());
        }
        return this.iterator(methods.iterator());
    }

    public Iterator<MethodOrMethodContext> iterator(MethodOrMethodContext momc) {
        ArrayList<MethodOrMethodContext> methods = new ArrayList<MethodOrMethodContext>();
        Iterator<Edge> it = this.cg.edgesOutOf(momc);
        if (this.filter != null) {
            it = this.filter.wrap(it);
        }
        while (it.hasNext()) {
            Edge e = it.next();
            methods.add(e.getTgt());
        }
        return this.iterator(methods.iterator());
    }

    public Iterator<MethodOrMethodContext> iterator(Iterator<MethodOrMethodContext> methods) {
        HashSet<MethodOrMethodContext> s = new HashSet<MethodOrMethodContext>();
        ArrayList<MethodOrMethodContext> worklist = new ArrayList<MethodOrMethodContext>();
        while (methods.hasNext()) {
            MethodOrMethodContext method = methods.next();
            if (!s.add(method)) continue;
            worklist.add(method);
        }
        return this.iterator(s, worklist);
    }

    private Iterator<MethodOrMethodContext> iterator(Set<MethodOrMethodContext> s, ArrayList<MethodOrMethodContext> worklist) {
        int i = 0;
        while (i < worklist.size()) {
            MethodOrMethodContext method = worklist.get(i);
            Iterator<Edge> it = this.cg.edgesOutOf(method);
            if (this.filter != null) {
                it = this.filter.wrap(it);
            }
            while (it.hasNext()) {
                Edge e = it.next();
                if (!s.add(e.getTgt())) continue;
                worklist.add(e.getTgt());
            }
            ++i;
        }
        return worklist.iterator();
    }
}

