/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.ide;

import com.google.common.collect.Table;
import heros.IDETabulationProblem;
import heros.InterproceduralCFG;
import heros.solver.IDESolver;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import soot.PatchingChain;
import soot.SootMethod;
import soot.Unit;

public class JimpleIDESolver<D, V, I extends InterproceduralCFG<Unit, SootMethod>>
extends IDESolver<Unit, D, SootMethod, V, I> {
    private final boolean DUMP_RESULTS;

    public JimpleIDESolver(IDETabulationProblem<Unit, D, SootMethod, V, I> problem) {
        this(problem, false);
    }

    public JimpleIDESolver(IDETabulationProblem<Unit, D, SootMethod, V, I> problem, boolean dumpResults) {
        super(problem);
        this.DUMP_RESULTS = dumpResults;
    }

    @Override
    public void solve() {
        super.solve();
        if (this.DUMP_RESULTS) {
            this.dumpResults();
        }
    }

    public void dumpResults() {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream("ideSolverDump" + System.currentTimeMillis() + ".csv"));
            ArrayList<String> res = new ArrayList<String>();
            for (Table.Cell entry : this.val.cellSet()) {
                SootMethod methodOf = (SootMethod)this.icfg.getMethodOf((Unit)entry.getRowKey());
                PatchingChain<Unit> units = methodOf.getActiveBody().getUnits();
                int i = 0;
                for (Unit unit : units) {
                    if (unit == entry.getRowKey()) break;
                    ++i;
                }
                res.add(methodOf + ";" + entry.getRowKey() + "@" + i + ";" + entry.getColumnKey() + ";" + entry.getValue());
            }
            Collections.sort(res);
            for (String string : res) {
                out.println(string);
            }
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

