/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.ide;

import com.google.common.collect.Table;
import heros.IFDSTabulationProblem;
import heros.InterproceduralCFG;
import heros.solver.IFDSSolver;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import soot.PatchingChain;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.toolkits.ide.SortableCSVString;

public class JimpleIFDSSolver<D, I extends InterproceduralCFG<Unit, SootMethod>>
extends IFDSSolver<Unit, D, SootMethod, I> {
    private final boolean DUMP_RESULTS;

    public JimpleIFDSSolver(IFDSTabulationProblem<Unit, D, SootMethod, I> problem) {
        this(problem, false);
    }

    public JimpleIFDSSolver(IFDSTabulationProblem<Unit, D, SootMethod, I> problem, boolean dumpResults) {
        super(problem);
        this.DUMP_RESULTS = dumpResults;
    }

    @Override
    public void solve() {
        super.solve();
        if (this.DUMP_RESULTS) {
            this.dumpResults();
        }
    }

    public void dumpResults() {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream("ideSolverDump" + System.currentTimeMillis() + ".csv"));
            ArrayList<SortableCSVString> res = new ArrayList<SortableCSVString>();
            for (Table.Cell entry : this.val.cellSet()) {
                SootMethod methodOf = (SootMethod)this.icfg.getMethodOf((Unit)entry.getRowKey());
                PatchingChain<Unit> units = methodOf.getActiveBody().getUnits();
                int i = 0;
                for (Unit unit : units) {
                    if (unit == entry.getRowKey()) break;
                    ++i;
                }
                res.add(new SortableCSVString(methodOf + ";" + entry.getRowKey() + "@" + i + ";" + entry.getColumnKey() + ";" + entry.getValue(), i));
            }
            Collections.sort(res);
            for (SortableCSVString string : res) {
                out.println(string.value.replace("\"", "'"));
            }
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

