/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.infoflow;

import java.util.ArrayList;
import java.util.List;
import soot.EquivalentValue;
import soot.RefLikeType;
import soot.jimple.InstanceFieldRef;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.StaticFieldRef;
import soot.jimple.ThisRef;

public class CallLocalityContext {
    List<EquivalentValue> nodes = new ArrayList<EquivalentValue>();
    List<Boolean> isNodeLocal;

    public CallLocalityContext(List<EquivalentValue> nodes) {
        this.nodes.addAll(nodes);
        this.isNodeLocal = new ArrayList<Boolean>(nodes.size());
        int i = 0;
        while (i < nodes.size()) {
            this.isNodeLocal.add(i, Boolean.FALSE);
            ++i;
        }
    }

    public void setFieldLocal(EquivalentValue fieldRef) {
        int i = 0;
        while (i < this.nodes.size()) {
            if (fieldRef.equals(this.nodes.get(i))) {
                this.isNodeLocal.remove(i);
                this.isNodeLocal.add(i, Boolean.TRUE);
                return;
            }
            ++i;
        }
        this.nodes.add(fieldRef);
        this.isNodeLocal.add(Boolean.TRUE);
    }

    public void setFieldShared(EquivalentValue fieldRef) {
        int i = 0;
        while (i < this.nodes.size()) {
            if (fieldRef.equals(this.nodes.get(i))) {
                this.isNodeLocal.remove(i);
                this.isNodeLocal.add(i, Boolean.FALSE);
                return;
            }
            ++i;
        }
        this.nodes.add(fieldRef);
        this.isNodeLocal.add(Boolean.FALSE);
    }

    public void setAllFieldsLocal() {
        int i = 0;
        while (i < this.nodes.size()) {
            Ref r = (Ref)this.nodes.get(i).getValue();
            if (r instanceof InstanceFieldRef) {
                this.isNodeLocal.remove(i);
                this.isNodeLocal.add(i, Boolean.TRUE);
            }
            ++i;
        }
    }

    public void setAllFieldsShared() {
        int i = 0;
        while (i < this.nodes.size()) {
            Ref r = (Ref)this.nodes.get(i).getValue();
            if (r instanceof InstanceFieldRef) {
                this.isNodeLocal.remove(i);
                this.isNodeLocal.add(i, Boolean.FALSE);
            }
            ++i;
        }
    }

    public void setParamLocal(int index) {
        int i = 0;
        while (i < this.nodes.size()) {
            ParameterRef pr;
            Ref r = (Ref)this.nodes.get(i).getValue();
            if (r instanceof ParameterRef && (pr = (ParameterRef)r).getIndex() == index) {
                this.isNodeLocal.remove(i);
                this.isNodeLocal.add(i, Boolean.TRUE);
            }
            ++i;
        }
    }

    public void setParamShared(int index) {
        int i = 0;
        while (i < this.nodes.size()) {
            ParameterRef pr;
            Ref r = (Ref)this.nodes.get(i).getValue();
            if (r instanceof ParameterRef && (pr = (ParameterRef)r).getIndex() == index) {
                this.isNodeLocal.remove(i);
                this.isNodeLocal.add(i, Boolean.FALSE);
            }
            ++i;
        }
    }

    public void setAllParamsLocal() {
        int i = 0;
        while (i < this.nodes.size()) {
            ParameterRef pr;
            Ref r = (Ref)this.nodes.get(i).getValue();
            if (r instanceof ParameterRef && (pr = (ParameterRef)r).getIndex() != -1) {
                this.isNodeLocal.remove(i);
                this.isNodeLocal.add(i, Boolean.TRUE);
            }
            ++i;
        }
    }

    public void setAllParamsShared() {
        int i = 0;
        while (i < this.nodes.size()) {
            ParameterRef pr;
            Ref r = (Ref)this.nodes.get(i).getValue();
            if (r instanceof ParameterRef && (pr = (ParameterRef)r).getIndex() != -1) {
                this.isNodeLocal.remove(i);
                this.isNodeLocal.add(i, Boolean.FALSE);
            }
            ++i;
        }
    }

    public void setThisLocal() {
        int i = 0;
        while (i < this.nodes.size()) {
            Ref r = (Ref)this.nodes.get(i).getValue();
            if (r instanceof ThisRef) {
                this.isNodeLocal.remove(i);
                this.isNodeLocal.add(i, Boolean.TRUE);
            }
            ++i;
        }
    }

    public void setThisShared() {
        int i = 0;
        while (i < this.nodes.size()) {
            Ref r = (Ref)this.nodes.get(i).getValue();
            if (r instanceof ThisRef) {
                this.isNodeLocal.remove(i);
                this.isNodeLocal.add(i, Boolean.FALSE);
            }
            ++i;
        }
    }

    public void setReturnLocal() {
        this.setParamLocal(-1);
    }

    public void setReturnShared() {
        this.setParamShared(-1);
    }

    public List<Object> getLocalRefs() {
        ArrayList<Object> ret = new ArrayList<Object>();
        int i = 0;
        while (i < this.nodes.size()) {
            if (this.isNodeLocal.get(i).booleanValue()) {
                ret.add(this.nodes.get(i));
            }
            ++i;
        }
        return ret;
    }

    public List<Object> getSharedRefs() {
        ArrayList<Object> ret = new ArrayList<Object>();
        int i = 0;
        while (i < this.nodes.size()) {
            if (!this.isNodeLocal.get(i).booleanValue()) {
                ret.add(this.nodes.get(i));
            }
            ++i;
        }
        return ret;
    }

    public boolean isFieldLocal(EquivalentValue fieldRef) {
        int i = 0;
        while (i < this.nodes.size()) {
            if (fieldRef.equals(this.nodes.get(i))) {
                return this.isNodeLocal.get(i);
            }
            ++i;
        }
        return false;
    }

    public boolean containsField(EquivalentValue fieldRef) {
        int i = 0;
        while (i < this.nodes.size()) {
            if (fieldRef.equals(this.nodes.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean merge(CallLocalityContext other) {
        int i;
        boolean isChanged = false;
        if (other.nodes.size() > this.nodes.size()) {
            isChanged = true;
            i = this.nodes.size();
            while (i < other.nodes.size()) {
                this.nodes.add(other.nodes.get(i));
                this.isNodeLocal.add(other.isNodeLocal.get(i));
                ++i;
            }
        }
        i = 0;
        while (i < other.nodes.size()) {
            Boolean temp = new Boolean(this.isNodeLocal.get(i) != false && other.isNodeLocal.get(i) != false);
            if (!temp.equals(this.isNodeLocal.get(i))) {
                isChanged = true;
            }
            this.isNodeLocal.remove(i);
            this.isNodeLocal.add(i, temp);
            ++i;
        }
        return isChanged;
    }

    public boolean equals(Object o) {
        if (o instanceof CallLocalityContext) {
            CallLocalityContext other = (CallLocalityContext)o;
            return this.isNodeLocal.equals(other.isNodeLocal);
        }
        return false;
    }

    public int hashCode() {
        return this.isNodeLocal.hashCode();
    }

    public boolean isAllShared(boolean refsOnly) {
        int i = 0;
        while (i < this.nodes.size()) {
            if (!refsOnly && this.isNodeLocal.get(i).booleanValue()) {
                return false;
            }
            if (this.nodes.get(i).getValue().getType() instanceof RefLikeType && this.isNodeLocal.get(i).booleanValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String fieldrefs = "";
        String staticrefs = "";
        String paramrefs = "";
        String thisref = "";
        if (this.nodes.size() == 0) {
            return "Call Locality Context: NO NODES\n";
        }
        int i = 0;
        while (i < this.nodes.size()) {
            Ref r = (Ref)this.nodes.get(i).getValue();
            if (r instanceof InstanceFieldRef) {
                fieldrefs = String.valueOf(fieldrefs) + r + ": " + (this.isNodeLocal.get(i) != false ? "local" : "shared") + "\n";
            } else if (r instanceof StaticFieldRef) {
                staticrefs = String.valueOf(staticrefs) + r + ": " + (this.isNodeLocal.get(i) != false ? "local" : "shared") + "\n";
            } else if (r instanceof ParameterRef) {
                paramrefs = String.valueOf(paramrefs) + r + ": " + (this.isNodeLocal.get(i) != false ? "local" : "shared") + "\n";
            } else if (r instanceof ThisRef) {
                thisref = String.valueOf(thisref) + r + ": " + (this.isNodeLocal.get(i) != false ? "local" : "shared") + "\n";
            } else {
                return "Call Locality Context: HAS STRANGE NODE " + r + "\n";
            }
            ++i;
        }
        return "Call Locality Context: \n" + fieldrefs + paramrefs + thisref + staticrefs;
    }

    public String toShortString() {
        String ret = "[";
        int i = 0;
        while (i < this.nodes.size()) {
            ret = String.valueOf(ret) + (this.isNodeLocal.get(i) != false ? "L" : "S");
            ++i;
        }
        return String.valueOf(ret) + "]";
    }
}

