/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.ArrayList;
import java.util.LinkedList;
import soot.Body;
import soot.ClassMember;
import soot.Hierarchy;
import soot.Local;
import soot.PatchingChain;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

public class AccessManager {
    public static boolean isAccessLegal(SootMethod container2, ClassMember target) {
        SootClass targetClass = target.getDeclaringClass();
        SootClass containerClass = container2.getDeclaringClass();
        if (!AccessManager.isAccessLegal(container2, targetClass)) {
            return false;
        }
        if (target.isPrivate() && !targetClass.getName().equals(containerClass.getName())) {
            return false;
        }
        if (!(target.isPrivate() || target.isProtected() || target.isPublic() || targetClass.getPackageName().equals(containerClass.getPackageName()))) {
            return false;
        }
        if (target.isProtected()) {
            Hierarchy h = Scene.v().getActiveHierarchy();
            return h.isClassSuperclassOfIncluding(targetClass, containerClass);
        }
        return true;
    }

    public static boolean isAccessLegal(SootMethod container2, SootClass target) {
        return target.isPublic() || container2.getDeclaringClass().getPackageName().equals(target.getPackageName());
    }

    public static boolean isAccessLegal(SootMethod container2, Stmt stmt) {
        if (stmt.containsInvokeExpr()) {
            return AccessManager.isAccessLegal(container2, stmt.getInvokeExpr().getMethod());
        }
        if (stmt instanceof AssignStmt) {
            AssignStmt as = (AssignStmt)stmt;
            if (as.getRightOp() instanceof FieldRef) {
                FieldRef r = (FieldRef)as.getRightOp();
                return AccessManager.isAccessLegal(container2, r.getField());
            }
            if (as.getLeftOp() instanceof FieldRef) {
                FieldRef r = (FieldRef)as.getLeftOp();
                return AccessManager.isAccessLegal(container2, r.getField());
            }
        }
        return true;
    }

    public static void createAccessorMethods(Body body, Stmt before, Stmt after) {
        PatchingChain<Unit> units = body.getUnits();
        if (before != null && !units.contains(before)) {
            throw new RuntimeException();
        }
        if (after != null && !units.contains(after)) {
            throw new RuntimeException();
        }
        ArrayList<Unit> unitList = new ArrayList<Unit>();
        unitList.addAll(units);
        boolean bInside = before == null;
        for (Unit unit : unitList) {
            Stmt s = (Stmt)unit;
            if (bInside) {
                if (s == after) {
                    return;
                }
                if (AccessManager.isAccessLegal(body.getMethod(), s)) continue;
                AccessManager.createAccessorMethod(body.getMethod(), s);
                continue;
            }
            if (s != before) continue;
            bInside = true;
        }
    }

    public static String createAccessorName(ClassMember member, boolean setter) {
        SootClass target = member.getDeclaringClass();
        String name = "access$";
        if (member instanceof SootField) {
            SootField f = (SootField)member;
            name = setter ? String.valueOf(name) + "set$" : String.valueOf(name) + "get$";
            name = String.valueOf(name) + f.getName();
        } else {
            SootMethod m = (SootMethod)member;
            name = String.valueOf(name) + m.getName() + "$";
            for (Type type : m.getParameterTypes()) {
                name = String.valueOf(name) + type.toString().replaceAll("\\.", "\\$\\$") + "$";
            }
        }
        return name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createAccessorMethod(SootMethod container2, Stmt stmt) {
        Body containerBody = container2.getActiveBody();
        PatchingChain<Unit> containerStmts = containerBody.getUnits();
        if (!containerStmts.contains(stmt)) {
            throw new RuntimeException();
        }
        if (stmt.containsInvokeExpr()) {
            AccessManager.createInvokeAccessor(container2, stmt);
            return;
        } else {
            if (!(stmt instanceof AssignStmt)) throw new RuntimeException("Expected class member access");
            AssignStmt as = (AssignStmt)stmt;
            if (as.getLeftOp() instanceof FieldRef) {
                FieldRef ref = (FieldRef)as.getLeftOp();
                AccessManager.createSetAccessor(container2, as, ref);
                return;
            } else {
                if (!(as.getRightOp() instanceof FieldRef)) throw new RuntimeException("Expected class member access");
                FieldRef ref = (FieldRef)as.getRightOp();
                AccessManager.createGetAccessor(container2, as, ref);
            }
        }
    }

    private static void createGetAccessor(SootMethod container2, AssignStmt as, FieldRef ref) {
        String name;
        LinkedList<Type> parameterTypes = new LinkedList<Type>();
        LinkedList<SootClass> thrownExceptions = new LinkedList<SootClass>();
        JimpleBody accessorBody = Jimple.v().newBody();
        PatchingChain<Unit> accStmts = accessorBody.getUnits();
        LocalGenerator lg = new LocalGenerator(accessorBody);
        Body containerBody = container2.getActiveBody();
        PatchingChain<Unit> containerStmts = containerBody.getUnits();
        SootClass target = ref.getField().getDeclaringClass();
        SootMethod accessor = target.getMethodByNameUnsafe(name = AccessManager.createAccessorName(ref.getField(), false));
        if (accessor == null) {
            Type returnType = ref.getField().getType();
            Local thisLocal = lg.generateLocal(target.getType());
            if (ref instanceof InstanceFieldRef) {
                parameterTypes.add(target.getType());
                accStmts.addFirst(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newParameterRef(target.getType(), 0)));
            }
            Local l = lg.generateLocal(ref.getField().getType());
            FieldRef v = ref instanceof InstanceFieldRef ? Jimple.v().newInstanceFieldRef(thisLocal, ref.getFieldRef()) : Jimple.v().newStaticFieldRef(ref.getFieldRef());
            accStmts.add(Jimple.v().newAssignStmt(l, v));
            accStmts.add(Jimple.v().newReturnStmt(l));
            accessor = new SootMethod(name, parameterTypes, returnType, 9, thrownExceptions);
            accessorBody.setMethod(accessor);
            accessor.setActiveBody(accessorBody);
            target.addMethod(accessor);
        }
        LinkedList<Value> args = new LinkedList<Value>();
        if (ref instanceof InstanceFieldRef) {
            args.add(((InstanceFieldRef)ref).getBase());
        }
        StaticInvokeExpr newExpr = Jimple.v().newStaticInvokeExpr(accessor.makeRef(), args);
        as.setRightOp(newExpr);
    }

    private static void createSetAccessor(SootMethod container2, AssignStmt as, FieldRef ref) {
        String name;
        LinkedList<Type> parameterTypes = new LinkedList<Type>();
        LinkedList<SootClass> thrownExceptions = new LinkedList<SootClass>();
        JimpleBody accessorBody = Jimple.v().newBody();
        PatchingChain<Unit> accStmts = accessorBody.getUnits();
        LocalGenerator lg = new LocalGenerator(accessorBody);
        Body containerBody = container2.getActiveBody();
        PatchingChain<Unit> containerStmts = containerBody.getUnits();
        SootClass target = ref.getField().getDeclaringClass();
        SootMethod accessor = target.getMethodByNameUnsafe(name = AccessManager.createAccessorName(ref.getField(), true));
        if (accessor == null) {
            Local thisLocal = lg.generateLocal(target.getType());
            int paramID = 0;
            if (ref instanceof InstanceFieldRef) {
                accStmts.add(Jimple.v().newIdentityStmt(thisLocal, Jimple.v().newParameterRef(target.getType(), paramID)));
                parameterTypes.add(target.getType());
                ++paramID;
            }
            parameterTypes.add(ref.getField().getType());
            Local l = lg.generateLocal(ref.getField().getType());
            accStmts.add(Jimple.v().newIdentityStmt(l, Jimple.v().newParameterRef(ref.getField().getType(), paramID)));
            ++paramID;
            if (ref instanceof InstanceFieldRef) {
                accStmts.add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(thisLocal, ref.getFieldRef()), l));
            } else {
                accStmts.add(Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(ref.getFieldRef()), l));
            }
            accStmts.addLast(Jimple.v().newReturnVoidStmt());
            VoidType returnType = VoidType.v();
            accessor = new SootMethod(name, parameterTypes, returnType, 9, thrownExceptions);
            accessorBody.setMethod(accessor);
            accessor.setActiveBody(accessorBody);
            target.addMethod(accessor);
        }
        LinkedList<Value> args = new LinkedList<Value>();
        if (ref instanceof InstanceFieldRef) {
            args.add(((InstanceFieldRef)ref).getBase());
        }
        args.add(as.getRightOp());
        StaticInvokeExpr newExpr = Jimple.v().newStaticInvokeExpr(accessor.makeRef(), args);
        InvokeStmt newStmt = Jimple.v().newInvokeStmt(newExpr);
        containerStmts.insertAfter(newStmt, (Unit)as);
        containerStmts.remove(as);
    }

    private static void createInvokeAccessor(SootMethod container2, Stmt stmt) {
        String name;
        LinkedList<Type> parameterTypes = new LinkedList<Type>();
        LinkedList<SootClass> thrownExceptions = new LinkedList<SootClass>();
        JimpleBody accessorBody = Jimple.v().newBody();
        PatchingChain<Unit> accStmts = accessorBody.getUnits();
        LocalGenerator lg = new LocalGenerator(accessorBody);
        Body containerBody = container2.getActiveBody();
        PatchingChain<Unit> containerStmts = containerBody.getUnits();
        InvokeExpr expr = stmt.getInvokeExpr();
        SootMethod method = expr.getMethod();
        SootClass target = method.getDeclaringClass();
        SootMethod accessor = target.getMethodByNameUnsafe(name = AccessManager.createAccessorName(method, true));
        if (accessor == null) {
            Stmt s;
            Local thisLocal;
            InvokeExpr accExpr;
            LinkedList<Local> arguments = new LinkedList<Local>();
            if (expr instanceof InstanceInvokeExpr) {
                parameterTypes.add(target.getType());
            }
            parameterTypes.addAll(method.getParameterTypes());
            Type returnType = method.getReturnType();
            thrownExceptions.addAll(method.getExceptions());
            int paramID = 0;
            for (Type type : parameterTypes) {
                Local l = lg.generateLocal(type);
                accStmts.add(Jimple.v().newIdentityStmt(l, Jimple.v().newParameterRef(type, paramID)));
                arguments.add(l);
                ++paramID;
            }
            if (expr instanceof StaticInvokeExpr) {
                accExpr = Jimple.v().newStaticInvokeExpr(method.makeRef(), arguments);
            } else if (expr instanceof VirtualInvokeExpr) {
                thisLocal = (Local)arguments.get(0);
                arguments.remove(0);
                accExpr = Jimple.v().newVirtualInvokeExpr(thisLocal, method.makeRef(), arguments);
            } else if (expr instanceof SpecialInvokeExpr) {
                thisLocal = (Local)arguments.get(0);
                arguments.remove(0);
                accExpr = Jimple.v().newSpecialInvokeExpr(thisLocal, method.makeRef(), arguments);
            } else {
                throw new RuntimeException("");
            }
            if (returnType instanceof VoidType) {
                s = Jimple.v().newInvokeStmt(accExpr);
                accStmts.add(s);
                accStmts.add(Jimple.v().newReturnVoidStmt());
            } else {
                Local resultLocal = lg.generateLocal(returnType);
                s = Jimple.v().newAssignStmt(resultLocal, accExpr);
                accStmts.add(s);
                accStmts.add(Jimple.v().newReturnStmt(resultLocal));
            }
            accessor = new SootMethod(name, parameterTypes, returnType, 9, thrownExceptions);
            accessorBody.setMethod(accessor);
            accessor.setActiveBody(accessorBody);
            target.addMethod(accessor);
        }
        LinkedList<Value> args = new LinkedList<Value>();
        if (expr instanceof InstanceInvokeExpr) {
            args.add(((InstanceInvokeExpr)expr).getBase());
        }
        args.addAll(expr.getArgs());
        StaticInvokeExpr newExpr = Jimple.v().newStaticInvokeExpr(accessor.makeRef(), args);
        stmt.getInvokeExprBox().setValue(newExpr);
    }

    public static boolean ensureAccess(SootMethod container2, ClassMember target, String options) {
        boolean accessors = options.equals("accessors");
        boolean allowChanges = !options.equals("none");
        boolean safeChangesOnly = !options.equals("unsafe");
        SootClass targetClass = target.getDeclaringClass();
        if (!AccessManager.ensureAccess(container2, targetClass, options)) {
            return false;
        }
        if (AccessManager.isAccessLegal(container2, target)) {
            return true;
        }
        if (!allowChanges && !accessors) {
            return false;
        }
        if (target.getDeclaringClass().isApplicationClass()) {
            if (accessors) {
                return true;
            }
            if (safeChangesOnly) {
                throw new RuntimeException("Not implemented yet!");
            }
            target.setModifiers(target.getModifiers() | 1);
            return true;
        }
        return false;
    }

    public static boolean ensureAccess(SootMethod container2, SootClass target, String options) {
        boolean safeChangesOnly;
        boolean accessors = options.equals("accessors");
        boolean allowChanges = !options.equals("none");
        boolean bl = safeChangesOnly = !options.equals("unsafe");
        if (AccessManager.isAccessLegal(container2, target)) {
            return true;
        }
        if (!allowChanges && !accessors) {
            return false;
        }
        if (safeChangesOnly && !accessors) {
            throw new RuntimeException("Not implemented yet!");
        }
        if (accessors) {
            return false;
        }
        if (target.isApplicationClass()) {
            target.setModifiers(target.getModifiers() | 1);
            return true;
        }
        return false;
    }
}

