/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Hierarchy;
import soot.Local;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.TrapManager;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.invoke.SynchronizerManager;
import soot.jimple.toolkits.invoke.ThrowManager;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;

public class SiteInliner {
    public String getDefaultOptions() {
        return "insert-null-checks insert-redundant-casts";
    }

    public static void inlineSites(List sites) {
        SiteInliner.inlineSites(sites, new HashMap());
    }

    public static void inlineSites(List sites, Map options) {
        for (List l : sites) {
            SootMethod inlinee = (SootMethod)l.get(0);
            Stmt toInline = (Stmt)l.get(1);
            SootMethod container2 = (SootMethod)l.get(2);
            SiteInliner.inlineSite(inlinee, toInline, container2, options);
        }
    }

    public static void inlineSite(SootMethod inlinee, Stmt toInline, SootMethod container2) {
        SiteInliner.inlineSite(inlinee, toInline, container2, new HashMap());
    }

    public static List inlineSite(SootMethod inlinee, Stmt toInline, SootMethod container2, Map options) {
        boolean enableNullPointerCheckInsertion = PhaseOptions.getBoolean(options, "insert-null-checks");
        boolean enableRedundantCastInsertion = PhaseOptions.getBoolean(options, "insert-redundant-casts");
        Hierarchy hierarchy = Scene.v().getActiveHierarchy();
        JimpleBody containerB = (JimpleBody)container2.getActiveBody();
        PatchingChain<Unit> containerUnits = containerB.getUnits();
        if (!inlinee.getDeclaringClass().isApplicationClass() && !inlinee.getDeclaringClass().isLibraryClass()) {
            return null;
        }
        Body inlineeB = inlinee.getActiveBody();
        PatchingChain<Unit> inlineeUnits = inlineeB.getUnits();
        InvokeExpr ie = toInline.getInvokeExpr();
        Value thisToAdd = null;
        if (ie instanceof InstanceInvokeExpr) {
            thisToAdd = ((InstanceInvokeExpr)ie).getBase();
        }
        boolean targetUsesThis = true;
        if (enableRedundantCastInsertion && ie instanceof InstanceInvokeExpr && targetUsesThis) {
            SootClass localType = ((RefType)((InstanceInvokeExpr)ie).getBase().getType()).getSootClass();
            SootClass parameterType = inlinee.getDeclaringClass();
            if (localType.isInterface() || hierarchy.isClassSuperclassOf(localType, parameterType)) {
                Local castee = Jimple.v().newLocal("__castee", parameterType.getType());
                containerB.getLocals().add(castee);
                containerB.getUnits().insertBefore(Jimple.v().newAssignStmt(castee, Jimple.v().newCastExpr(((InstanceInvokeExpr)ie).getBase(), parameterType.getType())), (Unit)toInline);
                thisToAdd = castee;
            }
        }
        if (enableNullPointerCheckInsertion && ie instanceof InstanceInvokeExpr) {
            boolean caught = TrapManager.isExceptionCaughtAt(Scene.v().getSootClass("java.lang.NullPointerException"), toInline, containerB);
            if (caught) {
                IfStmt insertee = Jimple.v().newIfStmt((Value)Jimple.v().newNeExpr(((InstanceInvokeExpr)ie).getBase(), NullConstant.v()), toInline);
                containerB.getUnits().insertBefore(insertee, (Unit)toInline);
                insertee.setTarget(toInline);
                ThrowManager.addThrowAfter(containerB, insertee);
            } else {
                Stmt throwPoint = ThrowManager.getNullPointerExceptionThrower(containerB);
                containerB.getUnits().insertBefore(Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(((InstanceInvokeExpr)ie).getBase(), NullConstant.v()), throwPoint), (Unit)toInline);
            }
        }
        if (inlinee.isSynchronized()) {
            if (ie instanceof InstanceInvokeExpr) {
                SynchronizerManager.v().synchronizeStmtOn(toInline, containerB, (Local)((InstanceInvokeExpr)ie).getBase());
            } else if (!container2.getDeclaringClass().isInterface()) {
                Local l = SynchronizerManager.v().addStmtsToFetchClassBefore(containerB, toInline);
                SynchronizerManager.v().synchronizeStmtOn(toInline, containerB, l);
            }
        }
        Stmt exitPoint = (Stmt)containerUnits.getSuccOf(toInline);
        HashMap<Local, Local> oldLocalsToNew = new HashMap<Local, Local>();
        HashMap<Stmt, Stmt> oldUnitsToNew = new HashMap<Stmt, Stmt>();
        Stmt cursor = toInline;
        for (Stmt stmt : inlineeUnits) {
            Stmt currPrime = (Stmt)stmt.clone();
            if (currPrime == null) {
                throw new RuntimeException("getting null from clone!");
            }
            currPrime.addAllTagsOf(stmt);
            containerUnits.insertAfter(currPrime, (Unit)cursor);
            cursor = currPrime;
            oldUnitsToNew.put(stmt, currPrime);
        }
        for (Local local : inlineeB.getLocals()) {
            Local lPrime = (Local)local.clone();
            if (lPrime == null) {
                throw new RuntimeException("getting null from local clone!");
            }
            containerB.getLocals().add(lPrime);
            oldLocalsToNew.put(local, lPrime);
        }
        Iterator<Unit> it = containerUnits.iterator(containerUnits.getSuccOf(toInline), containerUnits.getPredOf(exitPoint));
        while (it.hasNext()) {
            Stmt patchee = (Stmt)it.next();
            for (ValueBox valueBox : patchee.getUseAndDefBoxes()) {
                if (!(valueBox.getValue() instanceof Local)) continue;
                Local lPrime = (Local)oldLocalsToNew.get(valueBox.getValue());
                if (lPrime != null) {
                    valueBox.setValue(lPrime);
                    continue;
                }
                throw new RuntimeException("local has no clone!");
            }
            for (UnitBox unitBox : patchee.getUnitBoxes()) {
                Unit uPrime = (Unit)oldUnitsToNew.get(unitBox.getUnit());
                if (uPrime != null) {
                    unitBox.setUnit(uPrime);
                    continue;
                }
                throw new RuntimeException("inlined stmt has no clone!");
            }
        }
        Trap prevTrap = null;
        for (Trap t : inlineeB.getTraps()) {
            Stmt newBegin = (Stmt)oldUnitsToNew.get(t.getBeginUnit());
            Stmt newEnd = (Stmt)oldUnitsToNew.get(t.getEndUnit());
            Stmt newHandler = (Stmt)oldUnitsToNew.get(t.getHandlerUnit());
            if (newBegin == null || newEnd == null || newHandler == null) {
                throw new RuntimeException("couldn't map trap!");
            }
            Trap trap = Jimple.v().newTrap(t.getException(), newBegin, newEnd, newHandler);
            if (prevTrap == null) {
                containerB.getTraps().addFirst(trap);
            } else {
                containerB.getTraps().insertAfter(trap, prevTrap);
            }
            prevTrap = trap;
        }
        it = containerUnits.iterator(containerUnits.getSuccOf(toInline), containerUnits.getPredOf(exitPoint));
        ArrayList<Unit> cuCopy = new ArrayList<Unit>();
        while (it.hasNext()) {
            cuCopy.add(it.next());
        }
        for (Unit unit : cuCopy) {
            Stmt s = (Stmt)unit;
            if (s instanceof IdentityStmt) {
                IdentityRef rhs = (IdentityRef)((IdentityStmt)s).getRightOp();
                if (rhs instanceof CaughtExceptionRef) continue;
                if (rhs instanceof ThisRef) {
                    if (!(ie instanceof InstanceInvokeExpr)) {
                        throw new RuntimeException("thisref with no receiver!");
                    }
                    containerUnits.swapWith(s, Jimple.v().newAssignStmt(((IdentityStmt)s).getLeftOp(), thisToAdd));
                    continue;
                }
                if (!(rhs instanceof ParameterRef)) continue;
                ParameterRef pref = (ParameterRef)rhs;
                containerUnits.swapWith(s, Jimple.v().newAssignStmt(((IdentityStmt)s).getLeftOp(), ie.getArg(pref.getIndex())));
                continue;
            }
            if (s instanceof ReturnStmt) {
                if (toInline instanceof InvokeStmt) {
                    containerUnits.swapWith(s, Jimple.v().newGotoStmt(exitPoint));
                    continue;
                }
                if (!(toInline instanceof AssignStmt)) {
                    throw new RuntimeException("invoking stmt neither InvokeStmt nor AssignStmt!??!?!");
                }
                Value ro = ((ReturnStmt)s).getOp();
                Value lhs = ((AssignStmt)toInline).getLeftOp();
                AssignStmt as = Jimple.v().newAssignStmt(lhs, ro);
                containerUnits.insertBefore(as, (Unit)s);
                containerUnits.swapWith(s, Jimple.v().newGotoStmt(exitPoint));
                continue;
            }
            if (!(s instanceof ReturnVoidStmt)) continue;
            containerUnits.swapWith(s, Jimple.v().newGotoStmt(exitPoint));
        }
        ArrayList<Unit> newStmts = new ArrayList<Unit>();
        Iterator<Unit> i = containerUnits.iterator(containerUnits.getSuccOf(toInline), containerUnits.getPredOf(exitPoint));
        while (i.hasNext()) {
            newStmts.add(i.next());
        }
        containerUnits.remove(toInline);
        LocalNameStandardizer.v().transform(containerB, "ji.lns");
        return newStmts;
    }
}

