/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.BitSet;
import java.util.List;
import soot.FastHierarchy;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.Type;

class LocalTypeSet
extends BitSet {
    protected List<Local> locals;
    protected List<Type> types;

    public LocalTypeSet(List<Local> locals, List<Type> types) {
        super(locals.size() * types.size());
        this.locals = locals;
        this.types = types;
        if (!Scene.v().hasFastHierarchy()) {
            Scene.v().setFastHierarchy(new FastHierarchy());
        }
    }

    protected int indexOf(Local l, RefType t) {
        if (this.locals.indexOf(l) == -1 || this.types.indexOf(t) == -1) {
            throw new RuntimeException("Invalid local or type in LocalTypeSet");
        }
        return this.locals.indexOf(l) * this.types.size() + this.types.indexOf(t);
    }

    public void killLocal(Local l) {
        int base = this.types.size() * this.locals.indexOf(l);
        int i = 0;
        while (i < this.types.size()) {
            this.clear(i + base);
            ++i;
        }
    }

    public void localCopy(Local to, Local from) {
        int baseTo = this.types.size() * this.locals.indexOf(to);
        int baseFrom = this.types.size() * this.locals.indexOf(from);
        int i = 0;
        while (i < this.types.size()) {
            if (this.get(i + baseFrom)) {
                this.set(i + baseTo);
            } else {
                this.clear(i + baseTo);
            }
            ++i;
        }
    }

    public void clearAllBits() {
        int i = 0;
        while (i < this.types.size() * this.locals.size()) {
            this.clear(i);
            ++i;
        }
    }

    public void setAllBits() {
        int i = 0;
        while (i < this.types.size() * this.locals.size()) {
            this.set(i);
            ++i;
        }
    }

    public void localMustBeSubtypeOf(Local l, RefType t) {
        FastHierarchy fh = Scene.v().getFastHierarchy();
        for (Type type : this.types) {
            RefType supertype = (RefType)type;
            if (!fh.canStoreType(t, supertype)) continue;
            this.set(this.indexOf(l, supertype));
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Local l : this.locals) {
            for (RefType refType : this.types) {
                int index = this.indexOf(l, refType);
                if (!this.get(index)) continue;
                sb.append("((" + l + "," + refType + ") -> elim cast check) ");
            }
        }
        return sb.toString();
    }
}

