/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PatchingChain;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.StmtBody;
import soot.jimple.toolkits.scalar.Evaluator;
import soot.options.Options;

public class ConditionalBranchFolder
extends BodyTransformer {
    public ConditionalBranchFolder(Singletons.Global g) {
    }

    public static ConditionalBranchFolder v() {
        return G.v().soot_jimple_toolkits_scalar_ConditionalBranchFolder();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        StmtBody stmtBody = (StmtBody)body;
        int numTrue = 0;
        int numFalse = 0;
        if (Options.v().verbose()) {
            G.v().out.println("[" + stmtBody.getMethod().getName() + "] Folding conditional branches...");
        }
        PatchingChain<Unit> units = stmtBody.getUnits();
        Unit[] unitArray = units.toArray(new Unit[units.size()]);
        int n = unitArray.length;
        int n2 = 0;
        while (n2 < n) {
            IfStmt ifs;
            Value cond;
            Unit stmt = unitArray[n2];
            if (stmt instanceof IfStmt && Evaluator.isValueConstantValued(cond = (ifs = (IfStmt)stmt).getCondition())) {
                cond = Evaluator.getConstantValueOf(cond);
                if (((IntConstant)cond).value == 1) {
                    GotoStmt newStmt = Jimple.v().newGotoStmt(ifs.getTarget());
                    units.insertAfter(newStmt, stmt);
                    ++numTrue;
                } else {
                    ++numFalse;
                }
                units.remove(stmt);
            }
            ++n2;
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + stmtBody.getMethod().getName() + "]     Folded " + numTrue + " true, " + numFalse + " conditional branches");
        }
    }
}

