/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp.pegcallgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.MethodOrMethodContext;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.DirectedGraph;
import soot.util.Chain;
import soot.util.HashChain;

public class PegCallGraph
implements DirectedGraph {
    List heads;
    List tails;
    Chain chain;
    private final Map<Object, List> methodToSuccs;
    private final Map<Object, List> methodToPreds;
    private final Map<Object, List> methodToSuccsTrim;
    private final Set clinitMethods = new HashSet();

    public PegCallGraph(CallGraph cg) {
        this.chain = new HashChain();
        this.heads = new ArrayList();
        this.tails = new ArrayList();
        this.methodToSuccs = new HashMap<Object, List>();
        this.methodToPreds = new HashMap<Object, List>();
        this.methodToSuccsTrim = new HashMap<Object, List>();
        this.buildChainAndSuccs(cg);
        this.buildPreds();
    }

    protected void testChain() {
        System.out.println("******** chain of pegcallgraph********");
        for (SootMethod sm : this.chain) {
            System.out.println(sm);
        }
    }

    public Set getClinitMethods() {
        return this.clinitMethods;
    }

    private void buildChainAndSuccs(CallGraph cg) {
        Iterator<MethodOrMethodContext> it = cg.sourceMethods();
        while (it.hasNext()) {
            SootMethod sm = (SootMethod)it.next();
            if (sm.getName().equals("main")) {
                this.heads.add(sm);
            }
            if (!sm.isConcrete() || !sm.getDeclaringClass().isApplicationClass()) continue;
            if (!this.chain.contains(sm)) {
                this.chain.add(sm);
            }
            ArrayList<SootMethod> succsList = new ArrayList<SootMethod>();
            Iterator<Edge> edgeIt = cg.edgesOutOf(sm);
            while (edgeIt.hasNext()) {
                Edge edge = edgeIt.next();
                SootMethod target = edge.tgt();
                if (!target.isConcrete() || !target.getDeclaringClass().isApplicationClass()) continue;
                succsList.add(target);
                if (!this.chain.contains(target)) {
                    this.chain.add(target);
                }
                if (!edge.isClinit()) continue;
                this.clinitMethods.add(target);
            }
            if (succsList.size() <= 0) continue;
            this.methodToSuccs.put(sm, succsList);
        }
        for (SootMethod sm : this.chain) {
            if (this.methodToSuccs.containsKey(sm)) continue;
            this.methodToSuccs.put(sm, new ArrayList());
        }
        Iterator chainIt = this.chain.iterator();
        while (it.hasNext()) {
            SootMethod s = (SootMethod)chainIt.next();
            if (!this.methodToSuccs.containsKey(s)) continue;
            List succList = this.methodToSuccs.get(s);
            succList.size();
        }
        for (SootMethod s : this.chain) {
            if (!this.methodToSuccs.containsKey(s)) continue;
            this.methodToSuccs.put(s, Collections.unmodifiableList(this.methodToSuccs.get(s)));
        }
    }

    private void buildPreds() {
        Iterator unitIt = this.chain.iterator();
        while (unitIt.hasNext()) {
            this.methodToPreds.put(unitIt.next(), new ArrayList());
        }
        for (Object s : this.chain) {
            List succList = this.methodToSuccs.get(s);
            if (succList.size() <= 0) continue;
            for (Object successor : succList) {
                List predList = this.methodToPreds.get(successor);
                try {
                    predList.add(s);
                }
                catch (NullPointerException e) {
                    System.out.println(s + "successor: " + successor);
                    throw e;
                }
            }
        }
        for (Object s : this.chain) {
            if (!this.methodToPreds.containsKey(s)) continue;
            List predList = this.methodToPreds.get(s);
            this.methodToPreds.put(s, Collections.unmodifiableList(predList));
        }
    }

    public void trim() {
        Set<Map.Entry<Object, List>> maps = this.methodToSuccs.entrySet();
        for (Map.Entry<Object, List> entry : maps) {
            List list = entry.getValue();
            ArrayList newList = new ArrayList();
            for (Object obj : list) {
                if (list.contains(obj)) continue;
                newList.add(obj);
            }
            this.methodToSuccsTrim.put(entry.getKey(), newList);
        }
    }

    public List getHeads() {
        return this.heads;
    }

    public List getTails() {
        return this.tails;
    }

    public List getTrimSuccsOf(Object s) {
        if (!this.methodToSuccsTrim.containsKey(s)) {
            return Collections.EMPTY_LIST;
        }
        return this.methodToSuccsTrim.get(s);
    }

    public List getSuccsOf(Object s) {
        if (!this.methodToSuccs.containsKey(s)) {
            return Collections.EMPTY_LIST;
        }
        return this.methodToSuccs.get(s);
    }

    public List getPredsOf(Object s) {
        if (!this.methodToPreds.containsKey(s)) {
            return Collections.EMPTY_LIST;
        }
        return this.methodToPreds.get(s);
    }

    @Override
    public Iterator iterator() {
        return this.chain.iterator();
    }

    @Override
    public int size() {
        return this.chain.size();
    }

    protected void testMethodToSucc() {
        System.out.println("=====test methodToSucc ");
        Set<Map.Entry<Object, List>> maps = this.methodToSuccs.entrySet();
        for (Map.Entry<Object, List> entry : maps) {
            System.out.println("---key=  " + entry.getKey());
            List list = entry.getValue();
            if (list.size() <= 0) continue;
            System.out.println("**succ set:");
            Iterator it = list.iterator();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
        }
        System.out.println("=========methodToSucc--ends--------");
    }

    protected void testMethodToPred() {
        System.out.println("=====test methodToPred ");
        Set<Map.Entry<Object, List>> maps = this.methodToPreds.entrySet();
        for (Map.Entry<Object, List> entry : maps) {
            System.out.println("---key=  " + entry.getKey());
            List list = entry.getValue();
            if (list.size() <= 0) continue;
            System.out.println("**pred set:");
            Iterator it = list.iterator();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
        }
        System.out.println("=========methodToPred--ends--------");
    }
}

