/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

public class Base64 {
    private static final char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static final byte[] codes = new byte[256];

    static {
        int i = 0;
        while (i < 256) {
            Base64.codes[i] = -1;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            Base64.codes[i] = (byte)(i - 65);
            ++i;
        }
        i = 97;
        while (i <= 122) {
            Base64.codes[i] = (byte)(26 + i - 97);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            Base64.codes[i] = (byte)(52 + i - 48);
            ++i;
        }
        Base64.codes[43] = 62;
        Base64.codes[47] = 63;
    }

    public static char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    public static byte[] decode(char[] data) {
        int tempLen = data.length;
        char[] cArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            if (element > '\u00ff' || codes[element] < 0) {
                --tempLen;
            }
            ++n2;
        }
        int len = tempLen / 4 * 3;
        if (tempLen % 4 == 3) {
            len += 2;
        }
        if (tempLen % 4 == 2) {
            ++len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        char[] cArray2 = data;
        int n3 = data.length;
        int n4 = 0;
        while (n4 < n3) {
            int value;
            char element = cArray2[n4];
            int n5 = value = element > '\u00ff' ? -1 : codes[element];
            if (value >= 0) {
                accum <<= 6;
                accum |= value;
                if ((shift += 6) >= 8) {
                    out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
                }
            }
            ++n4;
        }
        if (index != out.length) {
            throw new Error("Miscalculated data length (wrote " + index + " instead of " + out.length + ")");
        }
        return out;
    }
}

