/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex.instructions;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import soot.toDex.LabelAssigner;
import soot.toDex.Register;
import soot.toDex.SootToDexUtils;
import soot.toDex.instructions.Insn;

public abstract class AbstractInsn
implements Insn {
    protected Opcode opc;
    protected List<Register> regs;

    public AbstractInsn(Opcode opc) {
        if (opc == null) {
            throw new IllegalArgumentException("opcode must not be null");
        }
        this.opc = opc;
        this.regs = new ArrayList<Register>();
    }

    @Override
    public Opcode getOpcode() {
        return this.opc;
    }

    @Override
    public List<Register> getRegs() {
        return this.regs;
    }

    @Override
    public BitSet getIncompatibleRegs() {
        return new BitSet(0);
    }

    @Override
    public boolean hasIncompatibleRegs() {
        return this.getIncompatibleRegs().cardinality() > 0;
    }

    @Override
    public int getMinimumRegsNeeded() {
        BitSet incompatRegs = this.getIncompatibleRegs();
        int resultNeed = 0;
        int miscRegsNeed = 0;
        boolean hasResult = this.opc.setsRegister();
        if (hasResult && incompatRegs.get(0)) {
            resultNeed = SootToDexUtils.getDexWords(this.regs.get(0).getType());
        }
        int i = hasResult ? 1 : 0;
        while (i < this.regs.size()) {
            if (incompatRegs.get(i)) {
                miscRegsNeed += SootToDexUtils.getDexWords(this.regs.get(i).getType());
            }
            ++i;
        }
        if (this.opc.name.endsWith("/2addr")) {
            return resultNeed + miscRegsNeed;
        }
        return Math.max(resultNeed, miscRegsNeed);
    }

    @Override
    public BuilderInstruction getRealInsn(LabelAssigner assigner) {
        if (this.hasIncompatibleRegs()) {
            throw new RuntimeException("the instruction still has incompatible registers: " + this.getIncompatibleRegs());
        }
        return this.getRealInsn0(assigner);
    }

    protected abstract BuilderInstruction getRealInsn0(LabelAssigner var1);

    public String toString() {
        return String.valueOf(this.opc.toString()) + " " + this.regs;
    }

    @Override
    public int getSize() {
        return this.opc.format.size / 2;
    }
}

