/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex.instructions;

import java.util.BitSet;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.instruction.BuilderInstruction22b;
import soot.toDex.LabelAssigner;
import soot.toDex.Register;
import soot.toDex.instructions.AbstractInsn;
import soot.toDex.instructions.TwoRegInsn;

public class Insn22b
extends AbstractInsn
implements TwoRegInsn {
    private byte litC;

    public Insn22b(Opcode opc, Register regA, Register regB, byte litC) {
        super(opc);
        this.regs.add(regA);
        this.regs.add(regB);
        this.litC = litC;
    }

    @Override
    public Register getRegA() {
        return (Register)this.regs.get(0);
    }

    @Override
    public Register getRegB() {
        return (Register)this.regs.get(1);
    }

    public byte getLitC() {
        return this.litC;
    }

    @Override
    protected BuilderInstruction getRealInsn0(LabelAssigner assigner) {
        return new BuilderInstruction22b(this.opc, (short)this.getRegA().getNumber(), (short)this.getRegB().getNumber(), this.getLitC());
    }

    @Override
    public BitSet getIncompatibleRegs() {
        BitSet incompatRegs = new BitSet(2);
        if (!this.getRegA().fitsShort()) {
            incompatRegs.set(0);
        }
        if (!this.getRegB().fitsShort()) {
            incompatRegs.set(1);
        }
        return incompatRegs;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " lit: " + this.getLitC();
    }
}

