/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.DominatorsFinder;

public class MHGDominatorsFinder<N>
implements DominatorsFinder<N> {
    protected DirectedGraph<N> graph;
    protected BitSet fullSet;
    protected List<N> heads;
    protected Map<N, BitSet> nodeToFlowSet;
    protected Map<N, Integer> nodeToIndex;
    protected Map<Integer, N> indexToNode;
    protected int lastIndex = 0;

    public MHGDominatorsFinder(DirectedGraph<N> graph) {
        this.graph = graph;
        this.doAnalysis();
    }

    protected void doAnalysis() {
        this.heads = this.graph.getHeads();
        this.nodeToFlowSet = new HashMap<N, BitSet>();
        this.nodeToIndex = new HashMap<N, Integer>();
        this.indexToNode = new HashMap<Integer, N>();
        this.fullSet = new BitSet(this.graph.size());
        this.fullSet.flip(0, this.graph.size());
        for (N o : this.graph) {
            if (this.heads.contains(o)) {
                BitSet self = new BitSet();
                self.set(this.indexOf(o));
                this.nodeToFlowSet.put(o, self);
                continue;
            }
            this.nodeToFlowSet.put(o, this.fullSet);
        }
        boolean changed = true;
        do {
            changed = false;
            for (N o : this.graph) {
                if (this.heads.contains(o)) continue;
                BitSet predsIntersect = (BitSet)this.fullSet.clone();
                Iterator<N> j = this.graph.getPredsOf(o).iterator();
                while (j.hasNext()) {
                    BitSet predSet = this.nodeToFlowSet.get(j.next());
                    predsIntersect.and(predSet);
                }
                BitSet oldSet = this.nodeToFlowSet.get(o);
                predsIntersect.set(this.indexOf(o));
                if (predsIntersect.equals(oldSet)) continue;
                this.nodeToFlowSet.put(o, predsIntersect);
                changed = true;
            }
        } while (changed);
    }

    protected int indexOf(N o) {
        Integer index = this.nodeToIndex.get(o);
        if (index == null) {
            index = this.lastIndex;
            this.nodeToIndex.put(o, index);
            this.indexToNode.put(index, o);
            ++this.lastIndex;
        }
        return index;
    }

    @Override
    public DirectedGraph<N> getGraph() {
        return this.graph;
    }

    @Override
    public List<N> getDominators(N node) {
        ArrayList<N> result = new ArrayList<N>();
        BitSet bitSet = this.nodeToFlowSet.get(node);
        int i = 0;
        while (i < bitSet.length()) {
            if (bitSet.get(i)) {
                result.add(this.indexToNode.get(i));
            }
            ++i;
        }
        return result;
    }

    @Override
    public N getImmediateDominator(N node) {
        if (this.getGraph().getHeads().contains(node)) {
            return null;
        }
        List<N> dominatorsList = this.getDominators(node);
        dominatorsList.remove(node);
        Iterator<N> dominatorsIt = dominatorsList.iterator();
        N immediateDominator = null;
        while (immediateDominator == null && dominatorsIt.hasNext()) {
            N dominator = dominatorsIt.next();
            if (!this.isDominatedByAll(dominator, dominatorsList)) continue;
            immediateDominator = dominator;
        }
        return immediateDominator;
    }

    @Override
    public boolean isDominatedBy(N node, N dominator) {
        return this.getDominators(node).contains(dominator);
    }

    @Override
    public boolean isDominatedByAll(N node, Collection<N> dominators) {
        return this.getDominators(node).containsAll(dominators);
    }
}

