/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.Orderer;

public class PseudoTopologicalOrderer<N>
implements Orderer<N> {
    public static final boolean REVERSE = true;
    private Set<N> visited;
    private int[] indexStack;
    private N[] stmtStack;
    private N[] order;
    private int orderLength;
    private boolean mIsReversed = false;
    private DirectedGraph<N> graph;

    public PseudoTopologicalOrderer() {
    }

    private static <T> void reverseArray(T[] array) {
        int max = array.length >> 1;
        int i = 0;
        int j = array.length - 1;
        while (i < max) {
            T temp = array[i];
            array[i] = array[j];
            array[j] = temp;
            ++i;
            --j;
        }
    }

    @Override
    public List<N> newList(DirectedGraph<N> g, boolean reverse) {
        this.mIsReversed = reverse;
        return this.computeOrder(g, !this.mIsReversed);
    }

    protected final List<N> computeOrder(DirectedGraph<N> g, boolean reverse) {
        int n = g.size();
        this.visited = Collections.newSetFromMap(new IdentityHashMap(n * 2 + 1));
        this.indexStack = new int[n];
        this.stmtStack = new Object[n];
        this.order = new Object[n];
        this.graph = g;
        this.orderLength = 0;
        for (N s : g) {
            if (this.visited.add(s)) {
                this.visitNode(s);
            }
            if (this.orderLength == n) break;
        }
        if (reverse) {
            PseudoTopologicalOrderer.reverseArray(this.order);
        }
        List<N> o = Arrays.asList(this.order);
        this.indexStack = null;
        this.stmtStack = null;
        this.visited = null;
        this.order = null;
        return o;
    }

    protected final void visitNode(N startStmt) {
        int last = 0;
        this.stmtStack[last] = startStmt;
        this.indexStack[last++] = -1;
        while (last > 0) {
            int n = last - 1;
            this.indexStack[n] = this.indexStack[n] + 1;
            int toVisitIndex = this.indexStack[n];
            N toVisitNode = this.stmtStack[last - 1];
            List<N> succs = this.graph.getSuccsOf(toVisitNode);
            if (toVisitIndex >= succs.size()) {
                this.order[this.orderLength++] = toVisitNode;
                --last;
                continue;
            }
            N childNode = succs.get(toVisitIndex);
            if (!this.visited.add(childNode)) continue;
            this.stmtStack[last] = childNode;
            this.indexStack[last++] = -1;
        }
    }

    @Deprecated
    public PseudoTopologicalOrderer(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    @Deprecated
    public List<N> newList(DirectedGraph<N> g) {
        return this.computeOrder(g, !this.mIsReversed);
    }

    @Deprecated
    public void setReverseOrder(boolean isReversed) {
        this.mIsReversed = isReversed;
    }

    @Deprecated
    public boolean isReverseOrder() {
        return this.mIsReversed;
    }
}

