/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph.pdg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.PatchingChain;
import soot.Trap;
import soot.Unit;
import soot.jimple.ThrowStmt;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.MHGDominatorsFinder;
import soot.toolkits.graph.MHGPostDominatorsFinder;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.graph.pdg.EHNopStmt;
import soot.toolkits.graph.pdg.ExitStmt;
import soot.toolkits.graph.pdg.MHGDominatorTree;
import soot.util.Chain;

public class EnhancedUnitGraph
extends UnitGraph {
    protected Hashtable<Unit, Unit> try2nop = new Hashtable();
    protected Hashtable<Unit, Unit> handler2header = new Hashtable();

    public EnhancedUnitGraph(Body body) {
        super(body);
        int size = this.unitChain.size() + body.getTraps().size() + 2;
        this.unitToSuccs = new HashMap(size * 2 + 1, 0.7f);
        this.unitToPreds = new HashMap(size * 2 + 1, 0.7f);
        this.buildUnexceptionalEdges(this.unitToSuccs, this.unitToPreds);
        this.addAuxiliaryExceptionalEdges();
        this.buildHeadsAndTails();
        this.handleExplicitThrowEdges();
        this.buildHeadsAndTails();
        this.handleMultipleReturns();
        this.buildHeadsAndTails();
        this.removeBogusHeads();
        this.buildHeadsAndTails();
        EnhancedUnitGraph.makeMappedListsUnmodifiable(this.unitToSuccs);
        EnhancedUnitGraph.makeMappedListsUnmodifiable(this.unitToPreds);
    }

    protected void handleMultipleReturns() {
        if (this.getTails().size() > 1) {
            ExitStmt stop = new ExitStmt();
            ArrayList<Unit> predsOfstop = new ArrayList<Unit>();
            for (Unit tail : this.getTails()) {
                predsOfstop.add(tail);
                List tailSuccs = (List)this.unitToSuccs.get(tail);
                tailSuccs.add(stop);
            }
            this.unitToPreds.put(stop, predsOfstop);
            this.unitToSuccs.put(stop, new ArrayList());
            Chain<Unit> units = this.body.getUnits().getNonPatchingChain();
            if (!units.contains(stop)) {
                units.addLast(stop);
            }
        }
    }

    protected void removeBogusHeads() {
        PatchingChain<Unit> units = this.body.getUnits();
        Unit trueHead = (Unit)units.getFirst();
        while (this.getHeads().size() > 1) {
            for (Unit head : this.getHeads()) {
                if (trueHead == head) continue;
                this.unitToPreds.remove(head);
                List succs = (List)this.unitToSuccs.get(head);
                Iterator succsItr = succs.iterator();
                while (succsItr.hasNext()) {
                    ArrayList<Unit> tobeRemoved = new ArrayList<Unit>();
                    Unit succ = (Unit)succsItr.next();
                    List predOfSuccs = (List)this.unitToPreds.get(succ);
                    for (Unit pred : predOfSuccs) {
                        if (pred != head) continue;
                        tobeRemoved.add(pred);
                    }
                    predOfSuccs.removeAll(tobeRemoved);
                }
                this.unitToSuccs.remove(head);
                if (!units.contains(head)) continue;
                units.remove(head);
            }
            this.buildHeadsAndTails();
        }
    }

    protected void handleExplicitThrowEdges() {
        MHGDominatorTree<Unit> dom = new MHGDominatorTree<Unit>(new MHGDominatorsFinder<Unit>(this));
        MHGDominatorTree<Unit> pdom = new MHGDominatorTree<Unit>(new MHGPostDominatorsFinder<Unit>(this));
        Hashtable<Unit, Unit> x2mergePoint = new Hashtable<Unit, Unit>();
        List<Unit> tails = this.getTails();
        block0: for (Unit tail : tails) {
            if (!(tail instanceof ThrowStmt)) continue;
            DominatorNode<Unit> x = dom.getDode(tail);
            DominatorNode<Unit> parentOfX = dom.getParentOf(x);
            Unit xgode = x.getGode();
            DominatorNode<Unit> xpdomDode = pdom.getDode(xgode);
            Unit parentXGode = parentOfX.getGode();
            DominatorNode<Unit> parentpdomDode = pdom.getDode(parentXGode);
            while (pdom.isDominatorOf(xpdomDode, parentpdomDode)) {
                x = parentOfX;
                if ((parentOfX = dom.getParentOf(x)) == null) break;
                xgode = x.getGode();
                xpdomDode = pdom.getDode(xgode);
                parentXGode = parentOfX.getGode();
                parentpdomDode = pdom.getDode(parentXGode);
            }
            if (parentOfX != null) {
                x = parentOfX;
            }
            xgode = x.getGode();
            xpdomDode = pdom.getDode(xgode);
            Unit mergePoint = null;
            if (x2mergePoint.containsKey(xgode)) {
                mergePoint = (Unit)x2mergePoint.get(xgode);
            } else {
                List<DominatorNode<Unit>> domChilds = dom.getChildrenOf(x);
                Unit child1god = null;
                Unit child2god = null;
                for (DominatorNode<Unit> child : domChilds) {
                    Unit childGode = child.getGode();
                    DominatorNode<Unit> childpdomDode = pdom.getDode(childGode);
                    List<Unit> path = this.getExtendedBasicBlockPathBetween(childGode, tail);
                    if (path != null && !path.isEmpty()) continue;
                    if (pdom.isDominatorOf(childpdomDode, xpdomDode)) {
                        mergePoint = child.getGode();
                        break;
                    }
                    if (child1god == null) {
                        child1god = childGode;
                        continue;
                    }
                    if (child2god != null) continue;
                    child2god = childGode;
                }
                if (mergePoint == null) {
                    if (child1god != null && child2god != null) {
                        DominatorNode<Object> child1 = pdom.getDode(child1god);
                        DominatorNode<Object> child2 = pdom.getDode(child2god);
                        DominatorNode<Object> comParent = child1.getParent();
                        while (comParent != null) {
                            if (pdom.isDominatorOf(comParent, child2)) {
                                mergePoint = comParent.getGode();
                                break;
                            }
                            comParent = comParent.getParent();
                        }
                    } else if (child1god != null || child2god != null) {
                        DominatorNode<Unit> initialY;
                        DominatorNode<Object> y = null;
                        if (child1god != null) {
                            y = pdom.getDode(child1god);
                        } else if (child2god != null) {
                            y = pdom.getDode(child2god);
                        }
                        DominatorNode<Unit> yDodeInDom = initialY = dom.getDode(y.getGode());
                        while (dom.isDominatorOf(x, yDodeInDom)) {
                            if ((y = y.getParent()) == null) break;
                            yDodeInDom = dom.getDode(y.getGode());
                        }
                        mergePoint = y != null ? (Unit)y.getGode() : initialY.getGode();
                    }
                }
                if (mergePoint == null) {
                    List xSucc = (List)this.unitToSuccs.get(x.getGode());
                    for (Unit u : xSucc) {
                        if (dom.isDominatorOf(dom.getDode(u), dom.getDode(tail))) continue;
                        DominatorNode<Unit> y = pdom.getDode(u);
                        while (dom.isDominatorOf(x, y)) {
                            if ((y = y.getParent()) == null) continue block0;
                        }
                        mergePoint = y.getGode();
                        break;
                    }
                } else if (dom.isDominatorOf(dom.getDode(mergePoint), dom.getDode(tail))) continue;
                if (mergePoint == null) continue;
                x2mergePoint.put(xgode, mergePoint);
            }
            if (!this.unitToSuccs.containsKey(tail)) {
                this.unitToSuccs.put(tail, new ArrayList());
            }
            List throwSuccs = (List)this.unitToSuccs.get(tail);
            throwSuccs.add(mergePoint);
            List mergePreds = (List)this.unitToPreds.get(mergePoint);
            mergePreds.add(tail);
        }
    }

    protected void addAuxiliaryExceptionalEdges() {
        for (Trap trap : this.body.getTraps()) {
            Unit ehnop;
            Unit handler;
            Unit pred = handler = trap.getHandlerUnit();
            while (((List)this.unitToPreds.get(pred)).size() > 0) {
                pred = (Unit)((List)this.unitToPreds.get(pred)).get(0);
            }
            this.handler2header.put(handler, pred);
            if (this.try2nop.containsKey(trap.getBeginUnit())) {
                ehnop = this.try2nop.get(trap.getBeginUnit());
                continue;
            }
            ehnop = new EHNopStmt();
            this.try2nop.put(trap.getBeginUnit(), ehnop);
        }
        Hashtable<Unit, Boolean> nop2added = new Hashtable<Unit, Boolean>();
        block2: for (Trap trap : this.body.getTraps()) {
            List succsOfehnop;
            Unit b = trap.getBeginUnit();
            Unit handler = trap.getHandlerUnit();
            if (!this.unitToPreds.containsKey(handler = this.handler2header.get(handler))) continue;
            List handlerPreds = (List)this.unitToPreds.get(handler);
            Iterator preditr = handlerPreds.iterator();
            while (preditr.hasNext()) {
                if (this.try2nop.containsValue(preditr.next())) continue block2;
            }
            Unit ehnop = this.try2nop.get(b);
            if (!nop2added.containsKey(ehnop)) {
                List<Unit> predsOfB = this.getPredsOf(b);
                ArrayList<Unit> predsOfehnop = new ArrayList<Unit>(predsOfB);
                for (Unit a : predsOfB) {
                    List succsOfA = (List)this.unitToSuccs.get(a);
                    succsOfA.remove(b);
                    succsOfA.add(ehnop);
                }
                predsOfB.clear();
                predsOfB.add(ehnop);
                this.unitToPreds.put(ehnop, predsOfehnop);
            }
            if (!this.unitToSuccs.containsKey(ehnop)) {
                this.unitToSuccs.put(ehnop, new ArrayList());
            }
            if (!(succsOfehnop = (List)this.unitToSuccs.get(ehnop)).contains(b)) {
                succsOfehnop.add(b);
            }
            succsOfehnop.add(handler);
            if (!this.unitToPreds.containsKey(handler)) {
                this.unitToPreds.put(handler, new ArrayList());
            }
            List predsOfhandler = (List)this.unitToPreds.get(handler);
            predsOfhandler.add(ehnop);
            Chain<Unit> units = this.body.getUnits().getNonPatchingChain();
            if (!units.contains(ehnop)) {
                units.insertBefore(ehnop, b);
            }
            nop2added.put(ehnop, Boolean.TRUE);
        }
    }
}

