/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph.pdg;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import soot.Body;
import soot.SootClass;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.DominatorTree;
import soot.toolkits.graph.HashMutableEdgeLabelledDirectedGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.graph.pdg.ConditionalPDGNode;
import soot.toolkits.graph.pdg.IRegion;
import soot.toolkits.graph.pdg.LoopedPDGNode;
import soot.toolkits.graph.pdg.PDGNode;
import soot.toolkits.graph.pdg.PDGRegion;
import soot.toolkits.graph.pdg.ProgramDependenceGraph;
import soot.toolkits.graph.pdg.Region;
import soot.toolkits.graph.pdg.RegionAnalysis;

public class HashMutablePDG
extends HashMutableEdgeLabelledDirectedGraph<PDGNode, String>
implements ProgramDependenceGraph {
    protected Body m_body = null;
    protected SootClass m_class = null;
    protected UnitGraph m_cfg = null;
    protected BlockGraph m_blockCFG = null;
    protected Hashtable<Object, PDGNode> m_obj2pdgNode = new Hashtable();
    protected List<Region> m_weakRegions = null;
    protected List<Region> m_strongRegions = null;
    protected PDGNode m_startNode = null;
    protected List<PDGRegion> m_pdgRegions = null;
    private RegionAnalysis m_regionAnalysis = null;
    private int m_strongRegionStartID;
    private static Hashtable<PDGNode, PDGRegion> node2Region = new Hashtable();

    public HashMutablePDG(UnitGraph cfg) {
        this.m_body = cfg.getBody();
        this.m_class = this.m_body.getMethod().getDeclaringClass();
        this.m_cfg = cfg;
        this.m_regionAnalysis = new RegionAnalysis(this.m_cfg, this.m_body.getMethod(), this.m_class);
        this.m_strongRegions = this.m_regionAnalysis.getRegions();
        this.m_weakRegions = this.cloneRegions(this.m_strongRegions);
        this.m_blockCFG = this.m_regionAnalysis.getBlockCFG();
        this.constructPDG();
        this.m_pdgRegions = HashMutablePDG.computePDGRegions(this.m_startNode);
        IRegion r = this.m_pdgRegions.get(0);
        while (r.getParent() != null) {
            r = r.getParent();
        }
        this.m_startNode.setNode(r);
    }

    @Override
    public BlockGraph getBlockGraph() {
        return this.m_blockCFG;
    }

    protected void constructPDG() {
        Hashtable<Block, Region> block2region = this.m_regionAnalysis.getBlock2RegionMap();
        DominatorTree<Block> pdom = this.m_regionAnalysis.getPostDominatorTree();
        DominatorTree<Block> dom = this.m_regionAnalysis.getDominatorTree();
        LinkedList<Region> regions2process = new LinkedList<Region>();
        Region topLevelRegion = this.m_regionAnalysis.getTopLevelRegion();
        this.m_strongRegionStartID = this.m_weakRegions.size();
        PDGNode pdgnode = new PDGNode(topLevelRegion, PDGNode.Type.REGION);
        this.addNode(pdgnode);
        this.m_obj2pdgNode.put(topLevelRegion, pdgnode);
        this.m_startNode = pdgnode;
        topLevelRegion.setParent(null);
        HashSet<Region> processedRegions = new HashSet<Region>();
        regions2process.add(topLevelRegion);
        while (!regions2process.isEmpty()) {
            Region r = (Region)regions2process.remove(0);
            processedRegions.add(r);
            pdgnode = this.m_obj2pdgNode.get(r);
            List<Block> blocks = r.getBlocks();
            Hashtable toBeRemoved = new Hashtable();
            PDGNode prevPDGNodeInRegion = null;
            PDGNode curNodeInRegion = null;
            for (Block a : blocks) {
                PDGNode pdgNodeOfA = null;
                if (!this.m_obj2pdgNode.containsKey(a)) {
                    pdgNodeOfA = new PDGNode(a, PDGNode.Type.CFGNODE);
                    this.addNode(pdgNodeOfA);
                    this.m_obj2pdgNode.put(a, pdgNodeOfA);
                } else {
                    pdgNodeOfA = this.m_obj2pdgNode.get(a);
                }
                this.addEdge(pdgnode, pdgNodeOfA, "dependency");
                pdgnode.addDependent(pdgNodeOfA);
                curNodeInRegion = pdgNodeOfA;
                List<Block> bs = this.m_blockCFG.getSuccsOf(a);
                Iterator<Block> bItr = bs.iterator();
                while (bItr.hasNext()) {
                    ArrayList<Block> dependents = new ArrayList<Block>();
                    Block b = bItr.next();
                    if (b.equals(a)) {
                        throw new RuntimeException("PDG construction: A and B are not supposed to be the same node!");
                    }
                    DominatorNode<Block> aDode = pdom.getDode(a);
                    DominatorNode<Block> bDode = pdom.getDode(b);
                    if (pdom.isDominatorOf(bDode, aDode)) continue;
                    DominatorNode<Block> aParentDode = aDode.getParent();
                    DominatorNode<Block> dode = bDode;
                    while (dode != aParentDode) {
                        dependents.add(dode.getGode());
                        if (dode.getParent() == null) break;
                        dode = dode.getParent();
                    }
                    if (pdgNodeOfA.getAttrib() != PDGNode.Attribute.CONDHEADER) {
                        PDGNode oldA = pdgNodeOfA;
                        pdgNodeOfA = new ConditionalPDGNode(pdgNodeOfA);
                        this.replaceInGraph(pdgNodeOfA, oldA);
                        pdgnode.removeDependent(oldA);
                        this.m_obj2pdgNode.put(a, pdgNodeOfA);
                        pdgnode.addDependent(pdgNodeOfA);
                        pdgNodeOfA.setAttrib(PDGNode.Attribute.CONDHEADER);
                        curNodeInRegion = pdgNodeOfA;
                    }
                    ArrayList<Block> copyOfDependents = new ArrayList<Block>();
                    copyOfDependents.addAll(dependents);
                    Region regionOfB = block2region.get(b);
                    PDGNode pdgnodeOfBRegion = null;
                    if (!this.m_obj2pdgNode.containsKey(regionOfB)) {
                        pdgnodeOfBRegion = new PDGNode(regionOfB, PDGNode.Type.REGION);
                        this.addNode(pdgnodeOfBRegion);
                        this.m_obj2pdgNode.put(regionOfB, pdgnodeOfBRegion);
                    } else {
                        pdgnodeOfBRegion = this.m_obj2pdgNode.get(regionOfB);
                    }
                    regionOfB.setParent(r);
                    r.addChildRegion(regionOfB);
                    this.addEdge(pdgNodeOfA, pdgnodeOfBRegion, "dependency");
                    pdgNodeOfA.addDependent(pdgnodeOfBRegion);
                    if (!processedRegions.contains(regionOfB)) {
                        regions2process.add(regionOfB);
                    }
                    copyOfDependents.remove(b);
                    copyOfDependents.removeAll(regionOfB.getBlocks());
                    while (!copyOfDependents.isEmpty()) {
                        PDGNode pdgnodeOfdepBRegion;
                        Block depB = (Block)copyOfDependents.remove(0);
                        Region rdepB = block2region.get(depB);
                        PDGNode depBPDGNode = this.m_obj2pdgNode.get(depB);
                        if (depBPDGNode == null) {
                            pdgnodeOfdepBRegion = null;
                            if (!this.m_obj2pdgNode.containsKey(rdepB)) {
                                pdgnodeOfdepBRegion = new PDGNode(rdepB, PDGNode.Type.REGION);
                                this.addNode(pdgnodeOfdepBRegion);
                                this.m_obj2pdgNode.put(rdepB, pdgnodeOfdepBRegion);
                            } else {
                                pdgnodeOfdepBRegion = this.m_obj2pdgNode.get(rdepB);
                            }
                            rdepB.setParent(regionOfB);
                            regionOfB.addChildRegion(rdepB);
                            this.addEdge(pdgnodeOfBRegion, pdgnodeOfdepBRegion, "dependency");
                            pdgnodeOfBRegion.addDependent(pdgnodeOfdepBRegion);
                            if (!processedRegions.contains(rdepB)) {
                                regions2process.add(rdepB);
                            }
                            copyOfDependents.removeAll(rdepB.getBlocks());
                            continue;
                        }
                        if (dependents.containsAll(rdepB.getBlocks())) {
                            pdgnodeOfdepBRegion = null;
                            if (!this.m_obj2pdgNode.containsKey(rdepB)) {
                                pdgnodeOfdepBRegion = new PDGNode(rdepB, PDGNode.Type.REGION);
                                this.addNode(pdgnodeOfdepBRegion);
                                this.m_obj2pdgNode.put(rdepB, pdgnodeOfdepBRegion);
                            } else {
                                pdgnodeOfdepBRegion = this.m_obj2pdgNode.get(rdepB);
                            }
                            this.addEdge(pdgnodeOfBRegion, pdgnodeOfdepBRegion, "dependency");
                            pdgnodeOfBRegion.addDependent(pdgnodeOfdepBRegion);
                            if (!processedRegions.contains(rdepB)) {
                                regions2process.add(rdepB);
                            }
                            copyOfDependents.removeAll(rdepB.getBlocks());
                            continue;
                        }
                        PDGNode predPDGofdepB = this.getPredsOf(depBPDGNode).get(0);
                        assert (this.m_obj2pdgNode.containsKey(rdepB));
                        PDGNode pdgnodeOfdepBRegion2 = this.m_obj2pdgNode.get(rdepB);
                        if (predPDGofdepB == pdgnodeOfdepBRegion2) {
                            PDGNode next;
                            PDGNode loopBodyPDGNode;
                            List<Block> blocks2BRemoved;
                            Region newRegion = new Region(this.m_strongRegionStartID++, topLevelRegion.getSootMethod(), topLevelRegion.getSootClass(), this.m_cfg);
                            newRegion.add(depB);
                            this.m_strongRegions.add(newRegion);
                            if (toBeRemoved.contains(predPDGofdepB)) {
                                blocks2BRemoved = (List)toBeRemoved.get(predPDGofdepB);
                            } else {
                                blocks2BRemoved = new ArrayList();
                                toBeRemoved.put(rdepB, blocks2BRemoved);
                            }
                            blocks2BRemoved.add(depB);
                            LoopedPDGNode newpdgnode = new LoopedPDGNode(newRegion, PDGNode.Type.REGION, depBPDGNode);
                            this.addNode(newpdgnode);
                            this.m_obj2pdgNode.put(newRegion, newpdgnode);
                            newpdgnode.setAttrib(PDGNode.Attribute.LOOPHEADER);
                            depBPDGNode.setAttrib(PDGNode.Attribute.LOOPHEADER);
                            this.removeEdge(pdgnodeOfdepBRegion2, depBPDGNode, "dependency");
                            pdgnodeOfdepBRegion2.removeDependent(depBPDGNode);
                            this.addEdge(pdgnodeOfdepBRegion2, newpdgnode, "dependency");
                            this.addEdge(newpdgnode, depBPDGNode, "dependency");
                            pdgnodeOfdepBRegion2.addDependent(newpdgnode);
                            newpdgnode.addDependent(depBPDGNode);
                            if (depB == a) {
                                loopBodyPDGNode = this.getSuccsOf(depBPDGNode).get(0);
                                this.addEdge(depBPDGNode, newpdgnode, "dependency-back");
                                newpdgnode.setBody(loopBodyPDGNode);
                                depBPDGNode.addBackDependent(newpdgnode);
                                curNodeInRegion = newpdgnode;
                                continue;
                            }
                            pdgnodeOfBRegion.addBackDependent(newpdgnode);
                            this.addEdge(pdgnodeOfBRegion, newpdgnode, "dependency-back");
                            loopBodyPDGNode = null;
                            List<PDGNode> successors = this.getSuccsOf(depBPDGNode);
                            for (PDGNode succRPDGNode : successors) {
                                DominatorNode<Block> adode;
                                assert (succRPDGNode.getType() == PDGNode.Type.REGION);
                                Region succR = (Region)succRPDGNode.getNode();
                                Block h = succR.getBlocks().get(0);
                                DominatorNode<Block> hdode = dom.getDode(h);
                                if (!dom.isDominatorOf(hdode, adode = dom.getDode(a))) continue;
                                loopBodyPDGNode = succRPDGNode;
                                break;
                            }
                            assert (loopBodyPDGNode != null);
                            newpdgnode.setBody(loopBodyPDGNode);
                            PDGNode prev = depBPDGNode.getPrev();
                            if (prev != null) {
                                this.removeEdge(prev, depBPDGNode, "controlflow");
                                this.addEdge(prev, newpdgnode, "controlflow");
                                prev.setNext(newpdgnode);
                                newpdgnode.setPrev(prev);
                                depBPDGNode.setPrev(null);
                            }
                            if ((next = depBPDGNode.getNext()) == null) continue;
                            this.removeEdge(depBPDGNode, next, "controlflow");
                            this.addEdge(newpdgnode, next, "controlflow");
                            newpdgnode.setNext(next);
                            next.setPrev(newpdgnode);
                            depBPDGNode.setNext(null);
                            continue;
                        }
                        this.addEdge(pdgnodeOfBRegion, predPDGofdepB, "dependency-back");
                        pdgnodeOfBRegion.addBackDependent(predPDGofdepB);
                    }
                }
                if (prevPDGNodeInRegion != null) {
                    this.addEdge(prevPDGNodeInRegion, curNodeInRegion, "controlflow");
                    prevPDGNodeInRegion.setNext(curNodeInRegion);
                    curNodeInRegion.setPrev(prevPDGNodeInRegion);
                }
                prevPDGNodeInRegion = curNodeInRegion;
            }
            Enumeration itr1 = toBeRemoved.keys();
            while (itr1.hasMoreElements()) {
                Region region = (Region)itr1.nextElement();
                Iterator blockItr = ((List)toBeRemoved.get(region)).iterator();
                while (blockItr.hasNext()) {
                    region.remove((Block)blockItr.next());
                }
            }
        }
    }

    private List<Region> cloneRegions(List<Region> weak) {
        ArrayList<Region> strong = new ArrayList<Region>();
        for (Region r : weak) {
            strong.add((Region)r.clone());
        }
        return strong;
    }

    public UnitGraph getCFG() {
        return this.m_cfg;
    }

    @Override
    public List<Region> getWeakRegions() {
        return this.m_weakRegions;
    }

    @Override
    public List<Region> getStrongRegions() {
        return this.m_strongRegions;
    }

    @Override
    public IRegion GetStartRegion() {
        return this.m_pdgRegions.get(0);
    }

    @Override
    public PDGNode GetStartNode() {
        return this.m_startNode;
    }

    public static List<IRegion> getPreorderRegionList(IRegion r) {
        ArrayList<IRegion> list = new ArrayList<IRegion>();
        LinkedList<IRegion> toProcess = new LinkedList<IRegion>();
        toProcess.add(r);
        while (!toProcess.isEmpty()) {
            IRegion reg = (IRegion)toProcess.poll();
            list.add(reg);
            Iterator<IRegion> itr = reg.getChildRegions().iterator();
            while (itr.hasNext()) {
                toProcess.add((Region)itr.next());
            }
        }
        return list;
    }

    public static List<IRegion> getPostorderRegionList(IRegion r) {
        ArrayList<IRegion> list = new ArrayList<IRegion>();
        HashMutablePDG.postorder(r, list);
        return list;
    }

    private static List<IRegion> postorder(IRegion r, List<IRegion> list) {
        if (!r.getChildRegions().isEmpty()) {
            Iterator<IRegion> itr = r.getChildRegions().iterator();
            while (itr.hasNext()) {
                HashMutablePDG.postorder(itr.next(), list);
            }
        }
        list.add(r);
        return list;
    }

    @Override
    public List<PDGRegion> getPDGRegions() {
        return this.m_pdgRegions;
    }

    public static List<PDGRegion> getPostorderPDGRegionList(PDGNode r) {
        return HashMutablePDG.computePDGRegions(r);
    }

    private static List<PDGRegion> computePDGRegions(PDGNode root) {
        ArrayList<PDGRegion> regions = new ArrayList<PDGRegion>();
        node2Region.clear();
        HashMutablePDG.pdgpostorder(root, regions);
        return regions;
    }

    private static PDGRegion pdgpostorder(PDGNode node, List<PDGRegion> list) {
        if (node.getVisited()) {
            return null;
        }
        node.setVisited(true);
        PDGRegion region = null;
        if (!node2Region.containsKey(node)) {
            region = new PDGRegion(node);
            node2Region.put(node, region);
        } else {
            region = node2Region.get(node);
        }
        List<PDGNode> dependents = node.getDependets();
        if (!dependents.isEmpty()) {
            for (PDGNode curNode : dependents) {
                if (curNode.getVisited()) continue;
                region.addPDGNode(curNode);
                if (curNode instanceof LoopedPDGNode) {
                    PDGNode body = ((LoopedPDGNode)curNode).getBody();
                    PDGRegion kid = HashMutablePDG.pdgpostorder(body, list);
                    if (kid == null) continue;
                    kid.setParent(region);
                    region.addChildRegion(kid);
                    body.setNode(kid);
                    continue;
                }
                if (!(curNode instanceof ConditionalPDGNode)) continue;
                List<PDGNode> childs = curNode.getDependets();
                for (PDGNode child : childs) {
                    PDGRegion kid = HashMutablePDG.pdgpostorder(child, list);
                    if (kid == null) continue;
                    kid.setParent(region);
                    region.addChildRegion(kid);
                    child.setNode(kid);
                }
            }
        }
        list.add(region);
        return region;
    }

    @Override
    public boolean dependentOn(PDGNode node1, PDGNode node2) {
        return node2.getDependets().contains(node1);
    }

    @Override
    public List<PDGNode> getDependents(PDGNode node) {
        ArrayList<PDGNode> toReturn = new ArrayList<PDGNode>();
        for (PDGNode succ : this.getSuccsOf(node)) {
            if (!this.dependentOn(succ, node)) continue;
            toReturn.add(succ);
        }
        return toReturn;
    }

    @Override
    public PDGNode getPDGNode(Object cfgNode) {
        if (cfgNode != null && cfgNode instanceof Block && this.m_obj2pdgNode.containsKey(cfgNode)) {
            return this.m_obj2pdgNode.get(cfgNode);
        }
        return null;
    }

    private void replaceInGraph(PDGNode newnode, PDGNode oldnode) {
        List labels;
        this.addNode(newnode);
        Object graph = this.clone();
        List<PDGNode> succs = ((HashMutableEdgeLabelledDirectedGraph)graph).getSuccsOf(oldnode);
        List<PDGNode> preds = ((HashMutableEdgeLabelledDirectedGraph)graph).getPredsOf(oldnode);
        for (PDGNode succ : succs) {
            labels = ((HashMutableEdgeLabelledDirectedGraph)graph).getLabelsForEdges(oldnode, succ);
            for (Object label : labels) {
                this.addEdge(newnode, succ, new String(label.toString()));
            }
        }
        for (PDGNode pred : preds) {
            labels = ((HashMutableEdgeLabelledDirectedGraph)graph).getLabelsForEdges(pred, oldnode);
            for (Object label : labels) {
                this.addEdge(pred, newnode, new String(label.toString()));
            }
        }
        this.removeNode(oldnode);
    }

    @Override
    public void removeAllEdges(PDGNode from, PDGNode to) {
        if (!this.containsAnyEdge(from, to)) {
            return;
        }
        ArrayList labels = new ArrayList(this.getLabelsForEdges(from, to));
        for (String label : labels) {
            this.removeEdge(from, to, label);
        }
    }

    @Override
    public String toString() {
        String s = new String("\nProgram Dependence Graph for Method " + this.m_body.getMethod().getName());
        s = String.valueOf(s) + "\n*********CFG******** \n" + RegionAnalysis.CFGtoString(this.m_blockCFG, true);
        s = String.valueOf(s) + "\n*********PDG******** \n";
        ArrayList<PDGNode> processed = new ArrayList<PDGNode>();
        LinkedList<PDGNode> nodes = new LinkedList<PDGNode>();
        nodes.offer(this.m_startNode);
        while (nodes.peek() != null) {
            PDGNode node = (PDGNode)nodes.remove();
            processed.add(node);
            s = String.valueOf(s) + "\n Begin PDGNode: " + node;
            List<PDGNode> succs = this.getSuccsOf(node);
            s = String.valueOf(s) + "\n has " + succs.size() + " successors:\n";
            int i = 0;
            for (PDGNode succ : succs) {
                List labels = this.getLabelsForEdges(node, succ);
                s = String.valueOf(s) + i++;
                s = String.valueOf(s) + ": Edge's label: " + labels + " \n";
                s = String.valueOf(s) + "   Target: " + succ.toShortString();
                s = String.valueOf(s) + "\n";
                if (!((String)labels.get(0)).equals("dependency") || processed.contains(succ)) continue;
                nodes.offer(succ);
            }
            s = String.valueOf(s) + "\n End PDGNode.";
        }
        return s;
    }
}

