/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph.pdg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import soot.G;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.options.Options;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.graph.pdg.IRegion;
import soot.toolkits.graph.pdg.LoopedPDGNode;
import soot.toolkits.graph.pdg.PDGNode;

public class PDGRegion
implements IRegion,
Iterable<PDGNode> {
    private SootClass m_class = null;
    private SootMethod m_method = null;
    private List<PDGNode> m_nodes = null;
    private List<Unit> m_units = null;
    private LinkedHashMap<Unit, PDGNode> m_unit2pdgnode = null;
    private int m_id = -1;
    private UnitGraph m_unitGraph = null;
    private PDGNode m_corrspondingPDGNode = null;
    private IRegion m_parent = null;
    private List<IRegion> m_children = new ArrayList<IRegion>();

    public PDGRegion(int id, SootMethod m, SootClass c, UnitGraph ug, PDGNode node) {
        this(id, new ArrayList<PDGNode>(), m, c, ug, node);
    }

    public PDGRegion(int id, List<PDGNode> nodes, SootMethod m, SootClass c, UnitGraph ug, PDGNode node) {
        this.m_nodes = nodes;
        this.m_id = id;
        this.m_method = m;
        this.m_class = c;
        this.m_unitGraph = ug;
        this.m_units = null;
        this.m_corrspondingPDGNode = node;
        if (Options.v().verbose()) {
            G.v().out.println("New pdg region create: " + id);
        }
    }

    public PDGRegion(PDGNode node) {
        this(((IRegion)node.getNode()).getID(), new ArrayList<PDGNode>(), ((IRegion)node.getNode()).getSootMethod(), ((IRegion)node.getNode()).getSootClass(), ((IRegion)node.getNode()).getUnitGraph(), node);
    }

    public PDGNode getCorrespondingPDGNode() {
        return this.m_corrspondingPDGNode;
    }

    public Object clone() {
        PDGRegion r = new PDGRegion(this.m_id, this.m_method, this.m_class, this.m_unitGraph, this.m_corrspondingPDGNode);
        r.m_nodes = (List)((ArrayList)this.m_nodes).clone();
        return r;
    }

    @Override
    public SootMethod getSootMethod() {
        return this.m_method;
    }

    @Override
    public SootClass getSootClass() {
        return this.m_class;
    }

    public List<PDGNode> getNodes() {
        return this.m_nodes;
    }

    @Override
    public UnitGraph getUnitGraph() {
        return this.m_unitGraph;
    }

    @Override
    public Iterator<PDGNode> iterator() {
        return new ChildPDGFlowIterator(this.m_nodes);
    }

    @Override
    public List<Unit> getUnits() {
        if (this.m_units == null) {
            this.m_units = new LinkedList<Unit>();
            this.m_unit2pdgnode = new LinkedHashMap();
            for (PDGNode node : this) {
                if (node.getType() == PDGNode.Type.REGION) {
                    if (!(node instanceof LoopedPDGNode)) continue;
                    LoopedPDGNode n = (LoopedPDGNode)node;
                    PDGNode header = n.getHeader();
                    Block headerBlock = (Block)header.getNode();
                    for (Unit u : headerBlock) {
                        ((LinkedList)this.m_units).addLast(u);
                        this.m_unit2pdgnode.put(u, header);
                    }
                    continue;
                }
                if (node.getType() == PDGNode.Type.CFGNODE) {
                    Block b = (Block)node.getNode();
                    for (Unit u : b) {
                        ((LinkedList)this.m_units).addLast(u);
                        this.m_unit2pdgnode.put(u, node);
                    }
                    continue;
                }
                throw new RuntimeException("Exception in PDGRegion.getUnits: PDGNode's type is undefined!");
            }
        }
        return this.m_units;
    }

    public PDGNode unit2PDGNode(Unit u) {
        if (this.m_unit2pdgnode.containsKey(u)) {
            return this.m_unit2pdgnode.get(u);
        }
        return null;
    }

    @Override
    public List<Unit> getUnits(Unit from, Unit to) {
        return this.m_units.subList(this.m_units.indexOf(from), this.m_units.indexOf(to));
    }

    @Override
    public Unit getLast() {
        if (this.m_units != null && this.m_units.size() > 0) {
            return (Unit)((LinkedList)this.m_units).getLast();
        }
        return null;
    }

    @Override
    public Unit getFirst() {
        if (this.m_units != null && this.m_units.size() > 0) {
            return (Unit)((LinkedList)this.m_units).getFirst();
        }
        return null;
    }

    @Override
    public List<Block> getBlocks() {
        return new ArrayList<Block>();
    }

    public void addPDGNode(PDGNode node) {
        this.m_nodes.add(node);
    }

    @Override
    public int getID() {
        return this.m_id;
    }

    @Override
    public boolean occursBefore(Unit u1, Unit u2) {
        int i = this.m_units.lastIndexOf(u1);
        int j = this.m_units.lastIndexOf(u2);
        if (i == -1 || j == -1) {
            throw new RuntimeException("These units don't exist in the region!");
        }
        return i < j;
    }

    @Override
    public void setParent(IRegion pr) {
        this.m_parent = pr;
    }

    @Override
    public IRegion getParent() {
        return this.m_parent;
    }

    @Override
    public void addChildRegion(IRegion chr) {
        if (!this.m_children.contains(chr)) {
            this.m_children.add(chr);
        }
    }

    @Override
    public List<IRegion> getChildRegions() {
        return this.m_children;
    }

    public String toString() {
        String str = new String();
        str = String.valueOf(str) + "Begin-----------PDGRegion:  " + this.m_id + "-------------\n";
        if (this.m_parent != null) {
            str = String.valueOf(str) + "Parent is: " + this.m_parent.getID() + "----\n";
        }
        str = String.valueOf(str) + "Children Regions are: ";
        Iterator<IRegion> ritr = this.m_children.iterator();
        while (ritr.hasNext()) {
            str = String.valueOf(str) + ritr.next().getID() + ", ";
        }
        str = String.valueOf(str) + "\nUnits are: \n";
        List<Unit> regionUnits = this.getUnits();
        for (Unit u : regionUnits) {
            str = String.valueOf(str) + u + "\n";
        }
        str = String.valueOf(str) + "End of PDG Region " + this.m_id + " -----------------------------\n";
        return str;
    }

    class ChildPDGFlowIterator
    implements Iterator<PDGNode> {
        List<PDGNode> m_list = null;
        PDGNode m_current = null;
        boolean beginning = true;

        public ChildPDGFlowIterator(List<PDGNode> list) {
            this.m_list = list;
        }

        @Override
        public boolean hasNext() {
            if (this.beginning && this.m_list.size() > 0) {
                return true;
            }
            return this.m_current != null && this.m_current.getNext() != null;
        }

        @Override
        public PDGNode next() {
            if (this.beginning) {
                this.beginning = false;
                this.m_current = this.m_list.get(0);
                while (this.m_current.getPrev() != null) {
                    this.m_current = this.m_current.getPrev();
                }
                if (this.m_current.getType() != PDGNode.Type.CFGNODE && this.m_current.getAttrib() != PDGNode.Attribute.LOOPHEADER) {
                    for (PDGNode dep : this.m_list) {
                        if (dep.getType() != PDGNode.Type.CFGNODE && dep.getAttrib() != PDGNode.Attribute.LOOPHEADER) continue;
                        this.m_current = dep;
                        while (this.m_current.getPrev() != null) {
                            this.m_current = this.m_current.getPrev();
                        }
                        break block1;
                    }
                }
                return this.m_current;
            }
            if (!this.hasNext()) {
                throw new RuntimeException("No more nodes!");
            }
            this.m_current = this.m_current.getNext();
            return this.m_current;
        }

        @Override
        public void remove() {
        }
    }
}

